//+------------------------------------------------------------------+
//|                                              SimpleScalp_MTF.mq5 |
//|                      Copyright  2011, MetaQuotes Software Corp. |
//|                             http://www.mql4.com/ru/users/kontra  |
//------------------------------------------------------------------+
#property copyright "Copyright  2011, MetaQuotes Software Corp."
#property link "http://www.mql4.com/ru/users/kontra"
#property description "  "
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Tomato 
#property indicator_color1  clrTomato
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "SimpleScalp_MTF Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        Lime 
#property indicator_color2  clrLime
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "SimpleScalp_MTF Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame1=PERIOD_H1;  //   1
input ENUM_TIMEFRAMES TimeFrame2=PERIOD_M30; //   2
input ENUM_TIMEFRAMES TimeFrame3=PERIOD_M15; //   3
//+----------------------------------------------+

//---   ,  
//---       
double SellBuffer[];
double BuyBuffer[];
//---      
int min_rates_total,ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   int ATR_Period=15;
   min_rates_total=int(2);
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---   
   if(TimeFrame1<=Period()) Alert("  1      !");
   if(TimeFrame2<=Period()) Alert("  2      !");
   if(TimeFrame3<=Period()) Alert("  3      !");

//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,178);
//---    ,   
   ArraySetAsSeries(SellBuffer,true);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,178);
//---    ,   
   ArraySetAsSeries(BuyBuffer,true);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="SimpleScalp_MTF";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(Bars(Symbol(),TimeFrame1)<min_rates_total
      || Bars(Symbol(),TimeFrame2)<min_rates_total
      || Bars(Symbol(),TimeFrame3)<min_rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---    
   int limit,to_copy;
   double iClose1[],iClose2[],iClose3[];
   double iOpen1[],iOpen2[],iOpen3[],ATR[];
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       
   to_copy=limit+1;
//---        ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---    ,     
   ArraySetAsSeries(iClose1,true);
   ArraySetAsSeries(iClose2,true);
   ArraySetAsSeries(iClose3,true);
   ArraySetAsSeries(iOpen1,true);
   ArraySetAsSeries(iOpen2,true);
   ArraySetAsSeries(iOpen3,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(time,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;

      if(CopyClose(Symbol(),TimeFrame1,time[bar],min_rates_total,iClose1)<=0) return(RESET);
      if(CopyClose(Symbol(),TimeFrame2,time[bar],min_rates_total,iClose2)<=0) return(RESET);
      if(CopyClose(Symbol(),TimeFrame3,time[bar],min_rates_total,iClose3)<=0) return(RESET);
      if(CopyOpen(Symbol(),TimeFrame1,time[bar],min_rates_total,iOpen1)<=0) return(RESET);
      if(CopyOpen(Symbol(),TimeFrame2,time[bar],min_rates_total,iOpen2)<=0) return(RESET);
      if(CopyOpen(Symbol(),TimeFrame3,time[bar],min_rates_total,iOpen3)<=0) return(RESET);

      if(iClose1[1]-iOpen1[1]>0 && iClose2[1]-iOpen2[1]>0 && iClose3[1]-iOpen3[1]>0 && close[bar+1]-open[bar+1]>0) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(iClose1[1]-iOpen1[1]<0 && iClose2[1]-iOpen2[1]<0 && iClose3[1]-iOpen3[1]<0 && close[bar+1]-open[bar+1]<0) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
