//+------------------------------------------------------------------+
//|                                                   TimeSeries.mqh |
//|                                        Copyright 2012, komposter |
//|                                         http://www.komposter.me/ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, komposter"
#property link      "http://www.komposter.me/"
//+------------------------------------------------------------------+
//| iTime
//+------------------------------------------------------------------+
datetime iTime(int bar)
  {
   if(bar<0) return(-1);

   datetime array[];
   if(CopyTime(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime iTime(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   datetime array[];
   if(CopyTime(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iOpen
//+------------------------------------------------------------------+
double iOpen(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyOpen(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iOpen(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyOpen(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iHigh
//+------------------------------------------------------------------+
double iHigh(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyHigh(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iHigh(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyHigh(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iLow
//+------------------------------------------------------------------+
double iLow(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyLow(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iLow(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyLow(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iClose
//+------------------------------------------------------------------+
double iClose(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyClose(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iClose(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyClose(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iHighest
//+------------------------------------------------------------------+
int iHighest(int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(_Symbol,_Period,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(bar_right+highest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighest(string symbol,ENUM_TIMEFRAMES timeframe,int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(symbol,timeframe,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(bar_right+highest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighest(datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(_Symbol,_Period,time_left,time_right,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(highest_bar+iBarShift(_Symbol,_Period,time_right));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighest(string symbol,ENUM_TIMEFRAMES timeframe,datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(symbol,timeframe,time_left,time_right,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(highest_bar+iBarShift(symbol,timeframe,time_right));
  }
//+------------------------------------------------------------------+
//| iLowest
//+------------------------------------------------------------------+
int iLowest(int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(_Symbol,_Period,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(bar_right+lowest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowest(string symbol,ENUM_TIMEFRAMES timeframe,int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(symbol,timeframe,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(bar_right+lowest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowest(datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(_Symbol,_Period,time_left,time_right,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(lowest_bar+iBarShift(_Symbol,_Period,time_right));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowest(string symbol,ENUM_TIMEFRAMES timeframe,datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(symbol,timeframe,time_left,time_right,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(lowest_bar+iBarShift(symbol,timeframe,time_right));
  }
//+------------------------------------------------------------------+
//| iBarShift
//+------------------------------------------------------------------+
int iBarShift(datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(_Symbol,_Period,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(_Symbol,_Period,time0,time,array)<0) return(-1);

   datetime temptime=iTime(_Symbol,_Period,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iBarShift(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(symbol,timeframe,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(symbol,timeframe,time0,time,array)<0) return(-1);

   datetime temptime=iTime(symbol,timeframe,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
