//+------------------------------------------------------------------+
//|                                               ExpertAdvanced.mqh |
//|                                      Copyright 2014, PunkBASSter |
//|                      https://login.mql5.com/en/users/punkbasster |
//+------------------------------------------------------------------+

#include "Expert.mqh"
#include "ExpertSignalAdvanced.mqh"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CExpertAdvanced : public CExpert
  {
protected:
   virtual bool      CheckTrailingOrderLong();
   virtual bool      CheckTrailingOrderShort();
   virtual bool      UpdateOrder(double price,double sl,double tp,datetime ex);

public:
                     CExpertAdvanced();
                    ~CExpertAdvanced();
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CExpertAdvanced::CExpertAdvanced()
  {
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CExpertAdvanced::~CExpertAdvanced()
  {
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Check for trailing long limit/stop order                         |
//+------------------------------------------------------------------+
bool CExpertAdvanced::CheckTrailingOrderLong(void)
  {
   CExpertSignalAdvanced *signal_ptr=m_signal;
//--- check the possibility of modifying the long order
   double price,sl,tp;
   datetime ex;
   if(signal_ptr.CheckUpdateOrderLong(GetPointer(m_order),price,sl,tp,ex))
      return(UpdateOrder(price,sl,tp,ex));
//--- return without operations
   return(false);
  }
//+------------------------------------------------------------------+
//| Check for trailing short limit/stop order                        |
//+------------------------------------------------------------------+
bool CExpertAdvanced::CheckTrailingOrderShort(void)
  {
   CExpertSignalAdvanced *signal_ptr=m_signal;
//--- check the possibility of modifying the short order
   double price,sl,tp;
   datetime ex;
   if(signal_ptr.CheckUpdateOrderShort(GetPointer(m_order),price,sl,tp,ex))
      return(UpdateOrder(price,sl,tp,ex));
//--- return without operations
   return(false);
  }
//+------------------------------------------------------------------+
//| Updates or deletes an out-of-date pending order                  |
//+------------------------------------------------------------------+
bool CExpertAdvanced::UpdateOrder(double price,double sl,double tp,datetime ex)
  {
//Print(m_order.Ticket());
   ulong  ticket=m_order.Ticket();
   if(price==EMPTY_VALUE)
      return(m_trade.OrderDelete(ticket));
//--- modifying the order
   return(m_trade.OrderModify(ticket,price,sl,tp,m_order.TypeTime(),ex));
  }
//+------------------------------------------------------------------+
