//+------------------------------------------------------------------+
//|                                               Stat_collector.mq5 |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, denkir"
#property link      "https://login.mql5.com/en/users/denkir"
#property version   "1.00"

#property script_show_inputs

#include <Arrays\List.mqh>
#include <Indicators\Trend.mqh>
#include <Indicators\TimeSeries.mqh>
#include "CVertLineNode.mqh"

//+------------------------------------------------------------------+
//|                          Inputs                                  |
//+------------------------------------------------------------------+
sinput string Info_general="+===General===+";   // +===General===+
input uint bars_to_collect=2000;                // Bars to collect
input string InpSymbol="EURUSD";                // Current symbol
input ENUM_TIMEFRAMES InpPeriod=PERIOD_H1;      // Current timeframe
input int InpMA_Period=21;                      // EMA period
sinput string Info_graph="+===Graphical===+";   // +===Graphical===+
input bool AreVerticalsPlotted=true;            // To plot vertical lines?
input color VertLine1_color=clrRed;             // 1st vertical line color
input color VertLine2_color=clrBlue;            // 2nd vertical line color
input ENUM_LINE_STYLE VertLine_style=STYLE_DOT; // Style of vertical lines

//+------------------------------------------------------------------+
//|                            Globals                               |
//+------------------------------------------------------------------+
uint time_series_length;     // time series length
uint dur_limits[]={5,10,15}; // duration limits

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- check time series length
   time_series_length=bars_to_collect;
   if(time_series_length<(uint)(InpMA_Period+1))
     {
      Print("EMA period exceeds time series length!");
      time_series_length=InpMA_Period+1;
      PrintFormat("Time series length value is changed for: %g",time_series_length);
     }
   uint local_bars_to_collect=(uint)Bars(InpSymbol,InpPeriod);
   if(local_bars_to_collect<time_series_length)
     {
      Print("Not enough bars!");
      return;
     }
//--- User lists
   CList myLinesLists[4];

//--- TIME SERIES
//--- create an object for access to open times of the bars in the history
   CiTime *ptr_Time=new CiTime;
   if(CheckPointer(ptr_Time)!=POINTER_DYNAMIC)
     {
      Print("CiTime object error!");
      return;
     }
   if(!ptr_Time.Create(InpSymbol,InpPeriod))
     {
      Print("Time series create error!");
      return;
     }
//--- create an object for using the Moving Average technical indicator
   CiMA *ptr_EMA=new CiMA;
   if(CheckPointer(ptr_EMA)!=POINTER_DYNAMIC)
     {
      Print("CiMA object error!");
      return;
     }
   if(!ptr_EMA.Create(InpSymbol,InpPeriod,InpMA_Period,0,MODE_EMA,0))
     {
      Print("EMA series create error!");
      return;
     }
//--- set new size of the series
   if(!ptr_Time.BufferResize(time_series_length))
     {
      Print("Time series resize error!");
      return;
     }
   ptr_Time.Refresh(-1);
   if(!ptr_EMA.BufferResize(time_series_length))
     {
      Print("EMA series resize error!");
      return;
     }
   ptr_EMA.Refresh(-1);
//--- check the time series data
   int bar_cnt=(int)(time_series_length-1);   // bars counter
   while(bar_cnt>=2)
     {
      double prev_ema1,last_ema1;
      datetime time_vline1,time_vline2;
      time_vline1=time_vline2=0; // zero out time
      //--- EMA data for the 1st point 
      prev_ema1=NormalizeDouble(ptr_EMA.Main(bar_cnt),_Digits+1);
      last_ema1=NormalizeDouble(ptr_EMA.Main(--bar_cnt),_Digits+1);
      //--- search the 1st point      
      if(prev_ema1>last_ema1)
        {
         time_vline1=ptr_Time.GetData(bar_cnt); // time of the 1st vertical line
         //--- create a node
         CVertLineNode *p_new_VertLine_node=new CVertLineNode();
         if(CheckPointer(p_new_VertLine_node)!=POINTER_DYNAMIC)
           {
            Print("CVertLineNode object error!");
            return;
           }
         while(bar_cnt>=0)        
           {
            double prev_ema2,last_ema2;
            //--- EMA data for the 2nd point 
            prev_ema2=NormalizeDouble(ptr_EMA.Main(bar_cnt),_Digits+1);
            last_ema2=NormalizeDouble(ptr_EMA.Main(--bar_cnt),_Digits+1);
            //--- search the second point
            if(prev_ema2<last_ema2)
              {
               time_vline2=ptr_Time.GetData(bar_cnt--); // time of the 2nd vertical line
               //--- calculate the current frame duration               
               uint curr_duration=(uint)((time_vline2-time_vline1)/PeriodSeconds(InpPeriod));
               //--- set the list index 
               int list_idx=0; // list index
               while(curr_duration>dur_limits[list_idx])
                 {
                  list_idx++;
                  if(list_idx==ArraySize(dur_limits))
                     break;
                 }
               int list_size=myLinesLists[list_idx].Total();
               //--- vertical line properties  
               SVertLineProperties _line1,_line2;
               //--- the 1st vertical line
               _line1.name="vertLine1_num"+IntegerToString(list_size+1)+
                           "_list"+IntegerToString(list_idx+1);
               _line1.time=time_vline1;
               _line1.clr=VertLine1_color;
               _line1.style=VertLine_style;
               //--- the 2nd vertical line
               _line2.name="vertLine2_num"+IntegerToString(list_size+1)+
                           "_list"+IntegerToString(list_idx+1);
               _line2.time=time_vline2;
               _line2.clr=VertLine2_color;
               _line2.style=VertLine_style;
               p_new_VertLine_node.SetLine(_line1);
               p_new_VertLine_node.SetLine(_line2,false);
               //--- To plot vertical lines?            
               if(AreVerticalsPlotted)
                  for(int line_idx=1;line_idx>=0;line_idx--)
                     p_new_VertLine_node.DrawLine(line_idx);

               //--- add a node
               p_new_VertLine_node.SetFrameFlag(true);
               myLinesLists[list_idx].Add(p_new_VertLine_node);
               break;
              }
           }
        }
     }
//---     
   for(int i=0;i<ArraySize(myLinesLists);i++)
     {
      Print("\n=======List #"+IntegerToString(i+1)+"=======");
      if(i<(ArraySize(myLinesLists)-1))
         Print("Duration limit: "+IntegerToString(dur_limits[i]));
      Print("Nodes number: "+IntegerToString(myLinesLists[i].Total()));
     }

//--- delete pointers
   if(CheckPointer(ptr_Time)==POINTER_DYNAMIC)
      delete ptr_Time;
   if(CheckPointer(ptr_EMA)==POINTER_DYNAMIC)
      delete ptr_EMA;
  }
//+------------------------------------------------------------------+
