//+------------------------------------------------------------------+
//|                                                 CiSingleList.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CiSingleNode.mqh"

//+------------------------------------------------------------------+
//|                      CiSingleList                           |
//+------------------------------------------------------------------+
class CiSingleList
  {
protected:
   CiSingleNode     *m_head;    // head
   CiSingleNode     *m_tail;    // tail
   uint              m_size;    // number of nodes in the list
public:
   //--- constructor and destructor
   void              CiSingleList();                              // default constructor 
   void              CiSingleList(int _node_val);                  // parameterized constructor 
   void             ~CiSingleList();                              // destructor                

   //--- adding nodes   
   void              AddFront(int _node_val);                         // new node to the beginning of the list
   void              AddRear(int _node_val);                          // new node to the end of the list   
   virtual void      AddFront(int &_node_arr[]){TRACE_CALL(_t_flag)}; // new node to the beginning of the list
   virtual void      AddRear(int &_node_arr[]){TRACE_CALL(_t_flag)};  // new node to the end of the list
   //--- deleting nodes     
   int               RemoveFront(void);                           // delete the head node       
   int               RemoveRear(void);                            // delete the node from the end of the list 
   void              DeleteNodeByIndex(const uint _idx);          // delete the ith node from the list

   //--- checking   
   virtual bool      Find(const int _node_val) const;             // find the required value    
   bool              IsEmpty(void) const;                         // check the list for being empty
   virtual int       GetValByIndex(const uint _idx) const;        // value of the ith node in the list 
   virtual CiSingleNode *GetNodeByIndex(const uint _idx) const;   // get the ith node in the list  
   virtual bool      SetNodeByIndex(CiSingleNode *_new_node,const uint _idx); // insert the new ith node in the list        
   CiSingleNode     *GetHeadNode(void) const;                     // get the head node
   CiSingleNode     *GetTailNode(void) const;                     // get the tail node   
   virtual uint      Size(void) const;                            // list size            
   //--- service   
   virtual void      PrintList(string _caption=NULL);             // print the list         
   virtual bool      CopyByValue(const CiSingleList &_sList);     // copy the list by values  
   virtual void      BubbleSort(void);                            // bubble sorting
   //---templates
   template<typename dPointer>
   bool              CheckDynamicPointer(dPointer &_p);           // template for checking dynamic pointer
   template<typename dPointer>
   bool              DeleteDynamicPointer(dPointer &_p);          // template for deleting dynamic pointer

protected:
   void              operator=(const CiSingleList &_sList) const; // assignment operator
   void              CiSingleList(const CiSingleList &_sList);    // copy constructor 
   virtual bool      AddToEmpty(int _node_val);                   // add a node to an empty list
   virtual void      addFront(int _node_val);                     // add a new "native" node to the beginning of the list
   virtual void      addRear(int _node_val);                      // add a new "native" node to the end of the list
   virtual int       removeFront(void);                           // delete the "native" head node       
   virtual int       removeRear(void);                            // delete the "native" node from the end of the list
   virtual void      deleteNodeByIndex(const uint _idx);          // delete the "native" ith node from the list
   virtual CiSingleNode *newNode(int _val);                       // new "native" node
   virtual void      CalcSize(void) const;                        // calculate the list size   
  };
//+------------------------------------------------------------------+
//|          Default constructor (empty list)                        |
//+------------------------------------------------------------------+
void CiSingleList::CiSingleList()
  {
   this.m_head=this.m_tail=NULL;  // empty nodes 
   this.m_size=0;
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+ 
//|        Parameterized constructor (single-node list)              |
//+------------------------------------------------------------------+
void CiSingleList::CiSingleList(int _node_val)
  {
   TRACE_CALL(_t_flag)
   this.m_head=this.m_tail=NULL;   // empty nodes
   if(!this.AddToEmpty(_node_val)) // add a new node
     {
      this.m_head=this.m_tail=NULL;  // zero out nodes
      Alert("Failed to add a new node!");
     }
  }
//+------------------------------------------------------------------+
//|          Destructor (deleting nodes from head to tail)           |
//+------------------------------------------------------------------+
void CiSingleList::~CiSingleList(void)
  {
   TRACE_CALL(_t_flag)
   if(!this.IsEmpty()) // if the list is not empty
     {
      //--- if there is 1 node in the list      
      if(this.m_head==this.m_tail)
         delete this.m_head;
      //--- if the list contains several nodes     
      else
        {
         CiSingleNode *node_to_delete=this.m_head; // pointer to the node to be deleted
         //--- pass through the list  
         for(CiSingleNode *sn=this.m_head;sn!=this.m_tail;)
           {
            sn=sn.GetNextNode();
            delete node_to_delete;
            node_to_delete=sn;
           }
         delete node_to_delete;
        }
     }
  }
//+------------------------------------------------------------------+
//|                    New node to the beginning of the list         |
//+------------------------------------------------------------------+
void CiSingleList::AddFront(int _node_val)
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty())              // if the list is empty
      this.AddToEmpty(_node_val);  // add to the empty list
   else
      this.addFront(_node_val);    // new node to the beginning of the list
  }
//+------------------------------------------------------------------+
//|                   New node to the end of the list                |
//+------------------------------------------------------------------+
void CiSingleList::AddRear(int _node_val)
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty())              // if the list is empty
      this.AddToEmpty(_node_val);  // add to the empty list
   else
      this.addRear(_node_val);     // new node to the end of the list
  }
//+------------------------------------------------------------------+
//|                    Deleting the head node                        |
//+------------------------------------------------------------------+
int CiSingleList::RemoveFront(void)
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty()) // if the list is empty
     {
      Alert("Tried to remove from an empty list!");
      return WRONG_VALUE;
     }
   int return_val=this.removeFront(); // data of the deleted node
   return return_val;                 // return data
  }
//+------------------------------------------------------------------+
//|                   Deleting the tail node                         |
//+------------------------------------------------------------------+
int CiSingleList::RemoveRear(void)
  {
   TRACE_CALL(_t_flag)
   if(this.IsEmpty()) // if the list is empty
     {
      Alert("Tried to remove from an empty list!");
      return WRONG_VALUE;
     }
   int return_val=this.removeRear();  // data of the deleted node
   return return_val;                 // return data
  }
//+------------------------------------------------------------------+
//|        Returning true if the list contains node_val              |
//+------------------------------------------------------------------+
bool CiSingleList::Find(const int _node_val) const
  {
   TRACE_CALL(_t_flag)
//--- pass through the list  
   for(CiSingleNode *sn=this.m_head; sn!=this.m_tail.GetNextNode(); sn=sn.GetNextNode())
      if(sn.GetVal()==_node_val) // the value has been found
         return true;
   return false;
  }
//+------------------------------------------------------------------+
//|                  Checking the list for being empty               |
//+------------------------------------------------------------------+
bool CiSingleList::IsEmpty(void) const
  {
   TRACE_CALL(_t_flag)
   bool IsEmpty=true;
   if(this.m_head!=NULL) // if the head node is filled
      IsEmpty=false;
   return IsEmpty;
  }
//+------------------------------------------------------------------+
//|             Returning the value of the nth node in the list      |
//+------------------------------------------------------------------+
int CiSingleList::GetValByIndex(const uint _idx) const
  {
   TRACE_CALL(_t_flag)
   uint count=0;
//--- pass through the list
   for(CiSingleNode *sn=this.m_head; sn!=this.m_tail.GetNextNode(); sn=sn.GetNextNode())
     {
      if(count++==_idx) // if the index is equal to the counter
         return sn.GetVal();
     }
   Alert("lement num exceeds list size!");
   return WRONG_VALUE;
  }
//+------------------------------------------------------------------+
//|                    Getting the ith node in the list              |
//+------------------------------------------------------------------+
CiSingleNode *CiSingleList::GetNodeByIndex(const uint _idx) const
  {
   TRACE_CALL(_t_flag)
   uint count=0;
//--- pass through the list
   for(CiSingleNode *sn=this.m_head; sn!=this.m_tail.GetNextNode(); sn=sn.GetNextNode())
     {
      if(count++==_idx) // if the index is equal to the counter
         return sn;
     }
   Alert("lement num exceeds list size!");
   return NULL;
  }
//+------------------------------------------------------------------+
//|                  Inserting the ith node in the list              |
//+------------------------------------------------------------------+
bool CiSingleList::SetNodeByIndex(CiSingleNode *_new_node,const uint _idx)
  {
   TRACE_CALL(_t_flag)
   if(_idx==0) // if the index is equal to 0
     {
      _new_node.SetNextNode(this.m_head);
      this.m_head=_new_node;
      return true;
     }
   else
     {
      uint count=0;                          // counter 
      CiSingleNode *startNode=this.m_head;   // starting node of the pass
      CiSingleNode *offNode=NULL;            // maximum node of the pass  
      CiSingleNode *sn=startNode;            // service node
      CiSingleNode *pn=NULL;                 // previous node
      //--- pass through the list
      while(sn!=offNode)
        {
         if(count++==_idx) // if index is equal to counter 1
           {
            pn.SetNextNode(_new_node);  // link from the previous node to the new node
            _new_node.SetNextNode(sn);  // link from the new node to the current node
            return true;
           }
         pn=sn;
         sn=sn.GetNextNode();
        }
      Alert("lement num exceeds list size!");
      return false;
     }
  }
//+------------------------------------------------------------------+
//|                     Getting the head node                        |
//+------------------------------------------------------------------+
CiSingleNode *CiSingleList::GetHeadNode(void) const
  {
   TRACE_CALL(_t_flag)
   return this.m_head;
  }
//+------------------------------------------------------------------+
//|                    Getting the tail node                         |
//+------------------------------------------------------------------+
CiSingleNode *CiSingleList::GetTailNode(void) const
  {
   TRACE_CALL(_t_flag)
   return this.m_tail;
  }
//+------------------------------------------------------------------+
//|                   Deleting the ith node from the list            |
//+------------------------------------------------------------------+
void CiSingleList::DeleteNodeByIndex(const uint _idx)
  {
   TRACE_CALL(_t_flag)
   uint _list_size=this.Size(); // list size
   if(_idx<_list_size)          // if the index is less than the size
     {
      if(_idx==0) // if the index is equal to 0
        {
         this.RemoveFront();    // delete the node from the beginning of the list
         return;
        }
      else if(_idx==(_list_size-1)) // if the index indicates the tail
        {
         this.RemoveRear();         // delete the node from the end of the list
         return;
        }
      else
        {
         this.deleteNodeByIndex(_idx); // delete the node by index
         return;
        }
     }
   Alert("lement num exceeds list size!");
   return;
  }
//+------------------------------------------------------------------+
//|                    Returning the list size                       |
//+------------------------------------------------------------------+
uint CiSingleList::Size(void) const
  {
   TRACE_CALL(_t_flag)
   this.CalcSize();       // calculate the list size
   return this.m_size;    // return the size
  }
//+------------------------------------------------------------------+
//|                   Printing the list                              |
//+------------------------------------------------------------------+
void CiSingleList::PrintList(string _caption=NULL)
  {
   TRACE_CALL(_t_flag)
   uint list_size=this.Size();        // list size
//--- checking the list size   
   if(list_size==0) // if the index is equal to 0
      Print("The list is empty.");
   else
     {
      uint start_idx=0;
      if(_caption!=NULL)
         Print(_caption);
      //--- pass through the list
      while(start_idx<list_size)
         PrintFormat("Node #%d, val=%d ",start_idx,this.GetValByIndex(start_idx++));
      Print("\n");
     }
  }
//+------------------------------------------------------------------+
//|                 Copying by values                                |
//+------------------------------------------------------------------+
bool CiSingleList::CopyByValue(const CiSingleList &_sList)
  {
   TRACE_CALL(_t_flag)
   bool IsCopied=true;
//--- zero out the current list if it is not empty
   if(!this.IsEmpty()) // if the list is not empty
     {
      //--- pass through the list
      while(!this.IsEmpty())
         this.RemoveFront(); // delete the head node        
     }
   if(!this.IsEmpty()) // if failed to empty the list
      IsCopied=false;

   if(IsCopied && !_sList.IsEmpty())
     {
      CiSingleNode *offNode=_sList.m_tail.GetNextNode();
      //--- pass through the source list
      for(CiSingleNode *sn=_sList.m_head; sn!=offNode; sn=sn.GetNextNode())
         this.AddRear(sn.GetVal());  // new node with data        
     }
   return IsCopied;
  }
//+------------------------------------------------------------------+
//|                  Bubble sorting                                  |
//+------------------------------------------------------------------+
void CiSingleList::BubbleSort(void)
  {
   TRACE_CALL(_t_flag)
   uint _list_size=this.Size();                         // list size
   for(uint passes=0;passes<_list_size-1;passes++)
      for(uint j=0;j<_list_size-passes-1;j++)
        {
         CiSingleNode *_node1=this.GetNodeByIndex(j);   // node by index j
         CiSingleNode *_node2=this.GetNodeByIndex(j+1); // node by index j+1
         if(_node1.GetVal()>_node2.GetVal())            // compare the values
           {
            int _node2_val=_node2.GetVal();             // data of the node by index j+1
            CiSingleNode *_temp_node=this.newNode(_node2_val); // temporary node
            this.SetNodeByIndex(_temp_node,j);          // insert a new jth node in the list
            this.DeleteNodeByIndex(j+2);                // delete the node by index j+2
           }
        }
  }
//+------------------------------------------------------------------+
//|                     Copy constructor                             |
//+------------------------------------------------------------------+
void CiSingleList::CiSingleList(const CiSingleList &_sList)
  {
   TRACE_CALL(_t_flag)
   this.m_head=_sList.m_head; // copy the head
   this.m_tail=_sList.m_tail; // copy the tail
  }
//+------------------------------------------------------------------+
//|                   Adding a node to an empty list                 |
//+------------------------------------------------------------------+
bool CiSingleList::AddToEmpty(int _node_val)
  {
   TRACE_CALL(_t_flag)
   if(!this.IsEmpty()) // if the list is not empty
      return false;
   CiSingleNode *node_to_add=new CiSingleNode(_node_val); // new node with data
   this.m_head=node_to_add;                              // new head node
   this.m_tail=this.m_head;                              // head node is equal to tail node
   return true;
  }
//+------------------------------------------------------------------+
//|                New "native" node to the beginning of the list    |
//+------------------------------------------------------------------+
void CiSingleList::addFront(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CiSingleNode(_node_val); // new node with data
   node_to_add.SetNextNode(this.m_head);                  // link to the head node
   this.m_head=node_to_add;                               // new head node
  }
//+------------------------------------------------------------------+
//|                New "native" node to the end of the list          |
//+------------------------------------------------------------------+
void CiSingleList::addRear(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CiSingleNode(_node_val); // new node with data
   this.m_tail.SetNextNode(node_to_add);                 // link to the tail
   this.m_tail=node_to_add;                              // new tail
  }
//+------------------------------------------------------------------+
//|                  Deleting the "native" head node                 |
//+------------------------------------------------------------------+
int CiSingleList::removeFront(void)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_remove=this.m_head;  // node to be deleted
   int return_val=node_to_remove.GetVal();    // node data
   this.m_head=node_to_remove.GetNextNode();  // update the head node
   delete node_to_remove;                     // delete the node
   return return_val;                         // return data
  }
//+------------------------------------------------------------------+
//|              Deleting the "native" node from the end of the list |
//+------------------------------------------------------------------+
int CiSingleList::removeRear(void)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_remove=this.m_tail;  // node to be deleted
   int return_val=node_to_remove.GetVal();    // node data   
//--- if there is 1 node in the list      
   if(this.m_head==this.m_tail)
     {
      delete this.m_head;                     // delete the head
      this.m_head=this.m_tail=NULL;           // zero out the pointers
     }
   else
     {
      //--- find the node preceding the tail
      CiSingleNode *prev_tail=this.GetNodeByIndex(this.Size()-2);
      prev_tail.SetNextNode(NULL);                          // zero out the link
      delete node_to_remove;                                // delete the node
      this.m_tail=prev_tail;                                // update the tail node
     }
   return return_val;                                       // return data
  }
//+------------------------------------------------------------------+
//|                Deleting the "native" ith node from the list      |
//+------------------------------------------------------------------+
void CiSingleList::deleteNodeByIndex(const uint _idx)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *cur_node=this.GetNodeByIndex(_idx);    // node by index _idx
   CiSingleNode *prev_node=this.GetNodeByIndex(_idx-1); // node by index _idx-1
   CiSingleNode *next_node=cur_node.GetNextNode();      // node by index _idx+1
   prev_node.SetNextNode(next_node);                    // link from the previous node to the next node
   delete cur_node;                                     // delete the node by index _idx
   return;
  }
//+------------------------------------------------------------------+
//|                    New "native" node                             |
//+------------------------------------------------------------------+
CiSingleNode *CiSingleList::newNode(int _val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *_temp_node=new CiSingleNode(_val);
   return _temp_node;
  }
//+------------------------------------------------------------------+
//|                   Calculating the list size                      |
//+------------------------------------------------------------------+
void CiSingleList::CalcSize(void) const
  {
   TRACE_CALL(_t_flag)
   uint count=0;
   if(!this.IsEmpty()) // if the list is not empty
     {
      // process the single-node list
      if(this.m_head==this.m_tail && this.m_head.GetVal()!=NULL)
         count=1;
      // otherwise pass through the entire list  
      else
        {
         CiSingleNode *offNode=this.m_tail.GetNextNode();
         for(CiSingleNode *sn=this.m_head; sn!=offNode; sn=sn.GetNextNode())
            ++count;  // increase the counter
        }
     }
   this.m_size=count;
  }
//+------------------------------------------------------------------+
//|                   Assignment operator                            |
//+------------------------------------------------------------------+
void CiSingleList::operator=(const CiSingleList &_sList) const
  {
   TRACE_CALL(_t_flag)
   this.m_head=_sList.m_head;
   this.m_tail=_sList.m_tail;
  }
//+------------------------------------------------------------------+
//|               Checking dynamic pointer                           |
//+------------------------------------------------------------------+
template<typename dPointer>
bool CiSingleList::CheckDynamicPointer(dPointer &_pointer)
  {
   TRACE_CALL(_t_flag)
   if(CheckPointer(_pointer)==POINTER_DYNAMIC)
      return true;
   else
      return false;
  }
//+------------------------------------------------------------------+
//|               Deleting dynamic pointer                           |
//+------------------------------------------------------------------+
template<typename dPointer>
bool CiSingleList::DeleteDynamicPointer(dPointer &_pointer)
  {
   TRACE_CALL(_t_flag)
   if(this.CheckDynamicPointer(_pointer))
     {
      delete _pointer;
      return true;
     }
   else
      return false;
  }
//+------------------------------------------------------------------+
// [EOF]
