//+------------------------------------------------------------------+
//|                                                  CDoubleList.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CiSingleList.mqh"
#include "CDoubleNode.mqh"
//+------------------------------------------------------------------+
//|                      CDoubleList class                           |
//+------------------------------------------------------------------+
class CDoubleList : public CiSingleList
  {
public:
   void              CDoubleList(void);                  // default constructor    
   void              CDoubleList(int _node_val);         // parameterized constructor   
   void             ~CDoubleList(void){};                // destructor                  
   virtual bool      SetNodeByIndex(CiSingleNode *_new_node,const uint _idx); // insert the new ith node in the list  

protected:
   virtual bool      AddToEmpty(int _node_val);          // add a node to an empty list
   virtual void      addFront(int _node_val);            // add a new "native" node to the beginning of the list
   virtual void      addRear(int _node_val);             // add a new "native" node to the end of the list 
   virtual int       removeFront(void);                  // delete the "native" head node
   virtual int       removeRear(void);                   // delete the "native" tail node
   virtual void      deleteNodeByIndex(const uint _idx); // delete the "native" ith node from the list
   virtual CiSingleNode *newNode(int _node_val);         // new "native" node
  };
//+------------------------------------------------------------------+
//|          Default constructor (empty list)                        |
//+------------------------------------------------------------------+
void CDoubleList::CDoubleList()
  {
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+ 
//|        Parameterized constructor (single-node list)              |
//+------------------------------------------------------------------+
void CDoubleList::CDoubleList(int _node_val)
  {
   TRACE_CALL(_t_flag)
   this.m_head=this.m_tail=NULL;     // empty nodes
   if(!this.AddToEmpty(_node_val)) // add a new node to an empty list
     {
      this.m_head=this.m_tail=NULL;  // zero out nodes
      Alert("Failed to add a new node!");
     }
  }
//+------------------------------------------------------------------+
//|                   Adding a node to an empty list                 |
//+------------------------------------------------------------------+
bool CDoubleList::AddToEmpty(int _node_val)
  {
   TRACE_CALL(_t_flag)
   if(!this.IsEmpty()) // if the list is not empty
      return false;
   CiSingleNode *node_to_add=new CDoubleNode(_node_val); // new node with data 
   this.m_head=node_to_add;                             // new head node
   this.m_tail=this.m_head;                             // head node is equal to tail node
   return true;
  }
//+------------------------------------------------------------------+
//|                New "native" node to the beginning of the list    |
//+------------------------------------------------------------------+
void CDoubleList::addFront(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CDoubleNode(_node_val); // new node with data
   node_to_add.SetNextNode(this.m_head);                 // link from the new node to the head node
   this.m_head.SetPrevNode(node_to_add);                 // link from the head to the new node
   this.m_head=node_to_add;                              // new head node
  }
//+------------------------------------------------------------------+
//|                New "native" node to the end of the list          |
//+------------------------------------------------------------------+
void CDoubleList::addRear(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *node_to_add=new CDoubleNode(_node_val); // new node with data
   this.m_tail.SetNextNode(node_to_add);                 // link from the tail to the new node
   node_to_add.SetPrevNode(this.m_tail);                 // link from the new node to the tail
   this.m_tail=node_to_add;                              // new head node
  }
//+------------------------------------------------------------------+
//|                  Deleting the "native" head node                 |
//+------------------------------------------------------------------+
int CDoubleList::removeFront(void)
  {
   TRACE_CALL(_t_flag)
   int return_val=CiSingleList::removeFront(); // delete the head node
   this.m_head.SetPrevNode(NULL);              // zero out the link with the previous node
   return return_val;                          // return data
  }
//+------------------------------------------------------------------+
//|              Deleting the "native" node from the end of the list |
//+------------------------------------------------------------------+
int CDoubleList::removeRear(void)
  {
   TRACE_CALL(_t_flag)
   CDoubleNode *node_to_remove=this.m_tail;                 // node to be deleted
   int return_val=node_to_remove.GetVal();                  // node data   
//--- if there is 1 node in the list      
   if(this.m_head==this.m_tail)
     {
      delete this.m_head;                                   // delete the head
      this.m_head=this.m_tail=NULL;                         // zero out the pointers
     }
   else
     {
      //--- find the node preceding the tail
      CDoubleNode *prev_tail_node=this.m_tail.GetPrevNode();
      prev_tail_node.SetNextNode(NULL);                     // zero out the 'next' link of the future tail
      delete node_to_remove;                                // delete the node
      this.m_tail=prev_tail_node;                           // update the tail node
     }
   return return_val;                                       // return data
  }
//+------------------------------------------------------------------+
//|                Deleting the "native" ith node from the list      |
//+------------------------------------------------------------------+
void CDoubleList::deleteNodeByIndex(const uint _idx)
  {
   TRACE_CALL(_t_flag)
   CDoubleNode *cur_node=this.GetNodeByIndex(_idx); // node by index _idx
   CDoubleNode *prev_node=cur_node.GetPrevNode();   // node by index _idx-1
   CDoubleNode *next_node=cur_node.GetNextNode();   // node by index _idx+1
   prev_node.SetNextNode(next_node);                // link from the prev-node to the next-node
   next_node.SetPrevNode(prev_node);                // link from the next-node to the prev-node
   delete cur_node;                                 // delete the node by index _idx
   return;
  }
//+------------------------------------------------------------------+
//|                    New "native" node                             |
//+------------------------------------------------------------------+
CiSingleNode *CDoubleList::newNode(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CiSingleNode *_temp_node=new CDoubleNode(_node_val);
   return _temp_node;
  }
//+------------------------------------------------------------------+
//|             Inserting the new ith node in the list               |
//+------------------------------------------------------------------+
bool CDoubleList::SetNodeByIndex(CiSingleNode *_new_node,const uint _idx)
  {
   TRACE_CALL(_t_flag)
   if(_idx==0) // if the index is equal to 0
     {
      _new_node.SetNextNode(this.m_head); // link from the new node to the head
      this.m_head.SetPrevNode(_new_node); // link from the head to the new node
      this.m_head=_new_node;              // new node - head
      return true;
     }
   else
     {
      uint count=0;                                    // counter 
      CiSingleNode *startNode=this.m_head;             // starting node of the pass
      CiSingleNode *offNode=this.m_tail.GetNextNode(); // maximum node of the pass  
      CiSingleNode *sn=startNode;
      CiSingleNode *pn=NULL;                           // previous node
      //--- pass through the list
      while(sn!=offNode)
        {
         if(count++==_idx) // if index is equal to counter 1
           {
            pn.SetNextNode(_new_node);  // link from the previous node to the new node
            _new_node.SetPrevNode(pn);  // link from the new node to the previous node 
            _new_node.SetNextNode(sn);  // link from the new node to the current node
            sn.SetPrevNode(_new_node);  // link from the current node to the new node
            return true;
           }
         pn=sn;
         sn=sn.GetNextNode();
        }
      Alert("lement num exceeds list size!");
      return false;
     }
  }
//+------------------------------------------------------------------+
