//+------------------------------------------------------------------+
//|                                           CiCircleDoubleList.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include "CDoubleList.mqh"
//+------------------------------------------------------------------+
//|                      CiCircleDoubleList class                    |
//+------------------------------------------------------------------+
class CiCircleDoubleList : public CDoubleList
  {
public:
   void              CiCircleDoubleList(void);                       // default constructor    
   void              CiCircleDoubleList(int _node_val);              // parameterized constructor   
   void             ~CiCircleDoubleList(void){TRACE_CALL(_t_flag)};  // destructor   
   //---
   virtual uint      Size(void) const;                                        // list size 
   virtual bool      SetNodeByIndex(CiSingleNode *_new_node,const uint _idx); // insert the new ith node in the list
   virtual int       GetValByIndex(const uint _idx) const;                    // value of the ith node in the list
   virtual CiSingleNode *GetNodeByIndex(const uint _idx) const;               // get the ith node in the list 
   virtual bool      Find(const int _node_val) const;                         // find the required value 
   virtual bool      CopyByValue(const CiSingleList &_sList);                 // copy the list by values  

protected:
   virtual void      addFront(int _node_val);            // add a new "native" node to the beginning of the list
   virtual void      addRear(int _node_val);             // add a new "native" node to the end of the list 
   virtual int       removeFront(void);                  // delete the "native" head node
   virtual int       removeRear(void);                   // delete the "native" tail node
   virtual void      deleteNodeByIndex(const uint _idx); // delete the "native" ith node from the list

protected:
   void              CalcSize(void) const;               // calculate the list size 
   void              LinkHeadTail(void);                 // link head to tail
  };
//+------------------------------------------------------------------+
//|          Default constructor (empty list)                        |
//+------------------------------------------------------------------+
void CiCircleDoubleList::CiCircleDoubleList()
  {
   TRACE_CALL(_t_flag)
  }
//+------------------------------------------------------------------+ 
//|        Parameterized constructor (single-node list)              |
//+------------------------------------------------------------------+
void CiCircleDoubleList::CiCircleDoubleList(int _node_val)
  {
   TRACE_CALL(_t_flag)
   this.m_head=this.m_tail=NULL;     // empty nodes
   if(!this.AddToEmpty(_node_val)) // add a new node
     {
      this.m_head=this.m_tail=NULL;  // zero out nodes
      Alert("Failed to add a new node!");
     }
  }
//+------------------------------------------------------------------+
//|                New "native" node to the beginning of the list    |
//+------------------------------------------------------------------+
void CiCircleDoubleList::addFront(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CDoubleList::addFront(_node_val); // call a similar method of the base class
   this.LinkHeadTail();              // link head and tail
  }
//+------------------------------------------------------------------+
//|                New "native" node to the end of the list          |
//+------------------------------------------------------------------+
void CiCircleDoubleList::addRear(int _node_val)
  {
   TRACE_CALL(_t_flag)
   CDoubleList::addRear(_node_val);  // call a similar method of the base class
   this.LinkHeadTail();              // link head and tail
  }
//+------------------------------------------------------------------+
//|                  Deleting the "native" head node                 |
//+------------------------------------------------------------------+
int CiCircleDoubleList::removeFront(void)
  {
   TRACE_CALL(_t_flag)
   int return_val=CDoubleList::removeFront(); // call a similar method of the base class
   this.LinkHeadTail();                       // link head and tail
   return return_val;                         // return data
  }
//+------------------------------------------------------------------+
//|              Deleting the "native" node from the end of the list |
//+------------------------------------------------------------------+
int CiCircleDoubleList::removeRear(void)
  {
   TRACE_CALL(_t_flag)
   int return_val=CDoubleList::removeRear();  // call a similar method of the base class
   this.LinkHeadTail();                       // link head and tail
   return return_val;                         // return data   
  }
//+------------------------------------------------------------------+
//|                Deleting the "native" ith node from the list      |
//+------------------------------------------------------------------+
void CiCircleDoubleList::deleteNodeByIndex(const uint _idx)
  {
   TRACE_CALL(_t_flag)
   CDoubleList::deleteNodeByIndex(_idx);  // call a similar method of the base class
   this.LinkHeadTail();                   // link head and tail
   return;
  }
//+------------------------------------------------------------------+
//|                    Returning the list size                       |
//+------------------------------------------------------------------+
uint CiCircleDoubleList::Size(void) const
  {
   TRACE_CALL(_t_flag)
   this.CalcSize();       // calculate the list size
   return this.m_size;    // return the size
  }
//+------------------------------------------------------------------+
//|                   Calculating the list size                      |
//+------------------------------------------------------------------+
void CiCircleDoubleList::CalcSize(void) const
  {
   TRACE_CALL(_t_flag)
   uint count=0;
   if(!this.IsEmpty()) // if the list is not empty
     {
      // process the single-node list
      if(this.m_head==this.m_tail && this.m_head.GetVal()!=NULL)
         count=1;
      // otherwise pass through the entire list  
      else
        {
         count++;
         CiSingleNode *offNode=this.m_head;
         for(CiSingleNode *dn=offNode.GetNextNode(); dn!=offNode; dn=dn.GetNextNode())
            ++count;  // increase the counter
        }
     }
   this.m_size=count;
  }
//+------------------------------------------------------------------+
//|                 Getting the value of the ith node in the list    |
//+------------------------------------------------------------------+
int CiCircleDoubleList::GetValByIndex(const uint _idx) const
  {
   TRACE_CALL(_t_flag)
   if(_idx==0)
      return this.m_head.GetVal();
   else
     {
      int count=1;
      CiSingleNode *offNode=this.m_head;
      //--- pass through the list
      for(CiSingleNode *sn=offNode.GetNextNode(); sn!=offNode; sn=sn.GetNextNode())
        {
         if(count++==_idx) // if the index is equal to the counter
            return sn.GetVal();
        }
     }
   Alert("lement num exceeds list size!");
   return NULL;
  }
//+------------------------------------------------------------------+
//|                    Getting the ith node in the list              |
//+------------------------------------------------------------------+
CiSingleNode *CiCircleDoubleList::GetNodeByIndex(const uint _idx) const
  {
   TRACE_CALL(_t_flag)
   if(_idx==0)
      return this.m_head;
   else
     {
      int count=1;
      CiSingleNode *offNode=this.m_head;
      //--- pass through the list
      for(CiSingleNode *sn=offNode.GetNextNode(); sn!=offNode; sn=sn.GetNextNode())
        {
         if(count++==_idx) // if the index is equal to the counter
            return sn;
        }
     }
   Alert("lement num exceeds list size!");
   return NULL;
  }
//+------------------------------------------------------------------+
//|        Returning true if the list contains node_val              |
//+------------------------------------------------------------------+
bool CiCircleDoubleList::Find(const int _node_val) const
  {
   TRACE_CALL(_t_flag)
//--- check the head node
   CiSingleNode *sn=this.m_head;
   if(sn.GetVal()==_node_val)
      return true;
//--- pass through the list  
   for(sn=this.m_head.GetNextNode(); sn!=this.m_tail.GetNextNode(); sn=sn.GetNextNode())
      if(sn.GetVal()==_node_val) // the value has been found
         return true;
   return false;
  }
//+------------------------------------------------------------------+
//|                 Copying by values                                |
//+------------------------------------------------------------------+
bool CiCircleDoubleList::CopyByValue(const CiSingleList &_sList)
  {
   TRACE_CALL(_t_flag)
   bool IsCopied=true;
//--- zero out the current list if it is not empty
   if(!this.IsEmpty()) // if the list is not empty
     {
      //--- pass through the list
      while(!this.IsEmpty())
         this.RemoveFront(); // delete the head node        
     }
   if(!this.IsEmpty()) // if failed to empty the list
      IsCopied=false;

   if(IsCopied && !_sList.IsEmpty())
     {
      //--- copy the value of the head node
      CiSingleNode *sn=_sList.GetHeadNode();
      int _node_val=sn.GetVal();
      this.AddRear(_node_val);
      //--- pass through the list
      CiSingleNode *offNode=sn;
      //--- pass through the source list
      for(sn=sn.GetNextNode(); sn!=offNode; sn=sn.GetNextNode())
        {
         _node_val=sn.GetVal();
         this.AddRear(_node_val);  // new node with data        
        }
     }
   return IsCopied;
  }
//+------------------------------------------------------------------+
//|                  Linking head to tail                            |
//+------------------------------------------------------------------+
void CiCircleDoubleList::LinkHeadTail(void)
  {
   TRACE_CALL(_t_flag)
   this.m_head.SetPrevNode(this.m_tail);      // link head to tail
   this.m_tail.SetNextNode(this.m_head);      // link tail to head 
  }
//+------------------------------------------------------------------+
//|                 Inserting the new ith node in the list           |
//+------------------------------------------------------------------+
bool CiCircleDoubleList::SetNodeByIndex(CiSingleNode *_new_node,const uint _idx)
  {
   TRACE_CALL(_t_flag)
   if(_idx==0) // if the index is equal to 0
     {
      _new_node.SetNextNode(this.m_head); // link from the new node to the head
      this.m_head.SetPrevNode(_new_node); // link from the head to the new node
      this.m_head=_new_node;              // new node - head
      this.LinkHeadTail();                // link head to tail
      return true;
     }
   else
     {
      uint count=1;
      CiSingleNode *offNode=this.m_head;
      CiSingleNode *pn=NULL;             // previous node
      //--- pass through the list
      for(CiSingleNode *sn=offNode.GetNextNode(); sn!=offNode; sn=sn.GetNextNode())
         if(count++==_idx) // if the index is equal to the counter
           {
            pn=sn.GetPrevNode();        // previous node
            pn.SetNextNode(_new_node);  // link from the previous node to the new node
            _new_node.SetPrevNode(pn);  // link from the new node to the previous node 
            _new_node.SetNextNode(sn);  // link from the new node to the current node
            sn.SetPrevNode(_new_node);  // link from the current node to the new node
            return true;
           }
      Alert("lement num exceeds list size!");
      return false;
     }
  }
//+------------------------------------------------------------------+
