//+------------------------------------------------------------------+
//|                                                CVertLineNode.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, denkir"
#property link      "https://login.mql5.com/en/users/denkir"

#include <Object.mqh>
//+------------------------------------------------------------------+
//|                Structure of vertical line properties             |
//+------------------------------------------------------------------+
struct SVertLineProperties
  {
   string            name;    // line name
   datetime          time;    // line time
   color             clr;     // line color
   ENUM_LINE_STYLE   style;   // line style
   int               width;   // line width

   //--- constructor
   void SVertLineProperties::SVertLineProperties(void)
     {
      name=NULL;
      time=0;
      clr=clrRed;
      style=STYLE_SOLID;
      width=1;
     }
  };
//+------------------------------------------------------------------+
//|                      CVertLineNode class                         |
//+------------------------------------------------------------------+
class CVertLineNode : public CObject
  {
private:
   SVertLineProperties m_vert_lines[2];      // array of structures of vertical line properties   
   uint              m_duration;             // frame duration
   bool              m_IsFrameFormed;        // flag of frame formation

public:
   void              CVertLineNode(void);
   void             ~CVertLineNode(void){};
   //--- set-methods    
   void              SetLine(const SVertLineProperties &_vert_line,bool IsFirst=true);
   void              SetDuration(const uint _duration){this.m_duration=_duration;};
   void              SetFrameFlag(const bool _frame_flag){this.m_IsFrameFormed=_frame_flag;};
   //--- get-methods 
   void              GetLine(SVertLineProperties &_vert_line_out,bool IsFirst=true) const;
   uint              GetDuration(void) const;
   bool              GetFrameFlag(void) const;
   //--- draw the line
   bool              DrawLine(bool IsFirst=true) const;
  };
//+------------------------------------------------------------------+
//|                   Default constructor                            |
//+------------------------------------------------------------------+
void CVertLineNode::CVertLineNode(void)
  {
   this.m_duration=0;
   this.m_IsFrameFormed=false;
  }
//+------------------------------------------------------------------+
//|                  Set-method for the line selected                |
//+------------------------------------------------------------------+
void CVertLineNode::SetLine(const SVertLineProperties &_vert_line,bool IsFirst=true)
  {
   int idx=(IsFirst)?0:1; // line index in the m_vert_lines[2] array
//---
   this.m_vert_lines[idx].name=_vert_line.name;
   this.m_vert_lines[idx].time=_vert_line.time;
   this.m_vert_lines[idx].clr=_vert_line.clr;
   this.m_vert_lines[idx].style=_vert_line.style;
   this.m_vert_lines[idx].width=_vert_line.width;
  }
//+------------------------------------------------------------------+
//|                  Get-method for the line selected                |
//+------------------------------------------------------------------+
void CVertLineNode::GetLine(SVertLineProperties &_vert_line_out,bool IsFirst=true) const
  {
   int idx=(IsFirst)?0:1; // line index in the m_vert_lines[2] array
//---
   _vert_line_out.name=this.m_vert_lines[idx].name;
   _vert_line_out.time=this.m_vert_lines[idx].time;
   _vert_line_out.clr=this.m_vert_lines[idx].clr;
   _vert_line_out.style=this.m_vert_lines[idx].style;
   _vert_line_out.width=this.m_vert_lines[idx].width;
  }
//+------------------------------------------------------------------+
//|                  Get-method for duration                         |
//+------------------------------------------------------------------+
uint  CVertLineNode::GetDuration(void) const
  {
   return this.m_duration;
  }
//+------------------------------------------------------------------+
//|              Get-method for the flag of frame formation          |
//+------------------------------------------------------------------+
bool CVertLineNode::GetFrameFlag(void) const
  {
   return this.m_IsFrameFormed;
  }
//+------------------------------------------------------------------+
//|                        Drawing the line                          |
//+------------------------------------------------------------------+  
bool CVertLineNode::DrawLine(bool IsFirst=true) const
  {
   SVertLineProperties curr_vert_line;
   this.GetLine(curr_vert_line,IsFirst);
//--- create a vertical line and set properties
   if(!ObjectCreate(0,curr_vert_line.name,OBJ_VLINE,0,curr_vert_line.time,0.))
     {
      Print("Vertical line create error!");
      return false;
     }
   if(!ObjectSetInteger(0,curr_vert_line.name,OBJPROP_COLOR,curr_vert_line.clr))
     {
      Print("Vertical line set color error!");
      // return false;
     }
   if(!ObjectSetInteger(0,curr_vert_line.name,OBJPROP_STYLE,curr_vert_line.style))
     {
      Print("Vertical line set style error!");
      // return false;
     }
   if(!ObjectSetInteger(0,curr_vert_line.name,OBJPROP_WIDTH,curr_vert_line.width))
     {
      Print("Vertical line set width error!");
      // return false;
     }
   ChartRedraw();
   //---   
   return true;
  }

//[EOF]
