//+------------------------------------------------------------------+
//|                                                      CRandom.mqh |
//|                                           Copyright 2013, denkir |
//|                           https://login.mql5.com/en/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, denkir"
#property link      "https://login.mql5.com/en/users/denkir"


//+------------------------------------------------------------------+
//|                    Random class definition                       |
//+------------------------------------------------------------------+
class CRandom
  {
private:
   ulong u,//unsigned 64-bit integers
   v,
   w;
public:
   //+------------------------------------------------------------------+
   //| CRandom class constructor                                        |
   //+------------------------------------------------------------------+
   void CRandom()
     {
      randomSet(184467440737095516);
     }
   //+------------------------------------------------------------------+
   //| Set-method of CRandom class                                      |
   //+------------------------------------------------------------------+
   void randomSet(ulong j)
     {
      v=4101842887655102017;
      w=1;
      u=14757395258967641292;
      u=j^v;
      int64();
      v = u; int64();
      w = v; int64();
     }
   //+------------------------------------------------------------------+
   //| Return 64-bit random integer                                     |
   //+------------------------------------------------------------------+
   ulong int64()
     {
      uint k=4294957665;
      u=u*2862933555777941757+7046029254386353087;
      v^= v>> 17; v ^= v<< 31; v ^= v>> 8;
      w = k*(w & 0xffffffff) +(w>> 32);
      ulong x=u^(u<<21); x^=x>>35; x^=x<<4;
      return(x+v)^w;
     };
   //+------------------------------------------------------------------+
   //| Return random double-precision value in the range 0. to 1.       |
   //+------------------------------------------------------------------+
   double doub()
     {
      return 5.42101086242752217e-20*int64();
     }
   //+------------------------------------------------------------------+
   //| Return 32-bit random integer                                     |
   //+------------------------------------------------------------------+
   uint int32()
     {
      return(uint)int64();
     }
  };