//+------------------------------------------------------------------+
//|                                                 GetExtremums.mqh |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, Yurich"
#property link      "https://login.mql5.com/ru/users/Yurich"
//+------------------------------------------------------------------+
struct dextremum //description extremum
  {
   double            value;
   datetime          time;
   int               type; //1 - peak, -1 - trough
  };
//+------------------------------------------------------------------+
#define SavePeek(_i)		m_ge[n].type=1; m_ge[n].time=m_rates[_i].time; m_ge[n].value=m_rates[_i].high
#define SaveTrough(_i)	m_ge[n].type=-1; m_ge[n].time=m_rates[_i].time; m_ge[n].value=m_rates[_i].low
#define NextIndex			if(++n==gesize) break
//+------------------------------------------------------------------+
// The function returns the number of extremums found
//+------------------------------------------------------------------+
int GetExtremums(const double m_range,      //minimum price change
                 const MqlRates &m_rates[], //array of history quotes
                 dextremum &m_ge[],         //the returned array of extremums
                 const int m_total=0)       //required number of extremums or zero for all extremums	
  {
   int gesize,n=0,direction=0,last=0,lc=96;
   if(m_range<0) return(0);
   int limit=ArraySize(m_rates);
   if(limit<2) return(0);
   if(m_total<0) return(0);
   else if(m_total>0) gesize=m_total;
   else gesize=100;
   if(ArrayResize(m_ge,gesize)!=gesize) return(0);
   bool dr=ArrayGetAsSeries(m_rates);
   ArraySetAsSeries(m_rates,true);
//---
   int max=0,min=0;
   for(int i=0; i<limit; i++)
     {
      bool set=false;
      //---
      if(direction>0)
        {
         if(m_rates[i].high>m_rates[last].high)
           {
            if(m_rates[i].low<m_rates[last].high-m_range)
              {
               if(m_rates[i].open>m_rates[i].close)
                 {
                  SavePeek(last);
                  NextIndex;
                  SaveTrough(i);
                 }
               else
                 {
                  direction=-1;
                  SavePeek(i);
                 }
               NextIndex;
              }
            last=i;
            set=true;
           }
         if(m_rates[i].low<m_rates[last].high-m_range && (!set || m_rates[i].open<m_rates[i].close))
           {
            if(m_rates[i].high>m_rates[i].low+m_range && m_rates[i].open>m_rates[i].close)
              {
               SavePeek(last);
               NextIndex;
               SaveTrough(i);
               NextIndex;
              }
            else if(direction>0)
              {
               direction=-1;
               SavePeek(last);
               NextIndex;
              }
            last=i;
           }
        }
      else if(direction<0)
        {
         if(m_rates[i].low<m_rates[last].low)
           {
            if(m_rates[i].high>m_rates[last].low+m_range)
              {
               if(m_rates[i].open<m_rates[i].close)
                 {
                  SaveTrough(last);
                  NextIndex;
                  SavePeek(i);
                 }
               else
                 {
                  direction=1;
                  SaveTrough(i);
                 }
               NextIndex;
              }
            last=i;
            set=true;
           }
         if(m_rates[i].high>m_rates[last].low+m_range && (!set || m_rates[i].open>m_rates[i].close))
           {
            if(m_rates[i].low<m_rates[i].high-m_range && m_rates[i].open<m_rates[i].close)
              {
               SaveTrough(last);
               NextIndex;
               SavePeek(i);
               NextIndex;
              }
            else if(direction<0)
              {
               direction=1;
               SaveTrough(last);
               NextIndex;
              }
            last=i;
           }
        }
      else //direction==0
        {
         if(m_rates[i].high>m_rates[max].high) max=i;
         if(m_rates[i].low<m_rates[min].low) min=i;
         if(m_rates[max].high>m_rates[min].low+m_range)
           {
            if(max>min)
              {
               direction=1;
               SaveTrough(min);
              }
            else if(min>max)
              {
               direction=-1;
               SavePeek(max);
              }
            else
              {
               if(m_rates[i].open>m_rates[i].close)
                 {
                  direction=1;
                  SaveTrough(min);
                 }
               else
                 {
                  direction=-1;
                  SavePeek(max);
                 }
              }
            NextIndex;
            last=i;
           }
        }
      if(m_total==0 && n>=lc)
        {
         gesize+=100;
         lc=gesize-4;
         if(ArrayResize(m_ge,gesize)!=gesize) break;
        }
     }
//---
   ArrayResize(m_ge,n);
   ArraySetAsSeries(m_rates,dr);
   return(n);
  }
//+------------------------------------------------------------------+
