//+------------------------------------------------------------------+
//|                                                   			 Tree |
//|                             Copyright 2006-2011, www.FXmaster.de |
//|                                                  www.FXmaster.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2011, www.FXmaster.de"
#property link      "www.FXmaster.de"
#property version   "1.00"

#include "Node.mqh"

//------------------------------------------------------------------	class CTreeBase
class CTreeBase
{
public:
	CNode *m_root; // first node of the tree
	int m_maxid; 	// counter of ID

//--- basic functions
public:
	CTreeBase(); // constructor
	~CTreeBase(); // destructor
	void Clear(CNode *root=NULL); // deleting all nodes starting from a specified one
	CNode* FindNode(int id, CNode *root=NULL); // search a node by ID starting from a specified node
	CNode* FindNode(string txt, CNode *root=NULL); // search a node by 'txt' starting from a specified one
	int GetID(string txt, CNode *root=NULL); // getting ID for a specified Text, search is started from a specified node
	int GetMaxID(CNode *root=NULL); // getting maximal ID in the tree
	int AddNode(int id, string text, CNode *root=NULL); // adding to the list by ID, search is started from a specified node
	int AddNode(string txt, string text, CNode *root=NULL); // adding to the list by text of the node, search is started from a specified node
	int AddNode(CNode *root, string text); // add under root
};
//------------------------------------------------------------------	CTreeBase
void CTreeBase::CTreeBase()
{
	m_maxid=0; m_root=new CNode; 
	m_root.m_id=m_maxid; m_root.m_text="__base__";
}
//------------------------------------------------------------------	~CTreeBase
void CTreeBase::~CTreeBase() 
{
	delete m_root; m_maxid=0; // reset counter
}
//------------------------------------------------------------------	Reset
void CTreeBase::Clear(CNode *root=NULL)
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer
	root.m_uses=0; root.m_tick=0; // zeroize in the current node 
	int n=ArraySize(root.m_next); 
	for (int i=0; i<n; i++) // zeroize the entire branch
		if (!NIL(root.m_next[i])) // validity of pointer
			delete root.m_next[i];
	ArrayResize(root.m_next, 0);
	m_maxid=GetMaxID(); // reset counter
}
//------------------------------------------------------------------	FindNode
CNode* CTreeBase::FindNode(int id, CNode *root=NULL)
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return(NULL); // validity of pointer
	if (root.m_id==id) return(root); // if id is found, assign it and exit
	CNode *node; int n=ArraySize(root.m_next);
	for (int i=0; i<n; i++) // otherwise check the array
	{
		if (NIL(root.m_next[i])) continue; // validity of pointer
		node=FindNode(id, root.m_next[i]); if (!NIL(node)) return(node); // check at the node
	}
	return(NULL);
}
//------------------------------------------------------------------	FindNode
CNode* CTreeBase::FindNode(string txt, CNode *root=NULL)
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return(NULL); // validity of pointer
	if (root.m_text==txt) return(root); // if text is found, assign it and exit
	CNode *node; int n;
	n=ArraySize(root.m_next);
	for (int i=0; i<n; i++) // otherwise check the array
	{
		if (NIL(root.m_next[i])) continue; // validity of pointer
		node=FindNode(txt, root.m_next[i]); if (!NIL(node)) return(node); // checked at the node
	}
	return(NULL);
}
//------------------------------------------------------------------	GetID
int CTreeBase::GetID(string txt, CNode *root=NULL)
{
	CNode *node=FindNode(txt, root); if (NIL(node)) return(-1);
	return(node.m_id);
}
//------------------------------------------------------------------	GetMaxID
int CTreeBase::GetMaxID(CNode *root=NULL) // getting maximal ID
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return(-1); // validity of pointer
	int max=root.m_id;
	int n=ArraySize(root.m_next);
	for (int i=0; i<n; i++) // otherwise check the array
	{
		if (NIL(root.m_next[i])) continue; // validity of pointer
		max=MathMax(max, GetMaxID(root.m_next[i]));
	}
	return(max);
}
//------------------------------------------------------------------	AddNode
int CTreeBase::AddNode(int id, string text, CNode *root=NULL)
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(-1);
	int size=ArraySize(node.m_next); bool b=false; int i;
	for (i=0; i<size; i++) // search for a node with the same text
	{
		if (NIL(node.m_next[i])) continue; // validity of pointer
		if (node.m_next[i].m_text==text) { b=true; break; }
	}
	if (b) return(node.m_next[i].m_id); // if the node is found
	// otherwise add 
	ArrayResize(node.m_next, size+1); node.m_next[size]=new CNode; m_maxid++;
	node.m_next[size].m_id=m_maxid; node.m_next[size].m_text=text; node.m_next[size].m_prev=node; 
	return(node.m_next[size].m_id);
}
//------------------------------------------------------------------	AddNode
int CTreeBase::AddNode(string txt, string text, CNode *root=NULL)
{
	CNode *node=FindNode(txt, root); if (NIL(node)) return(-1);
	int size=ArraySize(node.m_next); bool b=false; int i;
	for (i=0; i<size; i++) // search for a node with the same text
	{
		if (NIL(node.m_next[i])) continue; // validity of pointer
		if (node.m_next[i].m_text==text) { b=true; break; }
	}
	if (b) return(node.m_next[i].m_id); // if the node is found
	// otherwise add 
	ArrayResize(node.m_next, size+1); node.m_next[size]=new CNode; m_maxid++;
	node.m_next[size].m_id=m_maxid; node.m_next[size].m_text=text; node.m_next[size].m_prev=node; 
	return(node.m_next[size].m_id);
}
//------------------------------------------------------------------	AddNode
int CTreeBase::AddNode(CNode *node, string text)
{
	if (node==NULL) node=m_root; if (NIL(node)) return(-1);
	int size=ArraySize(node.m_next); bool b=false; int i;
	for (i=0; i<size; i++) // search for a node with the same text
	{
		if (NIL(node.m_next[i])) continue; // validity of pointer
		if (node.m_next[i].m_text==text) { b=true; break; }
	}
	if (b) return(node.m_next[i].m_id); // if the node is found
	// otherwise add 
	ArrayResize(node.m_next, size+1);
	node.m_next[size]=new CNode; m_maxid++;
	node.m_next[size].m_id=m_maxid; node.m_next[size].m_prev=node; 
	node.m_next[size].m_text=text;
	return(node.m_next[size].m_id);
}


#define TG_ALL		0x00000001
#define TG_ID			0x00000002
#define TG_TEXT		0x00000004
#define TG_PATH		0x00000008
#define TG_FILE		0x00000010
#define TG_CLASS	0x00000020
#define TG_FUNC		0x00000040
#define TG_DESC		0x00000080
#define TG_EDIT		0x00000100
#define TG_BRKUSE	0x00000200
#define TG_UP			0x00000400
//------------------------------------------------------------------	class CTreeCtrl
class CTreeCtrl : public CTreeBase
{
public:
	int m_mode; // type of tree (for the TraceView type of view)

//--- basic functions
public:
	CTreeCtrl() { m_bBreak=true; m_mode=0; m_root.m_path=""; m_root.m_file="__base__"; m_root.m_line=0; m_root.m_func="__base__"; m_root.m_class="__base__"; } // constructor
	~CTreeCtrl() { delete m_root; m_maxid=0; } // destructor
	void Reset(CNode *root=NULL); // reset the state of all nodes
	void SetDataBy(int mode, int id, string text, CNode *root=NULL); // modification of properties for a specified ID, search is started from a specified node
	void SetDataBy(int mode, int id, int data, CNode *root=NULL); // modification of properties for a specified ID, search is started from a specified node
	string GetDataBy(int mode, int id, CNode *root=NULL); // getting properties for a specified ID, search is started from a specified node

//--- processing of state
public:
	bool IsExpand(int id, CNode *root=NULL); // getting the m_expand property for a specified ID, search is started from a specified ID
	bool ExpandIt(int id, bool state, CNode *root=NULL); // change the m_expand state, search is started from a specified ID
	void ExpandBy(int mode, CNode *node, bool state, CNode *root=NULL); // expand the nodes of the one that have just been specified

	bool IsCheck(int id, CNode *root=NULL); // getting the m_check property for a specified ID, search is started from a specified ID
	bool CheckIt(int id, bool state, CNode *root=NULL); // change the m_check state to the required one starting from a specified node
	void CheckBy(int mode, CNode *node, bool state, CNode *root=NULL); // mark the  entire tree

	bool IsSelect(int id, CNode *root=NULL); // getting the m_select property for a specified ID, search is started from a specified ID
	bool SelectIt(int id, bool state, CNode *root=NULL); // change the m_select state starting from a specified node
	void SelectBy(int mode, CNode *node, bool state, CNode *root=NULL); // highlight the whole tree

	bool IsBreak(int id, CNode *root=NULL); // getting the m_break property for a specified ID, search is started from a specified node
	bool BreakIt(int id, bool state, CNode *root=NULL); // change the m_break state starting from a specified node
	void BreakBy(int mode, CNode *node, bool state, CNode *root=NULL); // set only for the specified one 
	bool m_bBreak; // flag of allowing the mode of debugging

//--- operations with nodes
public:
	void SortBy(int mode, bool ascend, CNode *root=NULL); // sorting by a property
	void GroupBy(int mode, CTreeCtrl* atree, CNode* node=NULL); // grouping by a property
};
//------------------------------------------------------------------	Reset
void CTreeCtrl::Reset(CNode *root=NULL)
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer
	root.m_uses=0; root.m_tick=0; // zeroize in the current node 
	int n=ArraySize(root.m_next); 
	for (int i=0; i<n; i++) // zeroize the entire branch
		if (!NIL(root.m_next[i])) // validity of pointer
			Reset(root.m_next[i]); 
}
//------------------------------------------------------------------	SetDataBy
void CTreeCtrl::SetDataBy(int mode, int id, string text, CNode *root=NULL)
{
	CNode *node=FindNode(id, root); if (NIL(node)) return;
	if (bool(mode&TG_TEXT)) node.m_text=text;
	if (bool(mode&TG_PATH)) node.m_path=text;
	if (bool(mode&TG_FILE)) node.m_file=text;
	if (bool(mode&TG_CLASS)) node.m_class=text;
	if (bool(mode&TG_FUNC)) node.m_func=text;
	if (bool(mode&TG_DESC)) node.m_desc=text;
}
//------------------------------------------------------------------	SetDataBy
void CTreeCtrl::SetDataBy(int mode, int id, int data, CNode *root=NULL)
{
	CNode *node=FindNode(id, root); if (NIL(node)) return;
	if (bool(mode&TG_ID)) node.m_id=data;
	if (bool(mode&TG_EDIT)) node.m_edit=bool(data);
	if (bool(mode&TG_BRKUSE)) node.m_brkuse=data;
}
//------------------------------------------------------------------	GetDataBy
string CTreeCtrl::GetDataBy(int mode, int id, CNode *root=NULL) // getting text for a specified ID, search is started from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return("");
	switch(mode)
	{
		case TG_ID: return(string(node.m_id));
		case TG_TEXT: return(node.m_text);
		case TG_PATH: return(node.m_path);
		case TG_FILE: return(node.m_file);
		case TG_CLASS: return(node.m_class);
		case TG_FUNC: return(node.m_func);
		case TG_DESC: return(node.m_desc);
		case TG_EDIT: return(string(node.m_edit));
		case TG_BRKUSE: return(string(node.m_brkuse));
	}
	return("");
}
//------------------------------------------------------------------	IsExpand
bool CTreeCtrl::IsExpand(int id, CNode *root=NULL) // getting the m_expand property for a specified ID, search is started from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	return(node.m_expand);
}
//------------------------------------------------------------------	ExpandIt
bool CTreeCtrl::ExpandIt(int id, bool state, CNode *root=NULL) // change the m_expand state starting from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	node.m_expand=state; return(true); // if it is found, change it and exit
}
//------------------------------------------------------------------	ExpandBy
void CTreeCtrl::ExpandBy(int mode, CNode *node, bool state, CNode *root=NULL) // expand the entire tree
{
	if (mode!=TG_ALL && mode!=TG_UP && mode!=(TG_ALL|TG_UP)) 
		if (NIL(node)) { Print(__FUNCTION__+" node==0"); return; } // validity of pointer

	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer
	bool b=true;
	if (bool(mode&TG_ID)) b=b&&(root.m_id==node.m_id);
	if (bool(mode&TG_TEXT)) b=b&&(root.m_text==node.m_text);
	if (bool(mode&TG_PATH)) b=b&&(root.m_path==node.m_path);
	if (bool(mode&TG_FILE)) b=b&&(root.m_file==node.m_file);
	if (bool(mode&TG_CLASS)) b=b&&(root.m_class==node.m_class);
	if (bool(mode&TG_FUNC)) b=b&&(root.m_func==node.m_func);
	if (bool(mode&TG_DESC)) b=b&&(root.m_desc==node.m_desc);
	if (bool(mode&TG_EDIT)) b=b&&(root.m_edit==node.m_edit);
	if (bool(mode&TG_BRKUSE)) b=b&&(root.m_brkuse==node.m_brkuse);
	
	if (b) root.m_expand=state; // expand
	
	if (!bool(mode&TG_UP))
	{
		int n=ArraySize(root.m_next);
		for (int i=0; i<n; i++) // otherwise check the array
		{
			if (NIL(root.m_next[i])) continue; // validity of pointer
			ExpandBy(mode, node, state, root.m_next[i]); // checked at the node
		}
	}
	else if (!NIL(root.m_prev)) // validity of pointer
		ExpandBy(TG_UP, node, state, root.m_prev); // checked at the node
}

//------------------------------------------------------------------	IsCheck
bool CTreeCtrl::IsCheck(int id, CNode *root=NULL) // getting the m_check property for a specified ID, search is started from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	return(node.m_check);
}
//------------------------------------------------------------------	CheckIt
bool CTreeCtrl::CheckIt(int id, bool state, CNode *root=NULL) // change the m_check state to the required one starting from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	node.m_check=state; return(true); // if it is found, change it and exit
}
//------------------------------------------------------------------	CheckBy
void CTreeCtrl::CheckBy(int mode, CNode *node, bool state, CNode *root=NULL) // mark the entire tree
{
	if (mode!=TG_ALL) if (NIL(node)) { Print(__FUNCTION__+" node==0"); return; } // validity of pointer
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer
	bool b=true;
	if (bool(mode&TG_ID)) b=b&&(root.m_id==node.m_id);
	if (bool(mode&TG_TEXT)) b=b&&(root.m_text==node.m_text);
	if (bool(mode&TG_PATH)) b=b&&(root.m_path==node.m_path);
	if (bool(mode&TG_FILE)) b=b&&(root.m_file==node.m_file);
	if (bool(mode&TG_CLASS)) b=b&&(root.m_class==node.m_class);
	if (bool(mode&TG_FUNC)) b=b&&(root.m_func==node.m_func || node.m_func=="");
	if (bool(mode&TG_DESC)) b=b&&(root.m_desc==node.m_desc);
	if (bool(mode&TG_EDIT)) b=b&&(root.m_edit==node.m_edit);
	if (bool(mode&TG_BRKUSE)) b=b&&(root.m_brkuse==node.m_brkuse);

	if (b) root.m_check=state; // mark
	
	if (!bool(mode&TG_UP))
	{
		int n=ArraySize(root.m_next);
		for (int i=0; i<n; i++) // otherwise check the array
		{
			if (NIL(root.m_next[i])) continue; // validity of pointer
			CheckBy(mode, node, state, root.m_next[i]); // checked at the node
		}
	}
	else if (!NIL(root.m_prev)) // validity of pointer
		CheckBy(TG_UP, node, state, root.m_prev); // checked at the node
}

//------------------------------------------------------------------	IsSelect
bool CTreeCtrl::IsSelect(int id, CNode *root=NULL) // getting the m_select property for a specified ID, search is started from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	return(node.m_select);
}
//------------------------------------------------------------------	SelectIt
bool CTreeCtrl::SelectIt(int id, bool state, CNode *root=NULL) // change the m_select state to the required one starting from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	node.m_select=state; return(true); // if it is found, change is and exit
}
//------------------------------------------------------------------	SelectBy
void CTreeCtrl::SelectBy(int mode, CNode *node, bool state, CNode *root=NULL) // highlight the entire tree
{
	if (mode!=TG_ALL) if (NIL(node)) { Print(__FUNCTION__+" node==0"); return; } // validity of pointer
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) { Print(__FUNCTION__+" root==0"); return; } // validity of the pointer
	bool b=true;
	if (bool(mode&TG_ID)) b=b&&(root.m_id==node.m_id);
	if (bool(mode&TG_TEXT)) b=b&&(root.m_text==node.m_text);
	if (bool(mode&TG_PATH)) b=b&&(root.m_path==node.m_path);
	if (bool(mode&TG_FILE)) b=b&&(root.m_file==node.m_file);
	if (bool(mode&TG_CLASS)) b=b&&(root.m_class==node.m_class);
	if (bool(mode&TG_FUNC)) b=b&&(root.m_func==node.m_func || node.m_func=="");
	if (bool(mode&TG_DESC)) b=b&&(root.m_desc==node.m_desc);
	if (bool(mode&TG_EDIT)) b=b&&(root.m_edit==node.m_edit);
	if (bool(mode&TG_BRKUSE)) b=b&&(root.m_brkuse==node.m_brkuse);

	if (b) root.m_select=state; // highlight

	if (!bool(mode&TG_UP))
	{
		int n=ArraySize(root.m_next);
		for (int i=0; i<n; i++) // otherwise check the array
		{
			if (NIL(root.m_next[i])) continue; // validity of pointer
			SelectBy(mode, node, state, root.m_next[i]); // checked at the node
		}
	}
	else if (!NIL(root.m_prev)) // validity of pointer
		SelectBy(TG_UP, node, state, root.m_prev); // checked at the node
}
//------------------------------------------------------------------	IsBreak
bool CTreeCtrl::IsBreak(int id, CNode *root=NULL) // getting the m_break property for a specified ID, search is started for a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	return(node.m_break);
}
//------------------------------------------------------------------	BreakIt
bool CTreeCtrl::BreakIt(int id, bool state, CNode *root=NULL) // change the m_break state starting from a specified node
{
	CNode *node=FindNode(id, root); if (NIL(node)) return(false);
	node.m_break=state; return(true); // if it is found, change it and exit
}
//------------------------------------------------------------------	BreakBy
void CTreeCtrl::BreakBy(int mode, CNode *node, bool state, CNode *root=NULL) // set only for the specified one 
{
	if (mode!=TG_ALL) if (NIL(node)) { Print(__FUNCTION__+" node==0"); return; } // validity of pointer
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) { Print(__FUNCTION__+" root==0"); return; } // validity of the pointer
	bool b=true;
	if (bool(mode&TG_ID)) b=b&&(root.m_id==node.m_id);
	if (bool(mode&TG_TEXT)) b=b&&(root.m_text==node.m_text);
	if (bool(mode&TG_PATH)) b=b&&(root.m_path==node.m_path);
	if (bool(mode&TG_FILE)) b=b&&(root.m_file==node.m_file);
	if (bool(mode&TG_CLASS)) b=b&&(root.m_class==node.m_class);
	if (bool(mode&TG_FUNC)) b=b&&(root.m_func==node.m_func || node.m_func=="");
	if (bool(mode&TG_DESC)) b=b&&(root.m_desc==node.m_desc);
	if (bool(mode&TG_EDIT)) b=b&&(root.m_edit==node.m_edit);
	if (bool(mode&TG_BRKUSE)) b=b&&(root.m_brkuse==node.m_brkuse);

	if (b) root.m_break=state; // highlight

	if (!bool(mode&TG_UP))
	{
		int n=ArraySize(root.m_next);
		for (int i=0; i<n; i++) // otherwise check the array
		{
			if (NIL(root.m_next[i])) continue; // validity of pointer
			BreakBy(mode, node, state, root.m_next[i]); // checked at the node
		}
	}
	else if (!NIL(root.m_prev)) // validity of pointer
		BreakBy(TG_UP, node, state, root.m_prev); // checked at the node
}

//------------------------------------------------------------------	SortBy
void CTreeCtrl::SortBy(int mode, bool ascend, CNode *root=NULL) // sorting by a property
{
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer

	int n=ArraySize(root.m_next); 
	bool b=true; CNode *node;
	while (b && n>1)
	{
		b=false;string st1="", st2=""; 
		for (int i=1; i<n; i++) // compare and sort
		{
			// required group of sorting
			st1=root.m_next[i-1].m_text; st2=root.m_next[i].m_text;
			if (mode==TG_ID) { st1=string(root.m_next[i-1].m_id); st2=string(root.m_next[i].m_id); }
			if (mode==TG_PATH) { st1=root.m_next[i-1].m_path; st2=root.m_next[i].m_path; }
			if (mode==TG_FILE) { st1=root.m_next[i-1].m_file; st2=root.m_next[i].m_file; }
			if (mode==TG_CLASS) { st1=root.m_next[i-1].m_class; st2=root.m_next[i].m_class; }
			if (mode==TG_FUNC) { st1=root.m_next[i-1].m_func; st2=root.m_next[i].m_func; }
			if (mode==TG_DESC) { st1=root.m_next[i-1].m_desc; st2=root.m_next[i].m_desc; }
			if (mode==TG_EDIT) { st1=string(root.m_next[i-1].m_edit); st2=string(root.m_next[i].m_edit); }
			if (mode==TG_BRKUSE) { st1=string(root.m_next[i-1].m_brkuse); st2=string(root.m_next[i].m_brkuse); }
			StringToLower(st1); StringToLower(st2); 

			if ((ascend && st1>=st2) || (!ascend && st1<st2))
			{ b=true; node=root.m_next[i-1]; root.m_next[i-1]=root.m_next[i]; root.m_next[i]=node; }
		}
	}
	for (int i=0; i<n; i++) // check the array deeper
	{
		if (NIL(root.m_next[i])) continue; // validity of pointer
		SortBy(mode, ascend, root.m_next[i]); // checked at the node
	}
}
//------------------------------------------------------------------	GroupBy
void CTreeCtrl::GroupBy(int mode, CTreeCtrl* atree, CNode* root=NULL)
{
	if (NIL(atree) || atree==NULL) return; // validity of pointer
	if (root==NULL) root=m_root; // if we've just started, set the first one
	if (NIL(root)) return; // validity of pointer
	if (root!=m_root)
	{
		int id; string st=" ";
		if (mode==TG_PATH) st=root.m_path; // group by file path
		if (mode==TG_FILE) st=root.m_file; // group by file name
		if (mode==TG_CLASS) st=root.m_class; // group by class name
		id=atree.AddNode(0, st);
		atree.SetDataBy(TG_PATH, id, root.m_path);
		atree.SetDataBy(TG_FILE, id, root.m_file);
		atree.SetDataBy(TG_CLASS, id, root.m_class);

		id=atree.AddNode(st, root.m_func);
		CNode *node=atree.FindNode(id);
		node.m_uses=root.m_uses; // number of calls of the node
		node.m_tick=root.m_tick; // time spent in the node
		node.m_tick0=root.m_tick0; // time of entering the node
		node.m_last=root.m_last; // time of entering the node
		node.m_path=root.m_path; // file path
		node.m_file=root.m_file; // name of file
		node.m_line=root.m_line; // number of row in the file
		node.m_class=root.m_class; // class name
		node.m_func=root.m_func; // function name
		node.m_desc=root.m_desc; // add. info
		node.m_edit=root.m_edit; // edited field
		node.m_brkuse=root.m_brkuse; // edited field
	}
	int n=ArraySize(root.m_next);
	for (int i=0; i<n; i++) // otherwise check the array
	{
		if (NIL(root.m_next[i])) continue; // validity of pointer
		GroupBy(mode, atree, root.m_next[i]); // checked at the node
	}
}
