//+------------------------------------------------------------------+
//|                                                     		GraphLib |
//|                                    Copyright  2010, FXMaster.de |
//|                                      mailto: profy.mql@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, FXMaster.de"
#property link      "mailto: profy.mql@gmail.com"

//---------------  OBJECT FUNCTION  --------------------//
//------------------------------------------------------------------ SetLabel
void SetLabel(long achart, string name, int wnd, string text, color clr, int x, int y, int corn=0, int fontsize=8, string font="Tahoma")
{
	ObjectCreate(achart, name, OBJ_LABEL, wnd, 0, 0); 
	ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); 
	ObjectSetInteger(achart, name, OBJPROP_FONTSIZE, fontsize); ObjectSetString(achart, name, OBJPROP_FONT, font);
	ObjectSetInteger(achart, name, OBJPROP_SELECTABLE, false); 
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
}
//------------------------------------------------------------------ SetButton
void SetButton(long achart, string name, int wnd, string text, color clr, color bgclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Tahoma", bool state=true)
{
	ObjectCreate(achart, name, OBJ_BUTTON, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); ObjectSetInteger(achart, name, OBJPROP_STATE, state);
	ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); ObjectSetInteger(achart, name, OBJPROP_BGCOLOR, bgclr);
	ObjectSetInteger(achart, name, OBJPROP_FONTSIZE, fontsize); ObjectSetString(achart, name, OBJPROP_FONT, font);
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
	ObjectSetInteger(achart, name, OBJPROP_SELECTABLE, false);
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
}
//------------------------------------------------------------------ SetRectLbl
void SetRectLbl(long achart, string name, int wnd, string text, color clr, color bgclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Tahoma", bool ro=true)
{
	ObjectCreate(achart, name, OBJ_RECTANGLE_LABEL, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); 
	ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); ObjectSetInteger(achart, name, OBJPROP_BGCOLOR, bgclr); 
	ObjectSetInteger(achart, name, OBJPROP_FONTSIZE, fontsize); ObjectSetString(achart, name, OBJPROP_FONT, font);
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
	ObjectSetInteger(achart, name, OBJPROP_SELECTABLE, false); ObjectSetInteger(achart, name, OBJPROP_READONLY, ro); 
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
}
//------------------------------------------------------------------ SetEdit
void SetEdit(long achart, string name, int wnd, string text, color clr, color bgclr, int x, int y, int dx, int dy, int corn=0, int fontsize=8, string font="Tahoma", bool ro=true)
{
	ObjectCreate(achart, name, OBJ_EDIT, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); 
	ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); ObjectSetInteger(achart, name, OBJPROP_BGCOLOR, bgclr); 
	ObjectSetInteger(achart, name, OBJPROP_FONTSIZE, fontsize); ObjectSetString(achart, name, OBJPROP_FONT, font);
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
	ObjectSetInteger(achart, name, OBJPROP_SELECTABLE, false); ObjectSetInteger(achart, name, OBJPROP_READONLY, ro); 
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
}
//------------------------------------------------------------------ SetImgButton
void SetImgButton(long achart, string name, int wnd, string text, color clr, int x, int y, int dx, int dy, int corn, string fileOn, string fileOff)
{
	ObjectCreate(achart, name, OBJ_BITMAP_LABEL, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); 
	ObjectSetString(achart, name, OBJPROP_BMPFILE, 0, fileOn); ObjectSetString(achart, name, OBJPROP_BMPFILE, 1, fileOff); 
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
}
//------------------------------------------------------------------ SetImage
void SetImage(long achart, string name, int wnd, string text, color clr, int x, int y, int dx, int dy, int corn, string file)
{
	ObjectCreate(achart, name, OBJ_BITMAP, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); 
	ObjectSetString(achart, name, OBJPROP_BMPFILE, file); 
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
	ObjectSetInteger(achart, name, OBJPROP_BORDER_TYPE, 0);
}
//------------------------------------------------------------------ SetArrow
void SetArrow(long achart, string name, datetime dt, double pr, color clr, int arr, string st)
{
	ObjectCreate(achart, name, OBJ_ARROW, 0, dt, pr);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 0, dt); ObjectSetDouble(achart, name, OBJPROP_PRICE, 0, pr);
	ObjectSetInteger(achart, name, OBJPROP_ARROWCODE, arr); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr);
	ObjectSetString(achart, name, OBJPROP_TEXT, st);
}
//------------------------------------------------------------------ SetText
void SetText(long achart, string name, int wnd, string text, datetime dt, double pr, color clr, int fontsize, string font)
{
	ObjectCreate(achart, name, OBJ_TEXT, wnd, 0, 0); 
	ObjectSetString(achart, name, OBJPROP_TEXT, text); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr); 
	ObjectSetInteger(achart, name, OBJPROP_FONTSIZE, fontsize); ObjectSetString(achart, name, OBJPROP_FONT, font);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 0, dt); ObjectSetDouble(achart, name, OBJPROP_PRICE, 0, pr);
}
//------------------------------------------------------------------ SetLine
void SetLine(long achart, string name, datetime dt1, double pr1, datetime dt2, double pr2, color clr, int width, int style, string st)
{
	ObjectCreate(achart, name, OBJ_TREND, 0, 0, 0); 
	ObjectSetInteger(achart, name, OBJPROP_RAY_LEFT, false); ObjectSetInteger(achart, name, OBJPROP_RAY_RIGHT, false);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 0, dt1); ObjectSetDouble(achart, name, OBJPROP_PRICE, 0, pr1);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 1, dt2); ObjectSetDouble(achart, name, OBJPROP_PRICE, 1, pr2);
	ObjectSetInteger(achart, name, OBJPROP_WIDTH, width); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr);
	ObjectSetString(achart, name, OBJPROP_TEXT, st); ObjectSetInteger(achart, name, OBJPROP_STYLE, style);
}
//------------------------------------------------------------------ SetHLine
void SetHLine(long achart, string name, double pr, color clr, int width, int style, string st)
{
	ObjectCreate(achart, name, OBJ_HLINE, 0, 0, 0); ObjectSetDouble(achart, name, OBJPROP_PRICE, 0, pr);
	ObjectSetInteger(achart, name, OBJPROP_WIDTH, width); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr);
	ObjectSetString(achart, name, OBJPROP_TEXT, st); ObjectSetInteger(achart, name, OBJPROP_STYLE, style);
}

//------------------------------------------------------------------ SetVLine
void SetVLine(long achart, string name, datetime dt, color clr, int width, int style, string st)
{
	ObjectCreate(achart, name, OBJ_VLINE, 0, 0, 0); ObjectSetInteger(achart, name, OBJPROP_TIME, 0, dt);
	ObjectSetInteger(achart, name, OBJPROP_WIDTH, width); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr);
	ObjectSetString(achart, name, OBJPROP_TEXT, st); ObjectSetInteger(achart, name, OBJPROP_STYLE, style);
}
//------------------------------------------------------------------ SetRect
void SetRect(long achart, string name, int wnd, datetime dt1, double pr1, datetime dt2, double pr2, color clr, string st)
{
	ObjectCreate(achart, name, OBJ_RECTANGLE, wnd, 0, 0);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 0, dt1); ObjectSetDouble(achart, name, OBJPROP_PRICE, 0, pr1);
	ObjectSetInteger(achart, name, OBJPROP_TIME, 1, dt2); ObjectSetDouble(achart, name, OBJPROP_PRICE, 1, pr2);
	ObjectSetInteger(achart, name, OBJPROP_WIDTH, 1); ObjectSetInteger(achart, name, OBJPROP_COLOR, clr);
	ObjectSetString(achart, name, OBJPROP_TEXT, ""); ObjectSetInteger(achart, name, OBJPROP_STYLE, STYLE_SOLID);
}
//------------------------------------------------------------------ SetVLine
void SetChart(long achart, string name, int wnd, int x, int y, int dx, int dy, int corn, string smb, ENUM_TIMEFRAMES tf)
{
	ObjectCreate(achart, name, OBJ_CHART, wnd, 0, 0); ObjectSetInteger(achart, name, OBJPROP_CORNER, corn); 
	ObjectSetString(achart, name, OBJPROP_SYMBOL, smb); ObjectSetInteger(achart, name, OBJPROP_TIMEFRAMES, tf); 
	ObjectSetInteger(achart, name, OBJPROP_XDISTANCE, x); ObjectSetInteger(achart, name, OBJPROP_YDISTANCE, y);
	ObjectSetInteger(achart, name, OBJPROP_XSIZE, dx); ObjectSetInteger(achart, name, OBJPROP_YSIZE, dy);
}
//------------------------------------------------------------------ ObjectsDeleteAll2
void ObjectsDeleteAll2(long achart=0, int wnd=-1, int type=-1, string pref="")
{
	string st, names[]; int i, n=ObjectsTotal(achart, wnd, type); ArrayResize(names, n);
	for (i=0; i<n; i++) names[i]=ObjectName(achart, i);
	for (i=0; i<n; i++) 
	{
		if (wnd>=0) if (ObjectFind(achart, names[i])!=wnd) continue;
		if (type>=0) if (ObjectGetInteger(achart, names[i], OBJPROP_TYPE)!=type) continue;
		if (pref!="") if (StringSubstr(names[i], 0, StringLen(pref))!=pref) continue;
		ObjectDelete(achart, names[i]);
	}
}
//------------------------------------------------------------------	HideChart
void HideChart(long achart, color BackClr)
{	
	ChartSetInteger(achart, CHART_SHOW_OHLC, false);
	ChartSetInteger(achart, CHART_SHOW_BID_LINE, false);
	ChartSetInteger(achart,CHART_SHOW_ASK_LINE, false);
	ChartSetInteger(achart,CHART_SHOW_LAST_LINE, false);
	ChartSetInteger(achart,CHART_SHOW_PERIOD_SEP, false);
	ChartSetInteger(achart, CHART_SHOW_GRID, false);
	ChartSetInteger(achart, CHART_SHOW_VOLUMES, CHART_VOLUME_HIDE);
	ChartSetInteger(achart, CHART_SHOW_OBJECT_DESCR, false);
	ChartSetInteger(achart, CHART_SHOW_TRADE_LEVELS, false);
	ChartSetInteger(achart, CHART_SHOW_DATE_SCALE, false);
	ChartSetInteger(achart, CHART_SHOW_PRICE_SCALE, false);
	ChartSetInteger(achart, CHART_FOREGROUND, false);
	ChartSetInteger(achart, CHART_SHIFT, false);
	ChartSetInteger(achart, CHART_MODE, CHART_LINE);
	ChartSetInteger(achart, CHART_SCALE, 0);
	
	ChartSetInteger(achart, CHART_COLOR_BACKGROUND, BackClr);
	ChartSetInteger(achart, CHART_COLOR_FOREGROUND, BackClr);
	ChartSetInteger(achart, CHART_COLOR_CHART_LINE, BackClr);
	ChartSetInteger(achart, CHART_COLOR_ASK, BackClr);
	ChartSetInteger(achart, CHART_COLOR_BID, BackClr);
	ChartSetInteger(achart, CHART_SCALEFIX, true);
	ChartSetDouble(achart, CHART_FIXED_MAX, 1);
	ChartSetDouble(achart, CHART_FIXED_MIN, 1);
	ChartSetString(achart, CHART_COMMENT, "");
	ChartRedraw(0);
}
//---------------------------------------------------------------   DTS
string DTS(double d, int n=-1) { if (n<0) return(DoubleToString(d, _Digits)); else return(DoubleToString(d, n)); }
//---------------------------------------------------------------   BTS
string BTS(bool b) { if (b) return(""); return(""); }
//---------------------------------------------------------------   ITS
string ITS(double d) { return(DoubleToString(d, 0)); }
//---------------------------------------------------------------   TTS
string TTS(datetime time) { if (time<=0) return("---"); return(TimeToString(time, TIME_DATE|TIME_SECONDS)); }
