//+------------------------------------------------------------------+
//|                                                    Templates.mq5 |
//|                                            Copyright 2010, Urain |
//|                            https://login.mql5.com/ru/users/Urain |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, Urain"
#property link      "https://login.mql5.com/ru/users/Urain"
#property version   "1.00"
#property script_show_inputs

#define startread "//this_is_the_start_point"
#define endread "//this_is_the_end_point"
/*///--- place for storing pre-templates of types
"long;double;datetime;string"
"int;float,int,string"
/*///---
input string folder="Example templat";//name of file for processing
//+------------------------------------------------------------------+
input string type="long;double;datetime;string"
            ;//names of custom types, separator ";"
string TEMPLAT="_XXX_";// template name
//+------------------------------------------------------------------+
input string type2="int;float;int;string"
             ;//names of custom types, separator ";"
string TEMPLAT2="_xxx_";// name of the second template
//+------------------------------------------------------------------+

string type_dates[]; // array for storing types of substitution
string type_dates2[];// 2-nd array of types of substitution
string fdates[];     // array for storing received information
string tempfdates[]; // array for operations
bool flagnew=false;  // flag of forming a pre-template file for template
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   Init_buf_type_dates();       // initialization of type_dates[],type_dates2[]
   ReadFile();                  // parsing of file
   WriteFile(ArraySize(fdates));// substitution of type, flushing data to the file
  }
//+------------------------------------------------------------------+
//| initialization of array of types                                 |
//+------------------------------------------------------------------+
void Init_buf_type_dates()
  {
   ParserInputType(0,type_dates,type);
   ParserInputType(0,type_dates2,type2);
  }
//+------------------------------------------------------------------+
//| substitution of templates with types                             |
//+------------------------------------------------------------------+
void Replace(string &temp_m[],int i,int j)
  {
   if(i>=ArraySize(temp_m))return;
   if(j<ArraySize(type_dates))
      StringReplac(temp_m[i],TEMPLAT,type_dates[j]);// substitution of templat with types
   if(j<ArraySize(type_dates2))
      StringReplac(temp_m[i],TEMPLAT2,type_dates2[j]);// substitution of templat2 with  types2
  }
///////////////////////////////////////////////////////////////////////////////////////
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ 
//+------------------------------------------------------------------+
//| reading file                                                     |
//+------------------------------------------------------------------+
void ReadFile()
  {
   string subfolder="Templates";
   int han=FileOpen(subfolder+"\\"+folder+".mqh",FILE_READ|FILE_SHARE_READ|FILE_TXT|FILE_ANSI,"\r");
   if(han!=INVALID_HANDLE)
     {
      string temp="";
      //--- scrolling to the start point
      do{temp=FileReadString(han);StringTrimLeft(temp);StringTrimRight(temp); }
      while(startread!=temp);

      string text=""; int size;
      //--- reading the file to array down to a break point or end of the file
      while(!FileIsEnding(han))
        {
         temp=text=FileReadString(han);
         // deleting symbols of tabulation to check exiting
         StringTrimLeft(temp);StringTrimRight(temp);
         if(endread==temp)break;
         // flushing data to array
         if(text!="")
           {
            size=ArraySize(fdates);
            ArrayResize(fdates,size+1);
            fdates[size]=text;
           }
        }
      FileClose(han);
     }
   else
     {
      Print("Failed to open the file "+subfolder+"\\"+folder+".mqh, error",GetLastError());
      flagnew=true;
     }
  }
//+------------------------------------------------------------------+
//| writing file                                                     |
//+------------------------------------------------------------------+ 
void WriteFile(int count)
  {
   string newfolder;
   if(flagnew)newfolder=folder;// if it is the first start, create an empty pre-template file for templates
   else newfolder=StringDel(folder," templat");// otherwise create the output file according to the template

   string subfolder="Templates";
   int han=FileOpen(subfolder+"\\"+newfolder+".mqh",FILE_WRITE|FILE_SHARE_WRITE|FILE_TXT|FILE_ANSI,"\r");
   if(han!=INVALID_HANDLE)
     {
      if(flagnew)// if the file couldn't be read
        {// fill the template file with the pre-template
         FileWrite(han,"//#define "+TEMPLAT+" "+type_dates[0]);
         FileWrite(han," ");
         FileWrite(han,startread);
         FileWrite(han," "+TEMPLAT);
         FileWrite(han,endread);
         Print("Creating pre-template "+subfolder+"\\"+folder+".mqh");
        }
      else
        {// if the file exists
         ArrayResize(tempfdates,count);
         int count_type=ArraySize(type_dates);
         //--- the cycle rewrites the contents of the file by each type of template type_dates
         for(int j=0;j<count_type;j++)
           {
            for(int i=0;i<count;i++)// copy data to the temporary array
               tempfdates[i]=fdates[i];
            for(int i=0;i<count;i++)// replace the template with types
               Replace(tempfdates,i,j);

            for(int i=0;i<count;i++)
               FileWrite(han,tempfdates[i]);// flushing the array to the file
           }
        }
      FileClose(han);
      Print("Created output file "+subfolder+"\\"+newfolder+".mqh");
     }
   else Print("File open failed"+subfolder+"\\"+newfolder+".mqh, error",GetLastError());
  }
//+------------------------------------------------------------------+
//| deleting the 'find" template from the 'text' line                |
//+------------------------------------------------------------------+
string StringDel(string text,const string find)
  {
   string  str=text;
   StringReplace(str,find,"");
   return(str);
  }
//+------------------------------------------------------------------+
//| parsing types                                                    |
//+------------------------------------------------------------------+
void ParserInputType(int i,string &type_d[],string text)
  {// recurrent function of parsing of string text to the array element by element, separator - ";"
   if(text=="")return;
   int len=StringLen(text);
   string temptext=text;
   int end=PosDelimit(temptext);// end gets the number of digits between zero and the separator 
   if(end==-1)end=len;
   ArrayResize(type_d,ArraySize(type_d)+1);
   string temp=StringSubstr(temptext,0,end);
   int td=PosDelimit(temp);
   if(td>0)StringSetCharacter(temp,td-1,NULL);
   type_d[i]=temp;
   ParserInputType(i+1,type_d,StringSubstr(temptext,end,len-end));
  }
//+------------------------------------------------------------------+
//| searching for the next position after the separator              |
//+------------------------------------------------------------------+
int PosDelimit(string text)
  {
   int res=StringFind(text,";");
   if(res!=-1)return(res+1);
   else return(-1);
  }
//+------------------------------------------------------------------+
//| StringReplac analogue of StringReplace, with substitution ...    |
//| ... of REPLACEMENT in upper case if the word contains find       |
//| a word "contains" it if there are symbols                        |
//| besides exceptions before 'find'                                 |
//+------------------------------------------------------------------+
void  StringReplac(string         &text,             // a string where the replacement is performed
                   const string    find,             // substring to be searched
                   const string    replacement,      // substring that will be inserted
                   int start=0                       // start position for the search
                   )
  {
   if(text=="")return;
   string REPLACEMENT=replacement; StringToUpper(REPLACEMENT);
   int lenfind=StringLen(find);
   int len=StringLen(text);
   if(len-start<lenfind)return;
   for(int i=start;i<len-lenfind;i++)
     {
      if(StringSubstr(text,i,lenfind)==find)
        {  
         // searching for exceptions, determines if the word contains 'find'
         // 32,160 spaces 40( 41) 123{ 125} 130 44, 59; 91[ 93]
         if((StringGetCharacter(text,i-1)==32 || 
            StringGetCharacter(text,i-1)==160||
            StringGetCharacter(text,i-1)==40||
            //StringGetCharacter(text,i-1)==41||
            StringGetCharacter(text,i-1)==123||
            StringGetCharacter(text,i-1)==125||
            StringGetCharacter(text,i-1)==44||
            StringGetCharacter(text,i-1)==59||
            StringGetCharacter(text,i-1)==130
            )
            || i==0)
            text=StringSubstr(text,0,i)+replacement+StringSubstr(text,i+lenfind,len-(i+lenfind));
         else text=StringSubstr(text,0,i)+REPLACEMENT+StringSubstr(text,i+lenfind,len-(i+lenfind));
         StringReplac(text,find,replacement,i);
         break;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
