//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                                 T3Series_Cls.mqh |
//|                                T3 code: Copyright  1998, Tilson |
//|                MQL5 T3Series: Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          | 
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| The Tilson's algorithm of averaging of price series              |
//+X================================================================X+
class CT3 : public CMovSeriesTools
 {
public:
  double   T3Series(uint begin, // number of beginning of bars for reliable calculation
                     uint prev_calculated, // amount of history in bars at previous tick
                     uint rates_total, // amount of history in bars at the current tick
                     int  Din, // permission to change the parameter Length at every bar. 
                                // 0 - prohibition to change the parameters, any other values means permission.
                     double Curvature, // coefficient (its value is increased 100 times for convenience!)
                     double Length, // depth of smoothing
                     double series,  // value of the price series calculated for the new bar with number 'bar'
                     uint bar,  // bar number
                     bool set // direction of indexing arrays
                     ); 
protected:
  void     T3Init (uint begin,
                    int Din,
                    double Curvature,
                    double Length,
                    double series,
                    uint bar
                    );

  //----+ Declaration of global variables
  double   m_b2, m_b3;
  //----
  double   m_e1, m_e2, m_e3, m_e4, m_e5, m_e6;
  double   m_E1, m_E2, m_E3, m_E4, m_E5, m_E6;
  double   m_c1, m_c2, m_c3, m_c4, m_w1, m_w2;
 };
//+X================================================================X+
//|  T3 averaging                                                    |
//+X================================================================X+
double CT3::T3Series
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int  Din, // permission to change the parameter Length at every bar. 
                    // 0 - prohibition to change the parameters, any other values means permission.
  double Curvature, // coefficient (its value is increased 100 times for convenience!)
  double Length, // depth of smoothing
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// T3Series(begin, prev_calculated, rates_total, Din, Curvature, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables
  double e0, T3_;
  
  //----+ checking for correctness the external parameter Length
  LengthCheck(Length);	 
  
  //----+ Calculation of coefficients
  T3Init(begin, Din, Curvature, Length, series, bar);
   
  e0 = series; 
  //----+ <<< calculation of T3 >>> 
  m_e1 = m_w1 * e0 + m_w2 * m_e1;
  m_e2 = m_w1 * m_e1 + m_w2 * m_e2;
  m_e3 = m_w1 * m_e2 + m_w2 * m_e3;
  m_e4 = m_w1 * m_e3 + m_w2 * m_e4;
  m_e5 = m_w1 * m_e4 + m_w2 * m_e5;
  m_e6 = m_w1 * m_e5 + m_w2 * m_e6;
  //----  
  T3_ = m_c1 * m_e6 + m_c2 * m_e5 + m_c3 * m_e4 + m_c4 * m_e3;
  
  //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
    m_e1 = m_E1; 
    m_e2 = m_E2; 
    m_e3 = m_E3; 
    m_e4 = m_E4; 
    m_e5 = m_E5;
    m_e6 = m_E6;
   }
  
  //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set))
   {

    m_E1 = m_e1; 
    m_E2 = m_e2; 
    m_E3 = m_e3; 
    m_E4 = m_e4; 
    m_E5 = m_e5; 
    m_E6 = m_e6;
   }
 
//----+ End of calculation of value of the function T3Series()
  return(T3_);
 }
//+X================================================================X+
//|  Initialization of variables of the T3 averaging                 |
//+X================================================================X+    
void CT3::T3Init
 (
  uint begin,
  int Din,
  double Curvature,
  double Length,
  double series,
  uint bar
 )
// T3InitInit(begin, Din, Curvature, Length, series, bar) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+  
  //----+ <<< Calculation of coefficients >>>
  if (bar == begin || Din != 0) 
   {
    double b = Curvature / 100.0;
    m_b2 = b * b;
    m_b3 = m_b2 * b;
    m_c1 = -m_b3;
    m_c2 = (3 * (m_b2 + m_b3));
    m_c3 = -3 * (2 * m_b2 + b + m_b3);
    m_c4 = (1 + 3 * b + m_b3 + 3 * m_b2);
    double n  = 1 + 0.5 * (Length - 1);
    m_w1 = 2 / (n + 1);
    m_w2 = 1 - m_w1;
    
    if (bar == begin)
     {
      m_e1 = series; 
      m_e2 = series; 
      m_e3 = series; 
      m_e4 = series; 
      m_e5 = series;
      m_e6 = series;
     }
   }
//----+
 }
//+X----------------------+ <<< The End >>> +-----------------------X+