//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                              ParMASeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          | 
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| The algorithm of parabolic averaging of price series             |
//+X================================================================X+
class CParMA : public CMovSeriesTools
 {
public: 
   double  ParMASeries (uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         int Length,// period of averaging
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );
protected:
   void    ParMAInit(double Length);
   
   double  m_SeriesArray[];
   int     m_Size_, m_count;
   int     m_sum_x, m_sum_x2, m_sum_x3, m_sum_x4;
 };
//+X================================================================X+
//| ParMASeries() function                                           |
//+X================================================================X+    
double CParMA::ParMASeries
 (
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// SMASeries(Number, symbol, timeframe, begin, limit, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables
  int iii, kkk;
  //----
  double S, B0, B1, B2, parma;
  double A, B, C, D, E, F; 
  double K, L, M, P, Q, R;
  double sum_y, sum_xy, sum_x2y, var_tmp; 

  //----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__, Length, m_SeriesArray, m_Size_))
      return(EMPTY_VALUE);
    
  //----+ checking for correctness the external parameter Length
  LengthCheck(Length);
  
  //----+ rearrangement of cells of the array m_SeriesArray
  Recount_ArrayZeroPos(m_count, Length, prev_calculated, series, bar, m_SeriesArray);
  
  //----+ Initialization of zero
  if(BarCheck2(begin, bar, set, Length)) ParMAInit(Length);          
  else if(BarCheck3(begin, bar, set, Length)) return(EMPTY_VALUE);
  
  //----+ Calculation ParMA
  sum_y   = 0.0;
  sum_xy  = 0.0;
  sum_x2y = 0.0;
  //----
  for (iii = 1; iii <= Length; iii++)
   {
    kkk = Recount_ArrayNumber(m_count, Length, Length - iii);
    var_tmp  = m_SeriesArray[kkk];  
    sum_y   += var_tmp;
    sum_xy  += iii * var_tmp;    
    sum_x2y += iii * iii * var_tmp; 
   }
      
 // the difference between two adjacent bars for sum_x2y: Sum(i=0; i<Length){(2*Length* - 1)*Series[i] + 2*i*Series[i]}
   
  // initialization
  A = Length;
  B = m_sum_x;  
  C = m_sum_x2; 
  F = m_sum_x3; 
  M = m_sum_x4; 
  P = sum_y;                   
  R = sum_xy; 
  S = sum_x2y;
  // intermediates
  D = B;  
  E = C;  
  K = C;  
  L = F;
  Q = D / A;  
  E = E - Q * B; 
  F = F - Q * C;  
  R = R - Q * P;  
  Q = K / A;  
  L = L - Q * B;
  M = M - Q * C; 
  S = S - Q * P; 
  Q = L / E;
  // calculate regression coefficients
  B2 = (S - R * Q) / (M - F * Q);
  B1 = (R - F * B2) / E;
  B0 = (P - B * B1 - C * B2) / A;
  // value to be returned - parabolic MA
  parma = B0 + (B1 + B2 * A) * A;
//----+
  return(parma); 
 }
//+X================================================================X+
//|  Initialization of variables of the ParMA algorithm              |
//+X================================================================X+    
void CParMA::ParMAInit(double Length)
// ParMAInit(Length)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  uint var_tmp;
  m_sum_x = 0;
  m_sum_x2 = 0;
  m_sum_x3 = 0;
  m_sum_x4 = 0;
    
  for(uint iii = 1; iii <= Length; iii++)
   {
    var_tmp  = iii;
    m_sum_x   += var_tmp; 
    var_tmp *= iii;
    m_sum_x2  += var_tmp; 
    var_tmp *= iii;
    m_sum_x3  += var_tmp; 
    var_tmp *= iii;
    m_sum_x4  += var_tmp; 
   }
//----+
 }
//+X----------------------+ <<< The End >>> +-----------------------X+