//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                               LRMASeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class Moving_Average                           | 
//+X----------------------------------------------------------------X+ 
#include <MASeries_Cls.mqh> 
//+X================================================================X+
//|  Linear regression averaging of price series                     |
//+X================================================================X+
class CLRMA  
 {
public:   
  double LRMASeries(uint begin,// number of beginning of bars for reliable calculation
                     uint prev_calculated,// amount of history in bars at the previous tick
                     uint rates_total,// amount of history in bars at the current tick
                     int Length,// period of averaging
                     double series,// value of the price series calculated for the new bar with number 'bar'
                     uint bar,// bar number
                     bool set // direction of indexing arrays
                     )
  {
//----+
   //---- Declaration of local variables
   double sma, lwma, lrma;  
  
   //---- declaration of variables of the class Moving_Average from the file MASeries_Cls.mqh
  // CMoving_Average SMA, LWMA;
  
   //---- Getting values of moving averages  
   sma = SMA.SMASeries(begin, prev_calculated, rates_total, Length, series, bar, set);
   lwma = LWMA.LWMASeries(begin, prev_calculated, rates_total, Length, series, bar, set);
 
   //---- Calculation of LRMA
   lrma = 3.0 * lwma - 2.0 * sma;
//----+
   return(lrma); 
  };

protected:
 //---- declaration of variables of the class Moving_Average
 CMoving_Average SMA, LWMA;  
 };
//+X----------------------+ <<< The End >>> +-----------------------X+