//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                                CMOSeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          | 
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| Tushar Chande's algorithms of averaging for any prices series    |
//+X================================================================X+
class CCMO : public CMovSeriesTools
 {
public: 
  double     VIDYASeries(uint begin, // number of beginning of bars for reliable calculation
                          uint prev_calculated, // amount of history in bars at previous tick
                          uint rates_total, // amount of history in bars at the current tick
                          int CMO_Length, // CMO period
                          double EMA_Length,
                          double series,  // value of the price series calculated for the new bar with number 'bar'
                          uint bar,  // bar number
                          bool set // direction of indexing arrays
                          );
                            
  double    CMOSeries(uint begin, // number of beginning of bars for reliable calculation
                       uint prev_calculated, // amount of history in bars at previous tick
                       uint rates_total, // amount of history in bars at the current tick
                       int CMO_Length, // CMO period
                       double series,
                       uint bar,  // bar number
                       bool set // direction of indexing arrays
                       );
  
protected:  
  double    m_dSeriesArray[];
  int       m_Size_, m_count;
  double    m_UpSum_, m_UpSum, m_DnSum_, m_DnSum, m_Vidya, m_Vidya_;
  double    m_AbsCMO_, m_AbsCMO, m_series1, m_series1_, m_SmoothFactor;
 };
//+X================================================================X+
//|  CMOSeries() function                                            |
//+X================================================================X+    
double CCMO::CMOSeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int CMO_Length, // CMO period
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// CMOSeries(begin, prev_calculated, rates_total, CMO_Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables;
  double dseries, abcmo;
  int iii, rrr, size = CMO_Length + 1;
  
  //----+ Changing the size of array of variables
  if (bar == begin && !SeriesArrayResize(__FUNCTION__, size, m_dSeriesArray, m_Size_))
    return(EMPTY_VALUE);
  
  //----+ checking the external parameter CMO_Length for correctness
  LengthCheck(CMO_Length);

  //---- checking whether there are enough bars 
  if (BarCheck1(begin + 1, bar, set)) return(EMPTY_VALUE);
  
  //----+ rearrangement of cells of the array SeriesArray
  Recount_ArrayZeroPos(m_count, size, prev_calculated, series - m_series1, bar, m_dSeriesArray);
   
  //----+ Initialization of zero
  if (BarCheck2(begin, bar, set, CMO_Length + 3))
   {         
    m_UpSum = 0.0;
    m_DnSum = 0.0;
    
    for(iii = 1; iii < CMO_Length; iii++)
     {
      rrr = Recount_ArrayNumber(m_count, size, iii);      
      dseries = m_dSeriesArray[rrr];
     
      if (dseries > 0) m_UpSum += dseries;        
      if (dseries < 0) m_DnSum -= dseries;
     } 

    m_AbsCMO = 0.000000001;
   }
  else if (BarCheck3(begin, bar, set, CMO_Length + 3))
   {
    m_series1 = series;
    return(EMPTY_VALUE);
   }             

	 dseries = m_dSeriesArray[m_count];
  if (dseries > 0) m_UpSum += dseries;        
  if (dseries < 0) m_DnSum -= dseries;
  if (m_UpSum + m_DnSum > 0) 
   m_AbsCMO = MathAbs((m_UpSum - m_DnSum) / (m_UpSum + m_DnSum));
   abcmo = m_AbsCMO;                                      
  //----
  rrr = Recount_ArrayNumber(m_count, size, CMO_Length - 1);      
  dseries = m_dSeriesArray[rrr];
  if (dseries > 0) m_UpSum -= dseries;        
  if (dseries < 0) m_DnSum += dseries;
  
  //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
    m_AbsCMO = m_AbsCMO_;
    m_UpSum = m_UpSum_;
    m_DnSum = m_DnSum_;
    m_series1 = m_series1_;
   }
  else m_series1 = series;
  
  //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set))
   {
     m_AbsCMO_ = m_AbsCMO;
    m_UpSum_ = m_UpSum;
    m_DnSum_ = m_DnSum;
    m_series1_ = m_series1;
   }
//----+
  return(abcmo); 
 }
//+X================================================================X+
//|  VIDYASeries() function                                          |
//+X================================================================X+    
double CCMO::VIDYASeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int CMO_Length, // CMO period
  double EMA_Length, // EMA period
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// VIDYASeries(begin, prev_calculated, rates_total, CMO_Length, EMA_Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //----+ Declaration of local variables
  double vidya, CMO_ = CMOSeries(begin, prev_calculated, rates_total, CMO_Length, series, bar, set);
 
  //----+ Initialization of zero
  if (BarCheck2(begin, bar, set, CMO_Length + 3))
   {             	   
	   m_Vidya = series;
	   //---- Initialization of the factor of smoothing of 
    m_SmoothFactor = 2.0 / (EMA_Length + 1.0);
   }
  else if (BarCheck3(begin, bar, set, CMO_Length + 3)) return(EMPTY_VALUE);             

  //----
  CMO_ *= m_SmoothFactor;                                            
  m_Vidya = CMO_ * series + (1 - CMO_) * m_Vidya;
  vidya = m_Vidya;
  
  //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
    m_Vidya = m_Vidya_;
   }
   
  //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set))
   {
     m_Vidya_ = m_Vidya;
   } 
//----+
  return(vidya); 
 }
//+X----------------------+ <<< The End >>> +-----------------------X+