//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                             BBandsSeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMoving_Average                          |
//+X----------------------------------------------------------------X+ 
#include <MASeries_Cls.mqh> 
//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X----------------------------------------------------------------X+
// Description of the class StdDevSeries_Cls.mqh                     |
//+X----------------------------------------------------------------X+ 
#include <StdDevSeries_Cls.mqh>
//+X================================================================X+
//|  Algorithm of getting the Bollinger channel                      |
//+X================================================================X+
class CBBands
 {
public:
  double BBandsSeries(uint begin, //     
                       uint prev_calculated, // amount of history in bars at previous tick
                       uint rates_total, // amount of history in bars at the current tick
                       int Length, // period of averaging
                       double deviation, // deviation
                       ENUM_MA_METHOD MA_Method, // method of averaging
                       double series,  // value of the price series calculated for the new bar with number 'bar'
                       uint bar,  // bar number
                       bool set, // direction of indexing arrays
                       double& DnMovSeries, // value of the lower border of the channel for the current bar 
                       double& MovSeries,  // value of the middle line of the channel for the current bar 
                       double& UpMovSeries  // value of the upper border of the channel for the current bar 
                       ); 
                       
  double BBandsSeries_(uint begin, // number of beginning of bars for reliable calculation
                        uint prev_calculated, // amount of history in bars at previous tick
                        uint rates_total, // amount of history in bars at the current tick
                        int MALength, // period of moving average
                        ENUM_MA_METHOD MA_Method, // method of averaging
                        int BBLength, // period of averaging of the Bollinger channel
                        double deviation, // deviation
                        double series,  // value of the price series calculated for the new bar with number 'bar'
                        uint bar,  // bar number
                        bool set, // direction of indexing arrays
                        double& DnMovSeries, // value of the lower border of the channel for the current bar 
                        double& MovSeries,  // value of the middle line of the channel for the current bar 
                        double& UpMovSeries  // value of the upper border of the channel for the current bar 
                        ); 
  protected:
    //---- declaration of variables of the classes Moving_Average and CStdDeviation
    CStdDeviation     STD;
    CMoving_Average   MA;
 };
//+X================================================================X+
//|  Calculation of the Bollinger channel                            |
//+X================================================================X+    
double CBBands::BBandsSeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int Length, // period of averaging
  double deviation, // deviation
  ENUM_MA_METHOD MA_Method, //method of averaging
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set, // direction of indexing arrays
  double& DnMovSeries, // value of the lower border of the channel for the current bar 
  double& MovSeries, // value of the middle line of the channel for the current bar
  double& UpMovSeries // value of the upper border of the channel for the current bar
 )
// BBandsMASeries(begin, prev_calculated, rates_total, period, deviation,
          // MA_Method, Series, bar, set, DnMovSeries, MovSeries, UpMovSeries) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //----+ Calculation of the middle line
  MovSeries = MA.MASeries(begin, prev_calculated, rates_total, Length, MA_Method, series, bar, set);
  
  //----+ Calculation of the Bollinger channel
  double StdDev = STD.StdDevSeries(begin, prev_calculated, rates_total, Length, deviation, series, MovSeries, bar, set);
  DnMovSeries = MovSeries - StdDev;
  UpMovSeries = MovSeries + StdDev;
//----+
  return(StdDev); 
 }
//+X================================================================X+
//|  Calculation of the Bollinger channel                            |
//+X================================================================X+    
double CBBands::BBandsSeries_
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int MALength, // period of moving average
  ENUM_MA_METHOD MA_Method, //method of averaging
  int BBLength, // period of averaging of the Bollinger channel
  double deviation, // deviation
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set, // direction of indexing arrays
  double& DnMovSeries, // value of the lower border of the channel for the current bar 
  double& MovSeries, // value of the middle line of the channel for the current bar
  double& UpMovSeries // value of the upper border of the channel for the current bar
 )
// BBandsMASeries_(begin, prev_calculated, rates_total, MALength, MA_Method,
      // deviation, BBLength, Series, bar, set, DnMovSeries, MovSeries, UpMovSeries) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //----+ Calculation of the middle line
  MovSeries = MA.MASeries(begin, prev_calculated, rates_total, MALength, MA_Method, series, bar, set);
  
  //----+ Calculation of the Bollinger channel
  double StdDev = STD.StdDevSeries(begin+MALength+1, prev_calculated, rates_total, BBLength, deviation, series, MovSeries, bar, set);
  DnMovSeries = MovSeries - StdDev;
  UpMovSeries = MovSeries + StdDev;
//----+
  return(StdDev); 
 }
//+X----------------------+ <<< The End >>> +-----------------------X+