//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                                AMASeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| The algorithm of getting the AMA indicator calculated            |
//| on the basis of optional price series                            |
//+X================================================================X+
class CAMA : public CMovSeriesTools
 {
  public:
    double AMASeries(uint begin, // number of beginning of bars for reliable calculation
                      uint prev_calculated, // amount of history in bars at previous tick
                      uint rates_total, // amount of history in bars at the current tick
                      int Length, // period of AMA
                      int Fast_Length, // period of fast moving average
                      int Slow_Length, // period of slow moving average
                      double Rate, // rate of the smoothing constant
                      double series,  // value of the price series calculated for the new bar with number 'bar'
                      uint bar,  // bar number
                      bool set // direction of indexing arrays
                     );
  protected:
//----+  
  double   m_SeriesArray[];
  double   m_dSeriesArray[];
  double   m_NOISE,  m_noise;
  double   m_Ama,  m_AMA_,  m_slowSC,  m_fastSC,  m_dSC;
  int      m_Size_1,  m_Size_2,  m_count;
 };
//+X================================================================X+
//|  AMASeries() function                                            |
//+X================================================================X+    
double CAMA::AMASeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int Length, // period of AMA
  int Fast_Length, // period of fast moving average
  int Slow_Length, // period of slow moving average
  double Rate, // rate of the smoothing constant
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// AMASeries(symbol, timeframe, begin, limit, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables
  double signal, ER, ERSC, SSC, price, dprice, ama;
  int iii, kkk, rrr, size = Length + 1;
  
  //----+ Changing size of arrays of variables
  if (bar == begin)
   if (!SeriesArrayResize(__FUNCTION__, size, m_SeriesArray,  m_Size_1)    
    || !SeriesArrayResize(__FUNCTION__, size, m_dSeriesArray,  m_Size_2))
     return(EMPTY_VALUE);
  
  //----+ checking for correctness the external parameter Length
  LengthCheck(Length);
  
  //----+ rearrangement of cells of the array m_SeriesArray
  Recount_ArrayZeroPos( m_count, size, prev_calculated, series, bar, m_SeriesArray);
 
  //---- checking whether there are enough bars 
  if (BarCheck1(begin + 1, bar, set)) return(EMPTY_VALUE);
  
  kkk = Recount_ArrayNumber( m_count, size, 1);
  dprice = series - m_SeriesArray[kkk];
  m_dSeriesArray[ m_count] = dprice;
  
  //----+ Initialization of zero
  if (BarCheck2(begin, bar, set, Length + 3))
   {
    //---- initialization of constants
    rrr = Recount_ArrayNumber( m_count, size, 1); 
     m_Ama = m_SeriesArray[rrr];
     m_slowSC = (2.0 / (Slow_Length + 1));
     m_fastSC = (2.0 / (Fast_Length + 1)); 
     m_dSC =  m_fastSC -  m_slowSC; 
     m_noise = 0.000000001;
 
    for(iii = 1; iii < Length; iii++)
     {
      rrr = Recount_ArrayNumber( m_count, size, iii);      
       m_noise += MathAbs(m_dSeriesArray[rrr]);
     }
   }
  else if (BarCheck3(begin, bar, set, Length + 3)) return(EMPTY_VALUE);             

  //----
   m_noise += MathAbs(dprice);
  rrr = Recount_ArrayNumber( m_count, size, Length); 
  signal = MathAbs(series - m_SeriesArray[rrr]);    
  //----                     
  ER = signal /  m_noise;
  ERSC = ER *  m_dSC;
  SSC = ERSC +  m_slowSC;
   m_Ama =  m_Ama + (MathPow(SSC, Rate) * (series -  m_Ama));
  ama =  m_Ama;
  kkk = Recount_ArrayNumber( m_count, size, Length - 1);      
   m_noise -= MathAbs(m_dSeriesArray[kkk]);
   
  //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
     m_noise =  m_NOISE;
     m_Ama =  m_AMA_;
   }
   
  //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set))
   {
     m_AMA_ =  m_Ama;
     m_NOISE =  m_noise;
   }
//----+
  return(ama); 
 }
//+X----------------------+ <<< The End >>> +-----------------------X+