//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                                 MASeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh> 
//+X================================================================X+
//|  The function for the classic averaging of price series          |
//+X================================================================X+
class CMoving_Average : public CMovSeriesTools
  {
public:  
   double    MASeries  (uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         int Length,// period of averaging
                         ENUM_MA_METHOD MA_Method,// method of averaging (MODE_SMA, MODE_EMA, MODE_SMMA, MODE_LWMA)
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );

   double    SMASeries (uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         int Length,// period of averaging
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );
                        
   double    EMASeries (uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         double Length,// period of averaging
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );
                        
   double    SMMASeries(uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         int Length,// period of averaging
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );

   double    LWMASeries(uint begin,// number of beginning of bars for reliable calculation
                         uint prev_calculated,// amount of history in bars at the previous tick
                         uint rates_total,// amount of history in bars at the current tick
                         int Length,// period of averaging
                         double series,// value of the price series calculated for the new bar with number 'bar'
                         uint bar,// bar number
                         bool set // direction of indexing arrays
                        );

protected:
   double            m_SeriesArray[];
   int               m_Size_, m_count, m_weight;
   double            m_Moving, m_MOVING, m_Pr;
   double            m_sum, m_SUM, m_lsum, m_LSUM;
  };
//+X================================================================X+
//|  The classic algorithms of averaging                             |
//+X================================================================X+    
double CMoving_Average::MASeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 ENUM_MA_METHOD MA_Method,// method of averaging (MODE_SMA, MODE_EMA, MODE_SMMA, MODE_LWMA)
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// MASeries(begin, prev_calculated, Length, MA_Method, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----+   
   switch(MA_Method)
     {
      case MODE_SMA:  return(SMASeries (begin, prev_calculated, rates_total, Length, series, bar, set));
      case MODE_EMA:  return(EMASeries (begin, prev_calculated, rates_total, Length, series, bar, set));
      case MODE_SMMA: return(SMMASeries(begin, prev_calculated, rates_total, Length, series, bar, set));
      case MODE_LWMA: return(LWMASeries(begin, prev_calculated, rates_total, Length, series, bar, set));
      default:
        {
         if(bar==begin)
           {
            string word;
            StringConcatenate(word,__FUNCTION__,"():",
                              " The parameter MA_Method must be withing the range from MODE_SMA to MODE_LWMA.",
                              " You specified unacceptable value ",MA_Method," value MODE_SMA will be used!");
            Print(word);
           }
         return(SMASeries(begin,prev_calculated,rates_total,Length,series,bar,set));
        }
     }
//----+
  }
//+X================================================================X+
//|  Simple averaging                                                |
//+X================================================================X+    
double CMoving_Average::SMASeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// SMASeries(begin, prev_calculated, rates_total, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  { 
//----+  Checking the beginning of bars for reliable calculation 
   if(BarCheck1(begin,bar,set)) return(EMPTY_VALUE);

//----+ Declaration of local variables
   int iii,kkk;
   double sma;
   
//----+ checking for correctness the external parameter Length
   LengthCheck(Length);	

//----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__,Length,m_SeriesArray,m_Size_))
      return(EMPTY_VALUE);

//----+ rearrangement of cells of the array m_SeriesArray
   Recount_ArrayZeroPos(m_count,Length,prev_calculated,series,bar,m_SeriesArray);

//----+ Initialization of zero
   if(BarCheck2(begin,bar,set,Length))
     {
      m_sum=0.0;

      for(iii=1; iii<Length; iii++)
        {
         kkk = Recount_ArrayNumber(m_count,Length,iii);
         m_sum+= m_SeriesArray[kkk];
        }
     }
   else if(BarCheck3(begin,bar,set,Length)) return(EMPTY_VALUE);

//----+  SMA
   m_sum+= series;
   sma = m_sum / Length;
   kkk = Recount_ArrayNumber(m_count, Length, Length - 1);
   m_sum-=m_SeriesArray[kkk];

//----+ saving values of variables
   if(BarCheck4(rates_total,bar,set))
     {
      m_SUM=m_sum;
     }

//----+ restoring values of variables
   if(BarCheck5(rates_total,bar,set))
     {
      m_sum=m_SUM;
     }
//----+
   return(sma);
  }
//+X================================================================X+
//|  Exponential averaging                                           |
//+X================================================================X+    
double CMoving_Average::EMASeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 double Length, // period of averaging
 double series, // value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// EMASeries(begin, prev_calculated, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----+  Checking the beginning of bars for reliable calculation 
   if(BarCheck1(begin,bar,set)) return(EMPTY_VALUE);

//----+ Declaration of local variables
   double ema;
   
//----+ checking for correctness the external parameter Length
   LengthCheck(Length);	

//----+ Initialization of zero
   if(bar==begin)
     {
      m_Pr=2.0/(Length+1.0);
      m_Moving=series;
     }

//----+  EMA 
   m_Moving=series*m_Pr+m_Moving *(1-m_Pr);
   ema=m_Moving;

//----+ saving values of variables
   if(BarCheck4(rates_total,bar,set))
     {
      m_MOVING=m_Moving;
     }

//----+ restoring values of variables
   if(BarCheck5(rates_total,bar,set))
     {
      m_Moving=m_MOVING;
     }
//----+
   return(ema);
  }
//+X================================================================X+
//|  Smoothed averaging                                              |
//+X================================================================X+
double CMoving_Average::SMMASeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// SMMASeries(begin, prev_calculated, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----+  Checking the beginning of bars for reliable calculation 
   if(BarCheck1(begin,bar,set)) return(EMPTY_VALUE);
   
//----+ Declaration of local variables
   int iii,kkk;
   double smma;
   
//----+ checking for correctness the external parameter Length
   LengthCheck(Length);	

//----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__,Length,m_SeriesArray,m_Size_))
      return(EMPTY_VALUE);
      
//----+ rearrangement of cells of the array m_SeriesArray
   Recount_ArrayZeroPos(m_count,Length,prev_calculated,series,bar,m_SeriesArray);

//----+ Initialization of zero
   if(BarCheck2(begin,bar,set,Length))
     {
      m_sum=0.0;
      for(iii=0; iii<Length; iii++)
        {
         kkk = Recount_ArrayNumber(m_count,Length,iii);
         m_sum+= m_SeriesArray[kkk];
        }

      m_Moving=(m_sum-series)/(Length-1);
     }
   else if(BarCheck3(begin,bar,set,Length)) return(EMPTY_VALUE);

//----+ Calculation of SMMA
   m_sum=m_Moving *(Length-1)+series;
   m_Moving=m_sum/Length;
   smma=m_Moving;

//----+ saving values of variables
   if(BarCheck4(rates_total,bar,set))
     {
      m_SUM=m_sum;
      m_MOVING=m_Moving;
     }

//----+ restoring values of variables
   if(BarCheck5(rates_total,bar,set))
     {
      m_sum=m_SUM;
      m_Moving=m_MOVING;
     }
//----+
   return(smma);
  }
//+X================================================================X+
//|  Linear weighted averaging                                       |
//+X================================================================X+
double CMoving_Average::LWMASeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// LWMASeries(begin, prev_calculated, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----+  Checking the beginning of bars for reliable calculation 
   if(BarCheck1(begin,bar,set)) return(EMPTY_VALUE);
   
//----+ Declaration of local variables
   double lwma;
   int iii,kkk,Length_=Length+1;
   
//----+ checking for correctness the external parameter Length
   LengthCheck(Length);	

//----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__,Length_,m_SeriesArray,m_Size_))
      return(EMPTY_VALUE);

//----+ rearrangement of cells of the array m_SeriesArray
   Recount_ArrayZeroPos(m_count,Length_,prev_calculated,series,bar,m_SeriesArray);

//----+ Initialization of zero
   if(BarCheck2(begin,bar,set,Length_))
     {
      m_sum=0.0;
      m_lsum=0.0;
      m_weight=0;
      int rrr=Length;

      for(iii=1; iii<=Length; iii++,rrr--)
        {
         kkk = Recount_ArrayNumber(m_count,Length_,iii);
         m_sum+= m_SeriesArray[kkk] * rrr;
         m_lsum+=m_SeriesArray[kkk];
         m_weight+=iii;
        }
     }
   else if(BarCheck3(begin,bar,set,Length_)) return(EMPTY_VALUE);

//----+  LWMA
   m_sum+= series * Length - m_lsum;
   kkk = Recount_ArrayNumber(m_count,Length_,Length);
   m_lsum+= series - m_SeriesArray[kkk];
   lwma = m_sum / m_weight;

//----+ saving values of variables
   if(BarCheck4(rates_total,bar,set))
     {
      m_SUM  = m_sum;
      m_LSUM = m_lsum;
     }

//----+ restoring values of variables
   if(BarCheck5(rates_total,bar,set))
     {
      m_sum=m_SUM;
      m_lsum=m_LSUM;
     }
//----+
   return(lwma);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
