//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                         IndicatorsAlgorithms.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Declaration of classes of averaging                               |
//+X----------------------------------------------------------------X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+
//|  Linear regression averaging of price series                     |
//+X================================================================X+
class CLRMA  
 {
public:   
  double LRMASeries(uint begin,// number of beginning of bars for reliable calculation
                     uint prev_calculated,// amount of history in bars at the previous tick
                     uint rates_total,// amount of history in bars at the current tick
                     int Length,// period of averaging
                     double series,// value of the price series calculated for the new bar with number 'bar'
                     uint bar,// bar number
                     bool set // direction of indexing arrays
                     )
  {
//----+
   //---- Declaration of local variables
   double sma, lwma, lrma;  
  
   //---- declaration of variables of the class Moving_Average from the file MASeries_Cls.mqh
  // CMoving_Average SMA, LWMA;
  
   //---- Getting values of moving averages  
   sma = m_SMA.SMASeries(begin, prev_calculated, rates_total, Length, series, bar, set);
   lwma = m_LWMA.LWMASeries(begin, prev_calculated, rates_total, Length, series, bar, set);
 
   //---- Calculation of LRMA
   lrma = 3.0 * lwma - 2.0 * sma;
//----+
   return(lrma); 
  };

protected:
 //---- declaration of variables of the class Moving_Average
 CMoving_Average m_SMA, m_LWMA;  
 };
//+X================================================================X+
//|  The algorithm of getting the Bollinger channel                  |
//|  calculated from VIDYA                                           |
//+X================================================================X+
class CVidyaBands
 {
public:
  double VidyaBandsSeries(uint begin, // number of beginning of bars for reliable calculation
                           uint prev_calculated, // amount of history in bars at previous tick
                           uint rates_total, // amount of history in bars at the current tick
                           int CMO_period, // Period of averaging of the oscillator CMO
                           double EMA_period, // period of averaging of EMA
                           int BBLength, // period of averaging of the Bollinger channel
                           double deviation, // deviation
                           double series,  // value of the price series calculated for the new bar with number 'bar'
                           uint bar,  // bar number
                           bool set, // direction of indexing arrays
                           double& DnMovSeries, // value of the lower border of the channel for the current bar 
                           double& MovSeries,  // value of the middle line of the channel for the current bar 
                           double& UpMovSeries  // value of the upper border of the channel for the current bar 
                          ) 
   {
//----+
    //----+ Calculation of the middle line    
    MovSeries = m_VIDYA.VIDYASeries(begin, prev_calculated, rates_total, CMO_period, EMA_period, series, bar, set);
  
    //----+ Calculation of the Bollinger channel
    double StdDev = m_STD.StdDevSeries(begin+CMO_period+1, prev_calculated, rates_total, BBLength, deviation, series, MovSeries, bar, set);
    DnMovSeries = MovSeries - StdDev;
    UpMovSeries = MovSeries + StdDev;
//----+
    return(StdDev); 
   }
 
  protected:
    //---- declaration of variables of the classes CCMO and CStdDeviation
    CCMO           m_VIDYA;
    CStdDeviation  m_STD;
 };
//+X================================================================X+
//|  Algorithm of getting the Bollinger channel                      |
//+X================================================================X+
class CBBands
 {
public:
  double BBandsSeries(uint begin, // number of beginning of bars for reliable calculation
                       uint prev_calculated, // amount of history in bars at previous tick
                       uint rates_total, // amount of history in bars at the current tick
                       int Length, // period of averaging
                       double deviation, // deviation
                       ENUM_MA_METHOD MA_Method, // method of averaging
                       double series,  // value of the price series calculated for the new bar with number 'bar'
                       uint bar,  // bar number
                       bool set, // direction of indexing arrays
                       double& DnMovSeries, // value of the lower border of the channel for the current bar 
                       double& MovSeries,  // value of the middle line of the channel for the current bar 
                       double& UpMovSeries  // value of the upper border of the channel for the current bar 
                       ); 
                       
  double BBandsSeries_(uint begin, // number of beginning of bars for reliable calculation
                        uint prev_calculated, // amount of history in bars at previous tick
                        uint rates_total, // amount of history in bars at the current tick
                        int MALength, // period of moving average
                        ENUM_MA_METHOD MA_Method, // method of averaging
                        int BBLength, // period of averaging of the Bollinger channel
                        double deviation, // deviation
                        double series,  // value of the price series calculated for the new bar with number 'bar'
                        uint bar,  // bar number
                        bool set, // direction of indexing arrays
                        double& DnMovSeries, // value of the lower border of the channel for the current bar 
                        double& MovSeries,  // value of the middle line of the channel for the current bar 
                        double& UpMovSeries  // value of the upper border of the channel for the current bar 
                        ); 
  protected:
    //---- declaration of variables of the classes Moving_Average and CStdDeviation
    CStdDeviation     m_STD;
    CMoving_Average   m_MA;
 };
//+X================================================================X+
//|  Calculation of the Bollinger channel                            |
//+X================================================================X+    
double CBBands::BBandsSeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int Length, // period of averaging
  double deviation, // deviation
  ENUM_MA_METHOD MA_Method, //method of averaging
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set, // direction of indexing arrays
  double& DnMovSeries, // value of the lower border of the channel for the current bar 
  double& MovSeries, // value of the middle line of the channel for the current bar
  double& UpMovSeries // value of the upper border of the channel for the current bar
 )
// BBandsMASeries(begin, prev_calculated, rates_total, period, deviation,
          // MA_Method, Series, bar, set, DnMovSeries, MovSeries, UpMovSeries) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //----+ Calculation of the middle line
  MovSeries = m_MA.MASeries(begin, prev_calculated, rates_total, Length, MA_Method, series, bar, set);
  
  //----+ Calculation of the Bollinger channel
  double StdDev = m_STD.StdDevSeries(begin, prev_calculated, rates_total, Length, deviation, series, MovSeries, bar, set);
  DnMovSeries = MovSeries - StdDev;
  UpMovSeries = MovSeries + StdDev;
//----+
  return(StdDev); 
 }
//+X================================================================X+
//|  Calculation of the Bollinger channel                            |
//+X================================================================X+    
double CBBands::BBandsSeries_
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int MALength, // period of moving average
  ENUM_MA_METHOD MA_Method, //method of averaging
  int BBLength, // period of averaging of the Bollinger channel
  double deviation, // deviation
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set, // direction of indexing arrays
  double& DnMovSeries, // value of the lower border of the channel for the current bar 
  double& MovSeries, // value of the middle line of the channel for the current bar
  double& UpMovSeries // value of the upper border of the channel for the current bar
 )
// BBandsMASeries_(begin, prev_calculated, rates_total, MALength, MA_Method,
      // deviation, BBLength, Series, bar, set, DnMovSeries, MovSeries, UpMovSeries) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //----+ Calculation of the middle line
  MovSeries = m_MA.MASeries(begin, prev_calculated, rates_total, MALength, MA_Method, series, bar, set);
  
  //----+ Calculation of the Bollinger channel
  double StdDev = m_STD.StdDevSeries(begin+MALength+1, prev_calculated, rates_total, BBLength, deviation, series, MovSeries, bar, set);
  DnMovSeries = MovSeries - StdDev;
  UpMovSeries = MovSeries + StdDev;
//----+
  return(StdDev); 
 }
//+X----------------------+ <<< The End >>> +-----------------------X+