/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+
//|                                                        VIDYA.mq5 |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
//---- author of the indicator
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- Drawing the indicator in the main window
#property indicator_chart_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- golden color is used as the color of the indicator line
#property indicator_color1  Gold
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "VIDYA"

//+----------------------------------------------+
//| Input parameters of the indicator            |
//+----------------------------------------------+
input int CMO_period = 9; // period of VIDYA
input double EMA_period = 12; // period of EMA
input int VIDYAShift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // vertical shift of the indicator in points
//+----------------------------------------------+
//---- declaration of a dynamic array that further 
                // will be used an indicator buffer
double ExtLineBuffer[]; 

double dPriceShift;
//+X================================================================X+
// Description of the class CCMO                                     |
//+X================================================================X+   
#include <SmoothAlgorithms.mqh>  
//+X================================================================X+
//| Custom indicator initialization function                         |
//+X================================================================X+  
void OnInit()
  {
//----+
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- shifting the indicator horizontally by VIDYAShift
   PlotIndexSetInteger(0, PLOT_SHIFT, VIDYAShift);
   //---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CMO_period);
   //---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname, "VIDYA(", CMO_period, ")");
   //--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0, PLOT_LABEL, shortname);   
   //--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME, shortname);
   //--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
   //--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   //---- initialization of the vertical shift
   dPriceShift = _Point * PriceShift;
//----+
  }
//+X================================================================X+
//| Custom indicator iteration function                              |
//+X================================================================X+
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const int begin,          // number of beginning of reliable counting of bars
                const double &price[]     // price array for calculation of the indicator
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < CMO_period + 1 + begin)
    return(0);
   
   //---- declaration of local variables 
   int first, bar; 

   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    { 
     first = 0 + begin; // starting number for calculation of all bars
     //--- increase the position of the beginning of data by 'begin' bars as a result of calculation using data of another indicator
     if(begin > 0) PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CMO_period + 2 + begin);
    }
   else 
    {
     first = prev_calculated - 1; // starting number for calculation of new bars
    }

   //---- declaration of variable of the class VIDYA
   static CCMO VIDYA1;

   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
     ExtLineBuffer[bar] = VIDYA1.VIDYASeries(begin, prev_calculated, rates_total, CMO_period,
                                                     EMA_period, price[bar], bar, false) + dPriceShift;
//----+     
   return(rates_total);
  }
//+------------------------------------------------------------------+
