/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+
//|                                                     T3Taotra.mq5 |
//|                   MQL5 jjrsx: Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+  
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window
//---- number of indicator buffers
#property indicator_buffers 6 
//---- 6 plots are used 
#property indicator_plots   6
//---- color of the indicator
#property indicator_color1 Yellow
#property indicator_color2 Red
#property indicator_color3 Magenta
#property indicator_color4 Aqua
#property indicator_color5 LimeGreen
#property indicator_color6 Blue
//---- drawing the indicator in the form of lines
#property indicator_type1 DRAW_LINE
#property indicator_type2 DRAW_LINE
#property indicator_type3 DRAW_LINE
#property indicator_type4 DRAW_LINE
#property indicator_type5 DRAW_LINE
#property indicator_type6 DRAW_LINE
//---- lines of the indicator - continuous curves
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
#property indicator_style6 STYLE_SOLID
//---- width of the indicator lines is equal to 1
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 1
#property indicator_width6 1
//---- displaying labels of the indicator
#property indicator_label1  "T3Taotra" 
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of price constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL
  PRICE_QUARTER_,       //PRICE_QUARTER
  PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0
  PRICE_TRENDFOLLOW1_   //PRICE_TRENDFOLLOW1
 };
input int T3_Period_1 = 3; // period of the indicator 1
input int T3_Period_2 = 5; // period of the indicator 2
input int T3_Period_3 = 8; // period of the indicator 3
input int T3_Period_4 = 12;// period of the indicator 4
input int T3_Period_5 = 21;// period of the indicator 5
input int T3_Period_6 = 34;// period of the indicator 6
input int Smooth_Curvature = 100;
input  Applied_price_  IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift1 = 0;  // c  1    
input int Shift2 = 0;  // c  2   
input int Shift3 = 0;  // c  3   
input int Shift4 = 0;  // c  6   
input int Shift5 = 0;  // c  5   
input int Shift6 = 0;  // c  6   
//+-----------------------------------+
//---- indicator buffers
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
double Ind_Buffer5[];
double Ind_Buffer6[];
//+X================================================================X+
// Description of the function iPriceSeries()                        |
// Description of the function iPriceSeriesAlert()                   |
// Description of the class CT3                                      |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+   
//| T3Taotra initialization function                                 |
//+X================================================================X+ 
void OnInit()
 {
//----+
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, Ind_Buffer1, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift1);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(1, Ind_Buffer2, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(1, PLOT_SHIFT, Shift2);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(2, Ind_Buffer3, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(2, PLOT_SHIFT, Shift3);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(3, Ind_Buffer4, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(3, PLOT_SHIFT, Shift4);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(3, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(4, Ind_Buffer5, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(4, PLOT_SHIFT, Shift5);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(4, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(4, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(5, Ind_Buffer6, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(5, PLOT_SHIFT, Shift6);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(5, PLOT_DRAW_BEGIN, 0);
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(5, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate
    (shortname, "T3Taotra( ", T3_Period_1, ", ", T3_Period_2, ", ", T3_Period_3,
                    ", ", T3_Period_4, ", ", T3_Period_5, ", ", T3_Period_6, " )");  
  //---- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //---- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CT3 from the file T3Series_Cls.mqh
  CT3 T3_;
  //---- setting up alerts for unacceptable values of external variables
  T3_.MALengthCheck("T3_Period_1", T3_Period_1);
  T3_.MALengthCheck("T3_Period_2", T3_Period_2);
  T3_.MALengthCheck("T3_Period_3", T3_Period_3);
  T3_.MALengthCheck("T3_Period_4", T3_Period_4);
  T3_.MALengthCheck("T3_Period_5", T3_Period_5);
  T3_.MALengthCheck("T3_Period_6", T3_Period_6);
//----+ end of initialization
 }
//+X================================================================X+
//| T3.Taotra iteration function                                     |
//+X================================================================X+
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
 {
//----+
  //---- Checking if there is enough bars for the calculation
  if (rates_total < 0)return(0);
  
  //---- declaration of variables with a floating point
  double series;
  
  //---- Declaration of integer variables
  int first, bar;

  if (prev_calculated == 0) // checking for the first start of the indicator calculation
       first = 0; // start number for calculation of all bars
  else first = prev_calculated - 1; // starting number for calculation of new bars
	 
	 //---- declaration of array of variables of the class CT3 from the file T3Series_Cls.mqh
  static CT3 T3_[6];
	 
  //----+ Main cycle of the indicator calculation
  for(bar = first; bar < rates_total; bar++)
   {
    //----+ Call of the PriceSeries function to get the input price 'Series'
    series = PriceSeries(IPC, bar, open, low, high, close);
    
    //----+ Six parallel calls of the function T3Series.
             // The parameter Length is not changed at every bar (Din = 0).  
    Ind_Buffer1[bar] = T3_[0].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_1, series,  bar, false);
    Ind_Buffer2[bar] = T3_[1].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_2, series,  bar, false);
    Ind_Buffer3[bar] = T3_[2].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_3, series,  bar, false);
    Ind_Buffer4[bar] = T3_[3].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_4, series,  bar, false);
    Ind_Buffer5[bar] = T3_[4].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_5, series,  bar, false);
    Ind_Buffer6[bar] = T3_[5].T3Series(0, prev_calculated, rates_total, 0, Smooth_Curvature, T3_Period_6, series,  bar, false);
   }
//----+ End of calculation of values of the indicator 
  return(rates_total);
 }
//+X----------------------+ <<< The End >>> +-----------------------X+

