/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                           T3.mq4 | 
//|                           Copyright  2010,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing the indicator 1 as a line
#property indicator_type1   DRAW_LINE
//---- pink color is used for indicator line
#property indicator_color1 Red
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "T3"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of price constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL
  PRICE_QUARTER_,       //PRICE_QUARTER
  PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0
  PRICE_TRENDFOLLOW1_   //PRICE_TRENDFOLLOW1
 };
//---- input parameters of the indicator
input int T3Period = 14; // period of the T3 moving average
input double b = 70; // coefficient x100
input  Applied_price_  IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int T3Shift = 0; // horizontal shift of moving average in bars
input int PriceShift = 0; // shifting the ma vertically in points
//+-----------------------------------+
//---- indicator buffers
double Ind_Buffer[];
//----
double dPriceShift;
//+X================================================================X+
// Description of the function iPriceSeries()                        |
// Description of the function iPriceSeriesAlert()                   |
// Description of the class CT3                                      |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+
//| T3 indicator initialization function                             | 
//+X================================================================X+   
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, Ind_Buffer, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, T3Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 0);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "T3");
  //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "T3( T3Period = ", T3Period, ", b = ", b, ")");  
  //---- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //---- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CT3 from the file T3Series_Cls.mqh
  CT3 T3_;
  //---- setting up alerts for unacceptable values of external variables
  T3_.MALengthCheck("T3Period", T3Period);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
//----+ end of initialization
 }
//+X================================================================X+
//| T3 iteration function                                            | 
//+X================================================================X+ 
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
 {
//----+   
  //---- Checking if there is enough bars for the calculation
  if (rates_total < 0)return(0);

  //---- Declaration of integer variables
  int first, bar;
  
  //---- declaration of variables with a floating point  
  double series, t3;
   
  if (prev_calculated == 0) // checking for the first start of the indicator calculation
       first = 0; // start number for calculation of all bars
  else first = prev_calculated - 1; // starting number for calculation of new bars
      
  //---- declaration of variable of the class T3 from the file T3Series_Cls.mqh
  static CT3 T3_;
   
  //---- Main cycle of calculation of the indicator
  for(bar = first; bar < rates_total; bar++)
   {
    //----+ Call of the PriceSeries function to get the input price 'Series'
    series = PriceSeries(IPC, bar, open, low, high, close);
    
    //----+ One call of the function T3Series 
             // The parameter Length is not changed at every bar (Din = 0).  
    t3 = T3_.T3Series(0, prev_calculated, rates_total, 0, b, T3Period, series, bar, false);

    //---- Initialization of a cell of the indicator buffer with the obtained value       
    Ind_Buffer[bar] = t3 + dPriceShift;
   }
//----+     
  return(rates_total);
 }
//+X----------------------+ <<< The End >>> +-----------------------X+
