/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                         MAx2.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- salmon color is used as the color of the indicator line
#property indicator_color1 Salmon
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying the bullish indicator
#property indicator_label1  "MAx2"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
input int Length1 = 12; //depth of the first smoothing
input ENUM_MA_METHOD MA_Method1 = MODE_SMA; //method of averaging of the first smoothing
input int Length2 = 3; //depth of the second smoothing 
input ENUM_MA_METHOD MA_Method2 = MODE_LWMA; //method of averaging of the second smoothing                   
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // shifting the ma vertically in points
//+-----------------------------------+
//---- indicator buffer
double MAx2[];

int start = 0;
double dPriceShift;
//+X================================================================X+
// Description of the class Moving_Average                           |
//+X================================================================X+  
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+    
//| _2MA indicator initialization function                           | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, MAx2, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  if (MA_Method1 != MODE_EMA) start = Length1 - 1;
  if (MA_Method2 != MODE_EMA) start  += Length2;
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
  //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "MAx2"); 
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "MAx2( Length1 = ", Length1, ", Length2 = ", Length2, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
//----+ end of initialization
 }
//+X================================================================X+  
//| _2MA iteration function                                          | 
//+X================================================================X+  
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+
   start += begin;   
   //---- Checking if there is enough bars for the calculation
   if (rates_total < start) return(0);

   //---- Declaration of integer variables
   int first, bar;
   //---- declaration of variables with a floating point  
   double ma1, ma2;
   //---- Declaration of static variables
   static int start1, start2;
   
   //---- Initialization of the indicator in the OnCalculate() block
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    {
     first = begin; // starting number for calculation of all bars
     
     //---- Initialization of variables of the start of data calculation
     start1 = begin;
     if (MA_Method2 != MODE_EMA) 
          start2 = Length1 + begin;
     else start2 = begin;
     
     //--- increase the position of the start of data by 'begin' bars
           // as a result of calculation on the basis of data of another indicator
     if(begin > 0) PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
    }
   else first = prev_calculated - 1; // starting number for calculation of new bars
     
   //---- declaration of variables of the class Moving_Average from the file MASeries_Cls.mqh
   static CMoving_Average MA1, MA2;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Two calls of the function MASeries.  
     ma1 = MA1.MASeries(start1, prev_calculated, rates_total, Length1, MA_Method1, price[bar], bar, false);
     ma2 = MA2.MASeries(start2, prev_calculated, rates_total, Length2, MA_Method2, ma1,        bar, false);
     //----       
     MAx2[bar] = ma2 + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
