/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                        JMACD.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window 
//---- number of indicator buffers
#property indicator_buffers 2 
//---- only one plot is used
#property indicator_plots   2
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing the indicator as a histogram
#property indicator_type1 DRAW_HISTOGRAM
//---- indigo color is used as the color of the diagrams of the MACD indicator
#property indicator_color1 BlueViolet
//---- the indicator line is a continuous line
#property indicator_style1 STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1 2
//---- displaying labels of the indicator
#property indicator_label1 "JMACD"

//---- drawing of the indicator as a line
#property indicator_type2 DRAW_LINE
//---- pink color is used as the color of the signal line
#property indicator_color2 Magenta
//---- the indicator line is a dash-dotted curve
#property indicator_style2 STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width2 2
//---- displaying label of the signal line
#property indicator_label2  "Signal Line"

//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int Fast_JMA = 12; //period of the fast MA
input int Slow_JMA = 26; //depth of the SMMA smoothing
input int Signal_JMA = 9; //period of the signal line 
input int Phase  = 100; // parameter of smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input Applied_price_ AppliedPrice = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */           
//+-----------------------------------+
//---- indicator buffer
double MACDBuffer[], SignBuffer[];

int start = 60, macd_start = 30;
//+X================================================================X+
// Description of the function iPriceSeries                          |
// Description of the class CJJMA                                    |
//+X================================================================X+  
#include <SmoothAlgorithms.mqh>  
//+X================================================================X+    
//| JMACD indicator initialization function                          | 
//+X================================================================X+  
void OnInit()
 {
//----+    
  //---- transformation of the dynamic array MACDBuffer into an indicator buffer
  SetIndexBuffer(0, MACDBuffer, INDICATOR_DATA);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, macd_start + 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "JMACD");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- transformation of the dynamic array SignBuffer into an indicator buffer
  SetIndexBuffer(1, SignBuffer, INDICATOR_DATA);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, start + 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(1, PLOT_LABEL, "Signal JMA");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "JMACD( ", Fast_JMA, ", ", Slow_JMA, ", ", Signal_JMA, " )");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
  CJJMA JMA;
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMALengthCheck("Fast_JMA", Fast_JMA);
  JMA.JJMALengthCheck("Slow_JMA", Slow_JMA);
  JMA.JJMALengthCheck("Slow_JMA", Signal_JMA);
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMAPhaseCheck("Phase", Phase);
//----+ end of initialization
 }
//+X================================================================X+  
//| MACD iteration function                                          | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
  {
//----+   
   //----+ Check if number of bars is sufficient for calculation
   if (rates_total < start) return(0);

   //---- Declaration of integer variables
   int first, bar;
   //---- declaration of variables with a floating point  
   double price_, fast_jma, slow_jma, jmacd, sign_jma;
   
   
   //----+ Initialization of the indicator in the OnCalculate() block
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    {
     first = 0; // start number for calculation of all bars
     
     //---- Initialization of the indicator buffers at bars that are not calculated
     for(bar = 0; bar <= macd_start; bar++) MACDBuffer[bar] = 0.0;
     for(bar = 0; bar <= start;      bar++) SignBuffer[bar] = 0.0;
    }
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
     
   //---- declaration of variables of the class JJMA from the file JJMASeries_Cls.mqh
   static CJJMA JMA1, JMA2, JMA3;
   
   //----+ Main cycle of the indicator calculation
   for(bar = first; bar < rates_total; bar++)
    {
     price_ = PriceSeries(AppliedPrice, bar, open, low, high, close);;
     
     fast_jma = JMA1.JJMASeries(0, prev_calculated, rates_total, 0, Phase, Fast_JMA, price_, bar, false);
     slow_jma = JMA2.JJMASeries(0, prev_calculated, rates_total, 0, Phase, Slow_JMA, price_, bar, false);
     
     jmacd = fast_jma - slow_jma;
  
     sign_jma = JMA3.JJMASeries(macd_start, prev_calculated, rates_total, 0, Phase, Signal_JMA, jmacd, bar, false);
     
     //---- Loading the obtained values in the indicator buffers      
     MACDBuffer[bar] = jmacd;
     SignBuffer[bar] = sign_jma;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
