/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                        JJRSX.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- indigo color is used as the color of the indicator line
#property indicator_color1 BlueViolet
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "JJRSX"
//---- parameters of horizontal levels of the indicator
#property indicator_level1  0.5
#property indicator_level2 -0.5
#property indicator_level3  0.0
#property indicator_levelcolor Magenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int Length = 8; // depth of smoothing 
input int Smooth = 8;  //depth of the JJMA averaging 
input int Phase = 100; //parameter of the JJMA averaging,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input Applied_price_ IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
//---+
//---- indicator buffers
double JJRSX[];
//+X================================================================X+
// Description of the function iPriceSeries                          |
// Description of the class CJurX                                    |
// Description of the class CJJMA                                    |
//+X================================================================X+  
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+    
//| JJRSX indicator initialization function                          | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, JJRSX, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 32);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "JJRSX");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "JJRSX( Length = ", Length,
                  ", Smooth = ", Smooth, ", Phase = ", Phase, ")"); 
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, 2);
  //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
  CJJMA JMA;
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMALengthCheck("Length", Length);
  JMA.JJMALengthCheck("Smooth", Smooth);
  JMA.JJMAPhaseCheck ("Phase",  Phase );
//----+ end of initialization
 }
//+X================================================================X+  
//| JJRSX iteration function                                         | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],    
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < 32) return(0);
    
   //---- declaration of variables with a floating point  
   double dprice_, udprice_, up_jrsx, dn_jrsx, jrsx, jjrsx;
   //----+ declaration of integer variables and getting calculated bars
   int first, bar;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
        first = 1; // starting number of calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of variables of the class JurX from the file JurXSeries_Cls.mqh
   static CJurX Jur1, Jur2;
   //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
   static CJJMA JMA;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Call of the function PriceSeries to get incrementation of the input price dprice_
     dprice_ = PriceSeries(IPC, bar, open, low, high, close) 
              - PriceSeries(IPC, bar - 1, open, low, high, close);
              
     udprice_ = MathAbs(dprice_);
  
     //----+ Two call of the function JurXSeries.  
     up_jrsx = Jur1.JurXSeries(1, prev_calculated, rates_total, 0, Length,  dprice_, bar, false);
     dn_jrsx = Jur2.JurXSeries(1, prev_calculated, rates_total, 0, Length, udprice_, bar, false);
     
     //---- Preventing zero divide on empty values
     if (dn_jrsx == 0) jrsx = EMPTY_VALUE;
     else 
      {
       jrsx = up_jrsx / dn_jrsx;
       
       //---- Upper an lower limits of the indicator 
       if (jrsx > +1)jrsx = +1;
       if (jrsx < -1)jrsx = -1;
      }

     //----+ One call of the function JJMASeries
     jjrsx = JMA.JJMASeries(1, prev_calculated, rates_total, 0, Phase, Smooth, jrsx, bar, false);
     
     //---- Loading the obtained value in the indicator buffer
     JJRSX[bar] = jjrsx;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
