/*
 *  << Oscillator of price momentums >>
 *
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 * Main methods of using the "Chande's oscillator of price momentums":
 *
 * 1) Normal method of interpretation of CMO - searching for overbuying/overselling. 
 * Overbuying - when the level is +50 and higher, overselling when the level is -50 and lower.
 * Those levels march to the 70/30 levels of the RSI indicator. 
 * 2) Trend indicator. Buy - when long period CMO crosses short period CMO
 * selling - vice versa, when short period CMO crosses long period CMO.
 */
//+X================================================================X+
//|                                                         JCMO.mq5 |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
//---- author of the indicator
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- light brown color is used as the color of the indicator line
#property indicator_color1  Salmon
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "CMO"
//---- parameters of horizontal levels of the indicator
#property indicator_level1  80
#property indicator_level2  50
#property indicator_level3  20
#property indicator_levelcolor Lime
#property indicator_levelstyle STYLE_DASHDOTDOT

//+----------------------------------------------+
//| Input parameters of the indicator            |
//+----------------------------------------------+
input int CMO_period = 9; // period of CMO
input int Length = 3; // depth of the JMA smoothing
input int Phase  = 100; // parameter of the JMA smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices; 
input int CMO_Shift = 0; // horizontal shift of the indicator in bars
//+----------------------------------------------+
//---- declaration of a dynamic array that further 
                // will be used an indicator buffer
double ExtLineBuffer[]; 
//+X================================================================X+
// Description of the class CCMO                                     |
// Description of the class CJJMA                                    |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+
//| Custom indicator initialization function                         |
//+X================================================================X+  
void OnInit()
  {
//----+
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- shifting the indicator horizontally by VIDYAShift
   PlotIndexSetInteger(0, PLOT_SHIFT, CMO_Shift);
   //---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CMO_period + 30);
   //---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname, "JCMO(", CMO_period, ")");
   //--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0, PLOT_LABEL, shortname);   
   //--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME, shortname);
   //--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, 0);
   //--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
   CJJMA JMA;
   //---- setting up alerts for unacceptable values of external variables
   JMA.JJMALengthCheck("Length", Length);
   //---- setting up alerts for unacceptable values of external variables
   JMA.JJMAPhaseCheck("Phase", Phase);
//----+
  }
//+X================================================================X+
//| Custom indicator iteration function                              |
//+X================================================================X+
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const int begin,          // number of beginning of reliable counting of bars
                const double &price[]     // price array for calculation of the indicator
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < CMO_period + 30 + 2 + begin)
    return(0);
   
   //---- declaration of local variables 
   int first, bar, jbegin = begin + CMO_period + 2; 
   double cmo, jjma;

   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    { 
     first = 0 + begin; // starting number for calculation of all bars
     //--- increase the position of the beginning of data by 'begin' bars as a result of calculation using data of another indicator
     if(begin > 0) PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CMO_period + 30 + 2 + begin);
    }
   else 
    {
     first = prev_calculated - 1; // starting number for calculation of new bars
    }

   //---- declaration of variable of the class CCMO
   static CCMO CMO1;
   //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
   static CJJMA JMA;

   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     cmo = CMO1.CMOSeries(begin, prev_calculated, rates_total, CMO_period, price[bar], bar, false) * 100;
     //----+ One call of the function JJMASeries. 
     //The parameters Phase and Length don't change at every bar (Din = 0) 
     jjma = JMA.JJMASeries(jbegin, prev_calculated, rates_total, 0, Phase, Length, cmo, bar, false);
     ExtLineBuffer[bar] = jjma;
    }
//----+     
   return(rates_total);
  }
//+------------------------------------------------------------------+
