//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                         VidyaBandsSeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
//   CStdDeviation{};  CCMO{};                       | 
//+X----------------------------------------------------------------X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+
//|  The algorithm of getting the Bollinger channel                  |
//|  calculated from VIDYA                                           |
//+X================================================================X+
class CVidyaBands
 {
public:
  double VidyaBandsSeries(uint begin, // number of beginning of bars for reliable calculation
                           uint prev_calculated, // amount of history in bars at previous tick
                           uint rates_total, // amount of history in bars at the current tick
                           int CMO_period, // Period of averaging of the oscillator CMO
                           double EMA_period, // period of averaging of EMA
                           ENUM_MA_METHOD MA_Method, // method of averaging
                           int BBLength, // period of averaging of the Bollinger channel
                           double deviation, // deviation
                           double series,  // value of the price series calculated for the new bar with number 'bar'
                           uint bar,  // bar number
                           bool set, // direction of indexing arrays
                           double& DnMovSeries, // value of the lower border of the channel for the current bar 
                           double& MovSeries,  // value of the middle line of the channel for the current bar 
                           double& UpMovSeries  // value of the upper border of the channel for the current bar 
                          ) 
   {
//----+
    //----+ Calculation of the middle line    
    MovSeries = m_VIDYA.VIDYASeries(begin, prev_calculated, rates_total, CMO_period, EMA_period, series, bar, set);
  
    //----+ Calculation of the Bollinger channel
    double StdDev = m_STD.StdDevSeries(begin+CMO_period+1, prev_calculated, rates_total, BBLength, deviation, series, MovSeries, bar, set);
    DnMovSeries = MovSeries - StdDev;
    UpMovSeries = MovSeries + StdDev;
//----+
    return(StdDev); 
   }
 
  protected:
    //---- declaration of variables of the classes CCMO and CStdDeviation
    CCMO           m_VIDYA;
    CStdDeviation  m_STD;
 };
//+X----------------------+ <<< The End >>> +-----------------------X+