//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                               nMomSeries_Cls.mqh |
//|                                T3 code: Copyright  1998, Tilson |
//|                MQL5 T3Series: Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| The algorithm of normalized momentum calculated on price series  |
//+X================================================================X+
class CnMomentum : public CMovSeriesTools
 {
public: 
   double  nMomentumSeries(uint begin,// number of beginning of bars for reliable calculation
                            uint prev_calculated,// amount of history in bars at the previous tick
                            uint rates_total,// amount of history in bars at the current tick
                            int Length,// period of averaging
                            double series,// value of the price series calculated for the new bar with number 'bar'
                            uint bar,// bar number
                            bool set // direction of indexing arrays
                            );
protected:
   
   double  m_SeriesArray[];
   int     m_Size_, m_count;
 };
//+X================================================================X+
//|  Normalized rate of price changing                               |
//+X================================================================X+    
double CnMomentum::nMomentumSeries
(
 uint begin,// number of beginning of bars for reliable calculation
 uint prev_calculated,// amount of history in bars at the previous tick
 uint rates_total,// amount of history in bars at the current tick
 int Length,// period of averaging
 double series,// value of the price series calculated for the new bar with number 'bar'
 uint bar,// bar number
 bool set // direction of indexing arrays
 )
// nMomentumSeries(begin, prev_calculated, rates_total, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  { 
//----+  Checking the beginning of bars for reliable calculation 
   if(BarCheck1(begin,bar,set)) return(EMPTY_VALUE);

//----+ Declaration of local variables
   int kkk, Length_=Length+1;
   double nMomentum;
   
//----+ checking for correctness the external parameter Length
   LengthCheck(Length);	

//----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__, Length_, m_SeriesArray, m_Size_))
      return(EMPTY_VALUE);

//----+ rearrangement and initialization of cells of the array m_SeriesArray
   Recount_ArrayZeroPos(m_count, Length_, prev_calculated, series, bar, m_SeriesArray);

//----+ Initialization of zero
   if(BarCheck3(begin, bar, set, Length_)) return(EMPTY_VALUE);

//----+ Calculation of rate of price changing
   kkk = Recount_ArrayNumber(m_count, Length_, Length);
   nMomentum = (series - m_SeriesArray[kkk]) / m_SeriesArray[kkk];
//----+
   return(nMomentum);
  } 
//+X----------------------+ <<< The End >>> +-----------------------X+