//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                             StdDevSeries_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMoving_Average                          |
//+X----------------------------------------------------------------X+ 
#include <MASeries_Cls.mqh> 
//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//|  The algorithm of getting the standard deviation                 |
//+X================================================================X+
class CStdDeviation : public CMovSeriesTools
 {
public:
  double StdDevSeries(uint begin, // number of beginning of bars for reliable calculation
                       uint prev_calculated, // amount of history in bars at previous tick
                       uint rates_total, // amount of history in bars at the current tick
                       int Length, // period of averaging
                       double deviation, // deviation
                       double series,  // value of the price series calculated for the new bar with number 'bar'
                       double MovSeries, // Value of a moving average, on which basis the StdDeviation is calculated
                       uint bar,  // bar number
                       bool set // direction of indexing arrays
                       );
  protected:
  int    m_Size_, m_count;
  double m_Sum, m_SUM, m_Sum2, m_SUM2;
  double m_SeriesArray[];  
 };
//+X================================================================X+
//|  Calculation of the standard deviation                           |
//+X================================================================X+    
double CStdDeviation::StdDevSeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int Length, // period of averaging
  double deviation, // deviation
  double series,  // value of the price series calculated for the new bar with number 'bar'
  double MovSeries, // Value of a moving average, on which basis the StdDeviation is calculated
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// StdDevSeries(begin, prev_calculated, rates_total, period, deviation, Series, MovSeries, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables
  int iii, kkk;
  double StdDev, m_SumX2;

  //----+ Changing the size of array of variables
   if(bar==begin && !SeriesArrayResize(__FUNCTION__, Length, m_SeriesArray, m_Size_))
      return(EMPTY_VALUE);
  
  //----+ checking for correctness the external parameter Length
  LengthCheck(Length);
      
  //----+ rearrangement of cells of the array m_SeriesArray
  Recount_ArrayZeroPos(m_count, Length, prev_calculated, series, bar, m_SeriesArray);
  
  //----+ Initialization of zero
  if(BarCheck2(begin, bar, set, Length))
   {
    m_Sum = 0.0;
    m_Sum2 = 0.0;
    for(iii = 1; iii < Length; iii++)
     {
      kkk = Recount_ArrayNumber(m_count, Length, iii); 
      m_Sum += m_SeriesArray[kkk];
      m_Sum2 += MathPow(m_SeriesArray[kkk], 2);
     }
   }              
  else if(BarCheck3(begin, bar, set, Length)) return(EMPTY_VALUE);
   
  //----+  StdDev
  m_Sum += series;
  m_Sum2 += MathPow(series, 2);
  m_SumX2 = Length * MathPow(MovSeries, 2) - 2 * MovSeries * m_Sum + m_Sum2;
  
  kkk = Recount_ArrayNumber(m_count, Length, Length - 1);
  m_Sum2 -=  MathPow(m_SeriesArray[kkk], 2);
  m_Sum -= m_SeriesArray[kkk];
  
  StdDev = deviation * MathSqrt(m_SumX2 / Length);
  
  //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
    m_Sum = m_SUM;
    m_Sum2 = m_SUM2;
   }
   
  //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set)) 
   {
    m_SUM = m_Sum;
    m_SUM2 = m_Sum2;
   }  
//----+
  return(StdDev); 
 }
//+X----------------------+ <<< The End >>> +-----------------------X+