//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                           MovSeriesTools_Cls.mqh |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X================================================================X+
//|  Functional utilities for the classes of averaging algorithms    |
//+X================================================================X+
class CMovSeriesTools
 {
public:
  void                   MALengthCheck(string LengthName, int    ExternLength);
  void                   MALengthCheck(string LengthName, double ExternLength);
  
protected: 
  bool                   BarCheck1(int begin, int bar, bool Set);
  bool                   BarCheck2(int begin, int bar, bool Set, int Length);
  bool                   BarCheck3(int begin, int bar, bool Set, int Length);
  
  bool                   BarCheck4(int rates_total, int bar, bool Set); 
  bool                   BarCheck5(int rates_total, int bar, bool Set);
  bool                   BarCheck6(int rates_total, int bar, bool Set);
  
  void                   LengthCheck(int&    ExternLength);
  void                   LengthCheck(double& ExternLength);
  
  void                   Recount_ArrayZeroPos(int& count,
                                               int Length,
                                               int prev_calculated,
                                               double series,
                                               int bar,
                                               double& Array[]
                                               );

  int                    Recount_ArrayNumber(int count, int Length, int Number);
  
  bool                   SeriesArrayResize(string FunctionsName,
                                            int Length,
                                            double& Array[],
                                            int& Size_
                                            );
                                            
  bool                   ArrayResizeErrorPrint(string FunctionsName, int& Size_);
 };
//+X================================================================X+
//| Checking correctness of the period of averaging                  |
//+X================================================================X+
void CMovSeriesTools::MALengthCheck(string LengthName, int ExternLength)

// MALengthCheck(LengthName, ExternLength)
 {
//----+ 
  if (ExternLength < 1)
   {
    string word;
    StringConcatenate
      (word, __FUNCTION__, " (): Parameter ", LengthName,
            " must be no less than 1. You specified incorrect value",
                            ExternLength, " value 1 will be used");
    Print(word);
    return;
   }
//----+
 }
//+X================================================================X+
//| Checking correctness of the period of averaging                  |
//+X================================================================X+
void CMovSeriesTools::MALengthCheck(string LengthName, double ExternLength)

// MALengthCheck(LengthName, ExternLength)
 {
//----+ 
  if (ExternLength < 1)
   {
    string word;
    StringConcatenate
      (word, __FUNCTION__, " (): Parameter ", LengthName,
            " must be no less than 1. You specified incorrect value",
                            ExternLength, " value 1 will be used");
    Print(word);
    return;
   }
//----+
 }
//+X================================================================X+
//| Checking if a bar withing the range of calculation               |
//+X================================================================X+
bool CMovSeriesTools::BarCheck1(int begin, int bar, bool Set)

// BarCheck1(begin, bar, Set)
 {
//----+
  if (!Set && bar < begin || Set && bar > begin) return(true);
//----+
  return(false);
 }
//+X================================================================X+
//| Checking bar for the start of calculation                        |
//+X================================================================X+
bool CMovSeriesTools::BarCheck2(int begin, int bar, bool Set, int Length)

// BarCheck2(begin, bar, Set, Length)
 {
//----+
  if (!Set&&bar == begin + Length - 1 || Set&&bar == begin - Length + 1)
   return(true);
//----+
  return(false);
 }
//+X================================================================X+
//| Checking bar for absence of bars for averaging                   |
//+X================================================================X+
bool CMovSeriesTools::BarCheck3(int begin, int bar, bool Set, int Length)

// BarCheck3(begin, bar, Set, Length)
 {
//----+
  if (!Set&&bar < begin + Length - 1 || Set&&bar > begin - Length + 1)
   return(true);
//----+
  return(false);
 }
//+X================================================================X+
//| Checking bar at the moment of saving information                 |
//+X================================================================X+
bool CMovSeriesTools::BarCheck4(int rates_total, int bar, bool Set)

// BarCheck4(rates_total, bar, Set)
 {
//----+
  //----+ saving values of variables
  if (!Set&&bar == rates_total - 2 || Set&&bar == 1) return(true); 
//----+
  return(false);
 }
//+X================================================================X+
//| Checking bar at the moment of restoring information              |
//+X================================================================X+
bool CMovSeriesTools::BarCheck5(int rates_total, int bar, bool Set)

// BarCheck5(rates_total, begin, bar, set)
 {
//----+
  //----+ restoring values of variables
  if (!Set&&bar == rates_total - 1 || Set&&bar == 0) return(true);
//----+
  return(false);
 }
//+X================================================================X+
//| Changing incorrect period of averaging                           |
//+X================================================================X+
void CMovSeriesTools::LengthCheck(int& ExternLength)

// LengthCheck(LengthName, ExternLength)
 {
//----+
  if (ExternLength < 1) ExternLength = 1;  
//----+
 }
//+X================================================================X+
//| Changing incorrect period of averaging                           |
//+X================================================================X+
void CMovSeriesTools::LengthCheck(double& ExternLength)

// LengthCheck(ExternLength)
 {
//----+
  if (ExternLength < 1) ExternLength = 1;  
//----+
 }
//+X================================================================X+
//|  Recalculation of position of a newest element in the array      |
//+X================================================================X+    
void CMovSeriesTools::Recount_ArrayZeroPos
 (
  int& count,
  int Length,
  int prev_calculated,
  double series,
  int bar,
  double& Array[]
 )
// Recount_ArrayZeroPos(count, Length, prev_calculated, series, bar, Array[])
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  if (bar != prev_calculated - 1)
   {
    count--;
    if (count < 0) count = Length - 1;
   }

  Array[count] = series;
//----+
 }
//+X================================================================X+
//|  Transformation of a timeseries number into an array position    |
//+X================================================================X+    
int CMovSeriesTools::Recount_ArrayNumber(int count, int Length, int Number)
// Recount_ArrayNumber(count, Length, Number)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  int ArrNumber = Number + count;
  
  if (ArrNumber > Length - 1) ArrNumber -= Length;
//----+
  return(ArrNumber);
 }
//+X================================================================X+
//|  Changing size of the array Array[]                              |
//+X================================================================X+    
bool CMovSeriesTools::SeriesArrayResize
 (
  string FunctionsName, // Name of function, in which the size is changed
  int Length, // new size of array
  double& Array[], // array that is changed
  int& Size_ // new size of the array
 )
// SeriesArrayResize(FunctionsName, Length, Array, Size_) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+    
  
  //----+ Changing the size of array of variables
  if (Length > Size_)
   {
    uint Size = Length + 1;
    
    if (ArrayResize(Array, Size) == -1)
     {
      ArrayResizeErrorPrint(FunctionsName, Size_);
      return(false);
     }

    Size_ = Size;
   }
//----+
  return(true);
 }
//+X================================================================X+
//|  Writing the error of changing size of the array into log file   |
//+X================================================================X+    
bool CMovSeriesTools::ArrayResizeErrorPrint
 (
  string FunctionsName,
  int& Size_
 )
// ArrayResizeErrorPrint(FunctionsName, Size_) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+    
  string lable, word;
  StringConcatenate(lable, FunctionsName, "():");
  StringConcatenate(word, lable, " Error!!! Failed to change",
            " the size of array of variables of the function ", FunctionsName, "()!");
  Print(word);
  //----             
  int error = GetLastError();
  ResetLastError();
  //----
  if (error > 4000)
   {
    StringConcatenate(word, lable, "(): Error code ", error);
    Print(word);
   } 
	   
   Size_ = -2;
   return(false);
//----+
  return(true);
 }
//+X----------------------+ <<< The End >>> +-----------------------X+