//MQL5 Version  June 21, 2010 Final
//+X================================================================X+
//|                                               JurXSeries_Cls.mqh | 
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//+X----------------------------------------------------------------X+
// Description of the class CMovSeriesTools                          |
//+X----------------------------------------------------------------X+ 
#include <MovSeriesTools_Cls.mqh>
//+X================================================================X+
//| The algorithm of ultralinear averaging of price series           |
//+X================================================================X+
class CJurX : public CMovSeriesTools
 {
public:  
  double   JurXSeries(uint begin, // number of beginning of bars for reliable calculation
                       uint prev_calculated, // amount of history in bars at previous tick
                       uint rates_total, // amount of history in bars at the current tick
                       int  Din, // permission to change the parameter Length at every bar. 
                                  // 0 - prohibition to change the parameters, any other values means permission.
                       double Length, // depth of smoothing
                       double series,  // value of the price series calculated for the new bar with number 'bar'
                       uint bar,  // bar number
                       bool set // direction of indexing arrays
                       ); 
protected:
  void     JurXInit(uint begin,
                     int Din,
                     double Length,
                     double series,
                     uint bar
                     );

   //----+ Declaration of global variables
   double   m_AB, m_AC;
   double   m_f1, m_f2, m_f3, m_f4, m_f5;
   double   m_f6, m_Kg, m_Hg, m_F1, m_F2;
   double   m_F3, m_F4, m_F5, m_F6, m_w ;
 };
//+X================================================================X+
//| Ultralinear averaging                                            |
//+X================================================================X+    
double CJurX::JurXSeries
 (
  uint begin, // number of beginning of bars for reliable calculation
  uint prev_calculated, // amount of history in bars at previous tick
  uint rates_total, // amount of history in bars at the current tick
  int  Din, // permission to change the parameter Length at every bar 
                 // 0 - prohibition to change the parameters, any other values means permission.
  double Length, // depth of smoothing
  double series,  // value of the price series calculated for the new bar with number 'bar'
  uint bar,  // bar number
  bool set // direction of indexing arrays
 )
// JurXSeries(begin, prev_calculated, rates_total, Din, Length, series, bar, set) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+
  //---- Checking the beginning of bars for reliable calculation 
  if (BarCheck1(begin, bar, set)) return(EMPTY_VALUE);
  
  //----+ Declaration of local variables
  double V1, V2, JurX_;

  //----+ checking for correctness the external parameter Length
  LengthCheck(Length);	 
	 
	 //----+ Initialization of coefficients
  JurXInit(begin, Din, Length, series, bar);
	 
 	//---- <<< calculation of JurX >>> 
 	m_f1   =  m_Hg * m_f1 + m_Kg * series;
	 m_f2   =  m_Kg * m_f1 + m_Hg * m_f2;
	 V1     =  m_AC * m_f1 - m_AB * m_f2;
	 m_f3   =  m_Hg * m_f3 + m_Kg * V1;
	 m_f4   =  m_Kg * m_f3 + m_Hg * m_f4;
 	V2     =  m_AC * m_f3 - m_AB * m_f4;
	 m_f5   =  m_Hg * m_f5 + m_Kg * V2;
	 m_f6   =  m_Kg * m_f5 + m_Hg * m_f6;
	 JurX_  =  m_AC * m_f5 - m_AB * m_f6;
	 
	 //----+ restoring values of variables
  if (BarCheck5(rates_total, bar, set))
   { 
	   m_f1 = m_F1; 
	   m_f2 = m_F2; 
	   m_f3 = m_F3; 
	   m_f4 = m_F4; 
	   m_f5 = m_F5; 
	   m_f6 = m_F6;
   }
    
	 //----+ saving values of variables
  if (BarCheck4(rates_total, bar, set)) 
	  {
	   m_F1 = m_f1; 
	   m_F2 = m_f2; 
	   m_F3 = m_f3; 
	   m_F4 = m_f4; 
	   m_F5 = m_f5; 
	   m_F6 = m_f6;
	  }
	 
//----+ End of calculation of value of the functions JurX.Series
  return(JurX_);
	
 }
//+X================================================================X+
//|  Initialization of variables of the algorithm JurX               |
//+X================================================================X+    
void CJurX::JurXInit
 (
  uint begin,
  int Din,
  double Length,
  double series,
  uint bar
 )
// JurXInit(begin, Din, Length, series, bar) 
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 {
//----+  
  if (bar == begin || Din != 0) 
   {
	   if (Length >= 6) 
	        m_w = Length - 1;        
	   else m_w = 5; 
	  
	   m_Kg = 3 / (Length + 2.0); 
	   m_Hg = 1.0 - m_Kg;
	   //----
	   if (bar == begin)
	    {
	     m_f1 = series; 
	     m_f2 = series; 
	     m_f3 = series; 
	     m_f4 = series; 
	     m_f5 = series; 
	     m_f6 = series;
	     
	     m_AB = 0.5;
	     m_AC = 1.5;
	    }
	 }
//----+
 }
//+X----------------------+ <<< The End >>> +-----------------------X+