//+X================================================================X+ 
//|                                                        cMAx4.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- dark purple color is used as the color of the bullish line of the indicator
#property indicator_color1 DarkOrchid
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "cMAx4"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
input int Length1 = 3; // depth of the SMA smoothing
input int Length2 = 3; // depth of the EMA smoothing
input int Length3 = 3; // depth of the SMMA smoothing 
input int Length4 = 3; // depth of the LWMA smoothing                    
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // shifting the ma vertically in points
//+-----------------------------------+
//---- indicator buffer
double cMAx4[];

int Handle;
int start;
double dPriceShift;
//+X================================================================X+    
//| cMAx4 indicator initialization function                          | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, cMAx4, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- Initialization of the variable of start of data calculation
  start  = Length1  + Length3 + Length4;
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
  //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "cMAx4"); 
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "cMAx4( SMA Length = ", Length1, ", EMA Length = ", Length2,
                                         ", SMMA Length = ", Length3, ", LWMA Length = ", Length4, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
  
  //----+ Get handle of the indicator
  Handle =  iCustom(NULL,0,"Examples\\Custom Moving Average", Length1, 0, MODE_SMA, PRICE_CLOSE);
  if (Handle == INVALID_HANDLE)Print(" Failed to get handle of the indicator Custom Moving Average");
  Handle =  iCustom(NULL,0,"Examples\\Custom Moving Average", Length2, 0, MODE_EMA, Handle);
  if (Handle == INVALID_HANDLE)Print(" Failed to get handle of the indicator Custom Moving Average");
  Handle =  iCustom(NULL,0,"Examples\\Custom Moving Average", Length3, 0, MODE_SMMA, Handle);
  if (Handle == INVALID_HANDLE)Print(" Failed to get handle of the indicator Custom Moving Average");
  Handle =  iCustom(NULL,0,"Examples\\Custom Moving Average", Length3, 0, MODE_LWMA, Handle);
  if (Handle == INVALID_HANDLE)Print(" Failed to get handle of the indicator Custom Moving Average");
  
  //----+ Indexation of elements in buffers as in timeseries
  ArraySetAsSeries(cMAx4, true);
//----+ end of initialization
 }
//+X================================================================X+  
//| cMAx4 iteration function                                         | 
//+X================================================================X+  
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+
   start += begin;   
   //---- Checking if there is enough bars for the calculation
   if (rates_total < start) return(0);
   
   int to_copy;
   
   if(prev_calculated > rates_total || prev_calculated <= 0)// checking for the first start of calculation of an indicator
    {
     to_copy = rates_total - begin; // calculated number of all bars
     
     //--- increase the position of the start of data by 'begin' bars
           // as a result of calculation on the basis of data of another indicator
     if(begin > 0) PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
    }
   else to_copy = rates_total - prev_calculated + 1; // calculated number of new bars only
   
   //--- copy the newly appeared data in the indicator buffer
   if(CopyBuffer(Handle, 0, 0, to_copy, cMAx4) <= 0) return(0);
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
