/*
 * For the indicator to work, place the files
 * SmoothAlgorithms.mqh
 * IndicatorsAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                  VidyaBBands.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 5 
//---- 3 plots are used
#property indicator_plots   5
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- light green color is used as the color of the indicator line
#property indicator_color1 LightSeaGreen
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "Upper Vidya Bollinger"

//---- drawing of the indicator as a line
#property indicator_type2   DRAW_LINE
//---- use gray color for the indicator line
#property indicator_color2 SlateGray
//---- the indicator line is a continuous line
#property indicator_style2  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width2  2
//---- displaying labels of the indicator
#property indicator_label2  "Middle Vidya Bollinger"

//---- drawing of the indicator as a line
#property indicator_type3   DRAW_LINE
//---- dark pink color is used as the color of the indicator line
#property indicator_color3 DeepPink
//---- the indicator line is a continuous line
#property indicator_style3  STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width3  1
//---- displaying labels of the indicator
#property indicator_label3  "Lower Vidya Bollinger"
//+----------------------------------------------+
//|  Parameters of drawing the bullish indicator |
//+----------------------------------------------+
//---- drawing indicator as a symbol
#property indicator_type4   DRAW_ARROW
//---- color of the bullish indicator is light green
#property indicator_color4 SpringGreen
//---- thickness of the indicator line is 2
#property indicator_width4 2
//---- displaying of the bullish label of the indicator
#property indicator_label4 "Up_Signal"
//+----------------------------------------------+
//|  Parameter of drawing the bearish indicator  |
//+----------------------------------------------+
//---- drawing indicator as a symbol
#property indicator_type5   DRAW_ARROW
//---- dark pink is used as the color of the bearish indicator
#property indicator_color5  DeepPink
//---- thickness of the indicator line is 2
#property indicator_width5 2
//---- displaying of the bearish label of the indicator
#property indicator_label5 "Dn_Signal"

//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int CMO_period = 9; //period of VIDA
input double EMA_period = 12; //period of EMA
input int BandsPeriod = 20; //period of averaging of BB
input double BandsDeviation = 2.0; //deviation 
input Applied_price_ IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
input bool TradeSoundSignal = false; //making a sound signal
//---+
//---- indicator buffers
double UpperBuffer[];
double MiddleBuffer[];
double LowerBuffer[];
double UpBuffer[];
double DnBuffer[];
//+X================================================================X+
// Description of the classes of averaging and indicators            |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh>
#include <IndicatorsAlgorithms.mqh> 
//+X================================================================X+    
//| BBands indicator initialization function                         | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, UpperBuffer, INDICATOR_DATA);
  //---- shifting the indicator 1 horizontally by AroonShift
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- shifting the start of drawing of the indicator 1
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, CMO_period + BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "Upper Vidya Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(1, MiddleBuffer, INDICATOR_DATA);
  //---- shifting the indicator 2 horizontally
  PlotIndexSetInteger(1, PLOT_SHIFT, Shift);
  //---- shifting the beginning of drawing of the indicator 2
  PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, CMO_period - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(1, PLOT_LABEL, "Middle Vidya Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(2, LowerBuffer, INDICATOR_DATA);
  //---- shifting the indicator 3 horizontally
  PlotIndexSetInteger(2, PLOT_SHIFT, Shift);
  //---- shifting the beginning of drawing of the indicator 3
  PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, CMO_period + BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(2, PLOT_LABEL, "Lower Vidya Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(3, UpBuffer, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(3, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(3, PLOT_DRAW_BEGIN, CMO_period + BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(3, PLOT_LABEL, "Up Signal");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //--- selecting symbol for drawing
  PlotIndexSetInteger(3, PLOT_ARROW, 159);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(4, DnBuffer, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(4, PLOT_SHIFT, Shift);
  //---- shifting the start of drawing of the indicator 1
  PlotIndexSetInteger(4, PLOT_DRAW_BEGIN, CMO_period + BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(4, PLOT_LABEL, "Dn Signal");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(4, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //--- selecting symbol for drawing
  PlotIndexSetInteger(4, PLOT_ARROW, 159);
  
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "Vidya BBands( CMO_period = ", CMO_period, " EMA_period = ",
           EMA_period, " BandsPeriod = ", BandsPeriod, ", BandsDeviation = ", BandsDeviation, " )");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
//----+ end of initialization
 }
//+X================================================================X+  
//| BBands iteration function                                        | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],    
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < BandsPeriod) return(0);
    
   //---- declaration of variables with a floating point  
   double price_;
   
   //----+ declaration of integer variables and getting calculated bars
   int first, bar;
     
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
        first = 0; // start number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of variable of the class CVidyaBands
   static CVidyaBands VidyaBB;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Call of the PriceSeries function to get the input price 'Series'
     price_ = PriceSeries(IPC, bar, open, low, high, close);
     
     //----+   VidyaBandsSeries
     VidyaBB.VidyaBandsSeries(0, prev_calculated, rates_total,
       CMO_period, EMA_period, BandsPeriod, BandsDeviation, price_, bar, false, 
                                LowerBuffer[bar], MiddleBuffer[bar], UpperBuffer[bar]);
     
     //---- initialization of cells of indicator buffers with zeros
     UpBuffer[bar] = 0.0;
     DnBuffer[bar] = 0.0;
     
     //---- initialization of cells of the indicator buffers with obtained values 
     price_ = NormalizeDouble(iPriceSeries(NULL, 0, PRICE_CLOSE, bar, false), _Digits);
     if (price_ > NormalizeDouble(UpperBuffer[bar], _Digits)) UpBuffer[bar] = MiddleBuffer[bar]; //there is an ascending trend
     if (price_ < NormalizeDouble(LowerBuffer[bar], _Digits)) DnBuffer[bar] = MiddleBuffer[bar]; //there is a descending trend     
    }
   
   //---- making a sound signal when trend changes 
   if (TradeSoundSignal)
    {
     static int trend = 0;
    
     first = rates_total - 2; //get value of the last closed bar
   
     if (DnBuffer[first] > 0 && trend > 0 || UpBuffer[first] > 0 && trend < 0) // determine when trend changes
      PlaySound("alert.wav");
    
     //---- fix value of the current trend in the static variable 
     if (NormalizeDouble(UpBuffer[first], _Digits) != 0.0)trend = +1;
     if (NormalizeDouble(DnBuffer[first], _Digits) != 0.0)trend = -1;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
