/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+
//|                                                        ParMA.mq5 |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//---- Drawing the indicator in the main window
#property indicator_chart_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- light blue color is used as the color of the indicator line
#property indicator_color1 DodgerBlue

//---- input parameters of the indicator
input double ParMAPeriod = 13; //  ParMA
input int    ParMAShift = 0; // horizontal shift of ParMA in bars
input int    ParMAPriceShift = 0; // vertical shift of ParMA in points

//--- indicator buffer
double ExtLineBuffer[];

double dPriceShift;
//+X================================================================X+
//| Custom indicator initialization function                         |
//+X================================================================X+
void OnInit()
  {
//----+
   //---- name for the data window and for the label of sub-windows 
   string short_name = "ParMA";
   IndicatorSetString(INDICATOR_SHORTNAME, short_name + "(" + string(ParMAPeriod) + ")"); 
   //---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, ParMAPeriod); 
   //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- shifting the moving average horizontally by MAShift
   PlotIndexSetInteger(0, PLOT_SHIFT, ParMAShift);
   //---- Setting the format of accuracy of displaying the indicator
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
   //---- initialization of the vertical shift
   dPriceShift = _Point * ParMAPriceShift;
//----+
  }
//+X================================================================X+
// Description of the class ParMA                                    | 
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+ 
//|  Moving Average                                                  |
//+X================================================================X+
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < begin + ParMAPeriod)
    return(0);
   
   //---- declaration of local variables 
   int first, bar;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    {
     first = begin; // starting number for calculation of all bars
     for(bar = 0; bar <= begin; bar++)
       ExtLineBuffer[bar] = 0;
    }
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of variables of the class CParMA from the file ParMASeries_Cls.mqh
   static CParMA ParMA1;
   
   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //---- Getting the average value. One call of the function ParMASeries.  
     ExtLineBuffer[bar] = ParMA1.ParMASeries(begin, prev_calculated, rates_total,
                                        ParMAPeriod, price[bar], bar, false) + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
