/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+
//|                                               Moving_Average.mq5 |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//---- Drawing the indicator in the main window
#property indicator_chart_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- green color is used as the color of the indicator line
#property indicator_color1  LimeGreen

//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
input int            MAPeriod = 13; // period of MA
input int            MAShift = 0; // horizontal shift of MA in bars
input ENUM_MA_METHOD MAMethod = MODE_SMA;  // method of averaging
input int            MAPriceShift = 0; // vertical shift of MA in points

//--- indicator buffer
double ExtLineBuffer[];

int ma_begin = 0;
double dPriceShift;
//+X================================================================X+
//| Custom indicator initialization function                         |
//+X================================================================X+
void OnInit()
  {
//----+
   //---- name for the data window and for the label of sub-windows 
   string short_name;
   switch(MAMethod)
    {
     case MODE_EMA :  short_name = "EMA";  break;
     case MODE_LWMA : short_name = "LWMA"; break;
     case MODE_SMA :  short_name = "SMA";  break;
     case MODE_SMMA : short_name = "SMMA"; break;
     default : short_name = "SMA";
    }
   IndicatorSetString(INDICATOR_SHORTNAME, short_name + "(" + string(MAPeriod) + ")");  
   //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE, EMPTY_VALUE);
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- shifting the moving average horizontally by MAShift
   PlotIndexSetInteger(0, PLOT_SHIFT, MAShift);
   //---- shifting the beginning of drawing of the indicator MAPeriod
   if (MAMethod != MODE_EMA) ma_begin = MAPeriod - 1;
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, ma_begin);
   //---- Setting the format of accuracy of displaying the indicator
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
   //---- initialization of the vertical shift
   dPriceShift = _Point * MAPriceShift;
//----+
  }
//+X================================================================X+
// Description of the class CMoving_Average                          |
//+X================================================================X+  
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+ 
//|  Moving Average                                                  |
//+X================================================================X+
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < ma_begin + begin)
    return(0);
   
   //---- declaration of local variables 
   int first, bar;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    {
     first = begin; // starting number for calculation of all bars
     int draw_begin = ma_begin + begin;
     PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, draw_begin);
     for(bar = 0; bar <= draw_begin; bar++)
       ExtLineBuffer[bar] = 0;
    }
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of variable of the class CMoving_Average from the file MASeries_Cls.mqh
   static CMoving_Average MA;
   
   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //---- Getting the average value. One call of the MASeries.  
     ExtLineBuffer[bar] = MA.MASeries(begin, prev_calculated, rates_total,
                            	 MAPeriod, MAMethod, price[bar], bar, false) + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
