/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                     Momentum.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- indigo color is used as the color of the indicator line
#property indicator_color1 BlueViolet
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "Momentum"
//---- parameters of horizontal levels of the indicator
#property indicator_level1  0.5
#property indicator_level2 -0.5
#property indicator_level3  0.0
#property indicator_levelcolor Magenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
input int Length=8; // depth of smoothing 
input Applied_price_ IPC=PRICE_CLOSE_;//price constant
/* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; // horizontal shift of the indicator in bars
//---+
//---- indicator buffers
double Momentum[];
//+X================================================================X+
// Description of the function iPriceSeries                          |
// Description of the function iPriceSeriesAlert                     |
// Description of the class CMomentum                                |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh>  
//+X================================================================X+    
//| Momentum indicator initialization function                       | 
//+X================================================================X+  
void OnInit()
  {
//----+  
//---- turning a dynamic array into an indicator buffer
   SetIndexBuffer(0,Momentum,INDICATOR_DATA);
//---- shifting the indicator horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,0);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0,PLOT_LABEL,"Momentum");
//---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname,"Momentum( Length = ",Length,")");
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,2);
//---- declaration of variable of the class CJurX from the file SmoothAlgorithms.mqh
   CMomentum Mom;
//---- setting up alerts for unacceptable values of external variables
   Mom.MALengthCheck("Length", Length);
//----+ end of initialization
  }
//+X================================================================X+  
//| Momentum iteration function                                      | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----+   
//---- checking the number of bars to be enough for the calculation
   if(rates_total < Length+1) return(0);

//---- declaration of variables with a floating point  
   double price, momentum;
//----+ declaration of integer variables and getting calculated bars
   int first, bar;

//---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if(prev_calculated == 0) // checking if it's the first start of calculation of the indicator
      first = 0; // start number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars

//---- declaration of variables of the class CMomentum from the file SmoothAlgorithms.mqh
   static CMomentum Mom;

//---- Main cycle of calculation of the indicator
   for(bar=first; bar<rates_total; bar++)
     {
      //----+ Call of the function PriceSeries to get incrementation of the input price dprice_
      price = PriceSeries(IPC, bar, open, low, high, close);

      //----+ Two calls of the function MomentumSeries.  
      momentum = Mom.MomentumSeries(0, prev_calculated, rates_total, Length, price, bar, false);

      //---- Loading the obtained value in the indicator buffer
      Momentum[bar]=momentum;

     }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
