/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                       MAx3x1.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- dark purple color is used as the color of the bullish line of the indicator
#property indicator_color1 DarkOrchid
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "MAx4"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
input int Length1 = 3; // depth of the SMA smoothing
input int Length2 = 3; // depth of the EMA smoothing
input int Length3 = 3; // depth of the SMMA smoothing 
input int Length4 = 3; // depth of the LWMA smoothing                    
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // shifting the ma vertically in points
//+-----------------------------------+
//---- indicator buffer
double MAx4[];

int Handle;
int start;
double dPriceShift;
//+X================================================================X+
// Description of the class CMoving_Average                          |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+    
//| MAx4 indicator initialization function                           | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, MAx4, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- Initialization of the variable of start of data calculation
  start  = Length1  + Length3 + Length4;
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
  //---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "MAx4"); 
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "MAx4( SMA Length = ", Length1, ", EMA Length = ", Length2,
                                         ", SMMA Length = ", Length3, ", LWMA Length = ", Length4, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
  
  //----+ Get handle of the indicator
  Handle = iMA(NULL, 0, Length1, 0, MODE_SMA, PRICE_CLOSE);
  if (Handle == INVALID_HANDLE)Print(" Failed to get handle of the indicator iMA");
//----+ end of initialization
 }
//+X================================================================X+  
//| MAx4 iteration function                                          | 
//+X================================================================X+  
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+
   start += begin;   
   //---- Checking if there is enough bars for the calculation
   if (rates_total < start) return(0);

   //---- Declaration of integer variables
   int to_copy, first, bar, bar_;
   //---- declaration of variables with a floating point  
   double ma1_[], ma2_, ma3_, ma4_;
   //---- Declaration of static variables
   static int start2, start3, start4;
   
   //---- Initialization of the indicator in the OnCalculate() block
   if(prev_calculated > rates_total || prev_calculated <= 0)// checking for the first start of calculation of an indicator
    {
     first = begin; // starting number for calculation of all bars
     to_copy = rates_total - begin; // calculated number of all bars
     
     //---- Initialization of variables of the start of data calculation
     start2 = Length1 + begin;
     start3 = Length1 + begin; // previous EMA averaging doesn't change the start of data calculation
     start4 = Length1 + Length3 + begin;
     
     //--- increase the position of the start of data by 'begin' bars
           // as a result of calculation on the basis of data of another indicator
     if(begin > 0) PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start);
    }
   else
    {
     first = prev_calculated - 1; // starting number for calculation of new bars
     to_copy = rates_total - prev_calculated + 1; // calculated number of new bars
    }
    
   //----+ indexing elements in the array as in timeseries
   ArraySetAsSeries(ma1_, true);
   //--- copy newly appeared data in the array
   if(CopyBuffer(Handle, 0, 0, to_copy, ma1_) <= 0) return(0);
    
   //---- declaration of variables of the class CMoving_Average from the file MASeries_Cls.mqh
   static CMoving_Average MA2, MA3, MA4;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Three call of the function MASeries. 
     bar_ = rates_total - 1 - bar; 
     ma2_ = MA2.MASeries(start2, prev_calculated, rates_total, Length2, MODE_EMA,  ma1_[bar_], bar, false);
     ma3_ = MA3.MASeries(start3, prev_calculated, rates_total, Length3, MODE_SMMA, ma2_,       bar, false);
     ma4_ = MA4.MASeries(start4, prev_calculated, rates_total, Length4, MODE_LWMA, ma3_,       bar, false);
     //----       
     MAx4[bar] = ma4_ + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
