//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2011, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
/*
 *         
 * SmoothAlgorithms.mqh
 *   (): MetaTrader\\MQL5\Include
 */
//+------------------------------------------------------------------+
//|                                               Moving_Average.mq5 |
//|                               Copyright  2010, Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "2010,   Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
#property version   "1.00"

//----     
#property indicator_chart_window
//----        
#property indicator_buffers 1
//----     
#property indicator_plots   1
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  LimeGreen

//+-----------------------------------+
//|         |
//+-----------------------------------+
input int            MAPeriod=13; //  
input int            MAShift=0; //      
input ENUM_MA_METHOD MAMethod=MODE_SMA;  //  

//---  
double ExtLineBuffer[];

int ma_begin=0;
double dPriceShift;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----         
   string short_name;
   switch(MAMethod)
     {
      case MODE_EMA :  short_name = "EMA";  break;
      case MODE_LWMA : short_name = "LWMA"; break;
      case MODE_SMA :  short_name = "SMA";  break;
      case MODE_SMMA : short_name = "SMMA"; break;
      default : short_name="SMA";
     }
   IndicatorSetString(INDICATOR_SHORTNAME,short_name+"("+string(MAPeriod)+")");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ExtLineBuffer   
   SetIndexBuffer(0,ExtLineBuffer,INDICATOR_DATA);
//----        MAShift
   PlotIndexSetInteger(0,PLOT_SHIFT,MAShift);
//----       MAPeriod
   if(MAMethod!=MODE_EMA) ma_begin=MAPeriod-1;
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ma_begin);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----
  }
//+------------------------------------------------------------------+
//   CMoving_Average                                   | 
//+------------------------------------------------------------------+  
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+ 
//|  Moving Average                                                  |
//+------------------------------------------------------------------+
int OnCalculate
(
 const int rates_total,//       
 const int prev_calculated,//       
 const int begin,//     
 const double &price[]//     
 )
  {  
//----       
   if(rates_total<ma_begin+begin)
      return(0);

//----    
   int first,bar;

//----    first    
   if(prev_calculated==0) //      
     {
      first=begin; //      
      int draw_begin=ma_begin+begin;
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,draw_begin);
      for(bar=0; bar<=draw_begin; bar++)
         ExtLineBuffer[bar]=0;
     }
   else first=prev_calculated-1; //      

//----    CMoving_Average   MASeries_Cls.mqh
   static CMoving_Average MA;

//----    
   for(bar=first; bar<rates_total; bar++)
     {
      //----   .    MASeries.  
      //ExtLineBuffer[bar]=price[bar];
      ExtLineBuffer[bar]=MA.MASeries(begin,prev_calculated,rates_total,MAPeriod,MAMethod,price[bar],bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
