/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 *
 * This indicator is base on the algorithm of smoothing of the indicator 
 * JRSX.    The final result of this algorithm is slightly similar to 
 * the double JMA smoothing, but it's less perfect because of its simplicity.
 */

//+X================================================================X+ 
//|                                                        JJurX.mq4 | 
//|                           Copyright  2010,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing the indicator 1 as a line
#property indicator_type1   DRAW_LINE
//---- pink color is used for indicator line
#property indicator_color1 Gold
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "JJurX"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of price constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL
  PRICE_QUARTER_,       //PRICE_QUARTER
  PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0
  PRICE_TRENDFOLLOW1_   //PRICE_TRENDFOLLOW1
 };
input int JurX_Length  = 5; //depth of the JurX smoothing 
input int JJMA_Length  = 4; //depth of the JJMA smoothing 
input int  JJMA_Phase  = -100; //parameter of the first smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input  Applied_price_  IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // shifting the ma vertically in points
//+-----------------------------------+
//---- indicator buffers
double Ind_Buffer[];
//----
double dPriceShift;
//+X================================================================X+
// Description of the function iPriceSeries()                        |
// Description of the function iPriceSeriesAlert()                   |
// Description of the class JJMA                                     |
// Description of the class CJurX                                    |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+
//| JJurX indicator initialization function                          | 
//+X================================================================X+   
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, Ind_Buffer, INDICATOR_DATA);
  //---- shifting the indicator horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 30);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "JJurX");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE); 
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate
    (shortname, "JJurX( JurX_Length = ", JurX_Length,
                           ", JJMA_Length = ", JJMA_Length, ")");  
  //---- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //---- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
  CJJMA JMA;
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMALengthCheck("JJMA_Length", JJMA_Length);
  JMA.JJMALengthCheck("JurX_Length", JurX_Length);
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMAPhaseCheck("JJMA_Phase", JJMA_Phase);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
//----+ end of initialization
 }
//+X================================================================X+
//| JJurX iteration function                                         | 
//+X================================================================X+ 
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
 {
//----+   
  //---- Checking if there is enough bars for the calculation
  if (rates_total < 30)return(0);

  //---- Declaration of integer variables
  int first, bar;
  
  //---- declaration of variables with a floating point  
  double series, jurx, jjurx;
   
  if (prev_calculated == 0) // checking for the first start of the indicator calculation
       first = 0; // start number for calculation of all bars
  else first = prev_calculated - 1; // starting number for calculation of new bars
    
  //---- declaration of variable of the class JurX from the file JurXSeries_Cls.mqh
  static CJurX Jur;
  
  //---- declaration of variable of the class JJMA from the file JJMASeries_Cls.mqh
  static CJJMA JMA;
   
  //---- Main cycle of calculation of the indicator
  for(bar = first; bar < rates_total; bar++)
   {
    //----+ Call of the PriceSeries function to get the input price 'Series'
    series = PriceSeries(IPC, bar, open, low, high, close);
    
    //----+ One call of the function JurXSeries 
             // The parameter Length is not changed at every bar (Din = 0).  
    jurx = Jur.JurXSeries(0, prev_calculated, rates_total, 0, JurX_Length, series, bar, false);
  
    //----+ One call of the function JJMASeries
            // The parameter Phase and Length are not changed at every bar (Din = 0).  
    jjurx = JMA.JJMASeries(0, prev_calculated, rates_total, 0, JJMA_Phase, JJMA_Length, jurx, bar, false);
    
    //---- Initialization of a cell of the indicator buffer with the obtained value       
    Ind_Buffer[bar] = jjurx + dPriceShift;
   }
//----+     
  return(rates_total);
 }
//+X----------------------+ <<< The End >>> +-----------------------X+
