/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                         JJMA.mq5 | 
//|                               Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- pink color is used as the color of the bullish line of the indicator
#property indicator_color1 Red
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "JJMA"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int Length = 7; // depth of smoothing                   
input int Phase  = 100; // parameter of smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input Applied_price_ IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // vertical shift of the indicator in points
//+-----------------------------------+
//---- indicator buffer
double J1JMA[];

double dPriceShift;
//+X================================================================X+
// Description of the function iPriceSeries()                        |
// Description of the function iPriceSeriesAlert()                   |
// Description of the class CJJMA                                    |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+    
//| JJMA indicator initialization function                           | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, J1JMA, INDICATOR_DATA);
  //---- shifting the indicator horizontally by Shift
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 31);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "JJMA"); 
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "JJMA( Length = ", Length, ", Phase = ", Phase, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
  CJJMA JMA;
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMALengthCheck("Length", Length);
  JMA.JJMAPhaseCheck("Phase", Phase);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
//----+ end of initialization
 }
//+X================================================================X+  
//| JJMA iteration function                                          | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],    
                const double& high[],     // price array of maximums of price for the calculation of indicator
                const double& low[],      // price array of minimums of price for the calculation of indicator
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < 31)return(0);

   //---- Declaration of integer variables
   int first, bar;
   //---- declaration of variables with a floating point  
   double series, j1jma;
   
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    first = 0; // start number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of variable of the class JJMA from the file JJMASeries_Cls.mqh
   static CJJMA JMA;
   
   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Calling the function PriceSeries to get the input price 'Series'
     series = PriceSeries(IPC, bar, open, low, high, close);
  
     //----+ One call of the function JJMASeries. 
     //The parameters Phase and Length don't change at every bar (Din = 0) 
     j1jma = JMA.JJMASeries(0, prev_calculated, rates_total, 0, Phase, Length, series, bar, false);
     //----       
     J1JMA[bar] = j1jma + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
