/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                       J2JMA_.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- only one plot is used
#property indicator_plots   1
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- pink color is used for indicator line
#property indicator_color1 Magenta 
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "J2JMA"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int Length1 = 5; // depth of the first smoothing 
input int Length2 = 5; // depth of the second smoothing                    
input int Phase1  = 100; // parameter of the first smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input int Phase2  = 100;  // parameter of the second smoothing,
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input Applied_price_ IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
input int PriceShift = 0; // vertical shift of the indicator in points
//---+
//---- indicator buffers
double J2JMA[];

int start = 60;
double dPriceShift;
//+X================================================================X+
// Description of the class CJJMA                                    |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh> 
//+X================================================================X+    
//| J2JMA indicator initialization function                          | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, J2JMA, INDICATOR_DATA);
  //---- moving the indicator 1 horizontally
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, start + 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "J2JMA");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "J2JMA( Length1 = ", Length1, ", Length2 = ", Length2, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
  //---- declaration of variable of the class CJJMA from the file JJMASeries_Cls.mqh
  CJJMA JMA;
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMALengthCheck("Length1", Length1);
  JMA.JJMALengthCheck("Length2", Length2);
  //---- setting up alerts for unacceptable values of external variables
  JMA.JJMAPhaseCheck("Phase1", Phase1);
  JMA.JJMAPhaseCheck("Phase2", Phase2);
  //---- initialization of the vertical shift
  dPriceShift = _Point * PriceShift;
//----+ end of initialization
 }
//+X================================================================X+  
//| J2JMA iteration function                                         | 
//+X================================================================X+  
int OnCalculate
               (
                const int rates_total, // amount of history in bars at the current tick
                const int prev_calculated, // amount of history in bars at the previous tick
                const int begin, // number of beginning of bars for reliable calculation
                const double &price[] // price array for calculation of the indicator
               ) 
  {
//----+   
   start += begin;
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < start) return(0);
    
   //---- declaration of variables with a floating point  
   double j1jma, j2jma;
   //----+ declaration of integer variables and getting calculated bars
   int first, bar;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
        first = begin; // starting number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //----declaration of variables of the class CJJMA from the file JJMASeries_Cls.mqh
   static CJJMA JMA1, JMA2;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Two calls of the JJMASeries function. 
     //The parameters Phase and Length don't change at every bar (Din = 0)
     // The 'begin' parameter is increased by 30 in the second call , since it is the second JMA smoothing.  
     j1jma = JMA1.JJMASeries(begin, prev_calculated, rates_total, 0, Phase1, Length1, price[bar], bar, false);
     j2jma = JMA2.JJMASeries(begin + 30, prev_calculated, rates_total, 0, Phase2, Length2,      j1jma, bar, false);
     //----       
     J2JMA[bar] = j2jma + dPriceShift;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
