/*
 * For the indicator to work, place the files
 * SmoothAlgorithms.mqh
 * IndicatorsAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                       BBands.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 3 
//---- 3 plots are used
#property indicator_plots   3
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- purple color is used as the color of the indicator line
#property indicator_color1 DarkOrchid
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "Upper Bollinger"

//---- drawing of the indicator as a line
#property indicator_type2   DRAW_LINE
//---- purple color is used as the color of the indicator line
#property indicator_color2 DarkOrchid
//---- the indicator line is a continuous line
#property indicator_style2  STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width2  1
//---- displaying labels of the indicator
#property indicator_label2  "Middle Bollinger"

//---- drawing of the indicator as a line
#property indicator_type3   DRAW_LINE
//---- purple color is used as the color of the indicator line
#property indicator_color3 DarkOrchid
//---- the indicator line is a continuous line
#property indicator_style3  STYLE_DASHDOTDOT
//---- width of the indicator line is equal to 1
#property indicator_width3  1
//---- displaying labels of the indicator
#property indicator_label3  "Lower Bollinger"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
 {
  PRICE_CLOSE_ = 1,     //PRICE_CLOSE
  PRICE_OPEN_,          //PRICE_OPEN
  PRICE_HIGH_,          //PRICE_HIGH
  PRICE_LOW_,           //PRICE_LOW
  PRICE_MEDIAN_,        //PRICE_MEDIAN
  PRICE_TYPICAL_,       //PRICE_TYPICAL
  PRICE_WEIGHTED_,      //PRICE_WEIGHTED
  PRICE_SIMPL_,         //PRICE_SIMPL_
  PRICE_QUARTER_,       //PRICE_QUARTER_
  PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
  PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
 };
input int BandsPeriod = 20; //period of averaging
input double BandsDeviation = 2.0; //deviation 
input ENUM_MA_METHOD MA_Method = MODE_SMA; //method of averaging
input Applied_price_ IPC = PRICE_CLOSE_;//price constant
  /* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */ 
input int Shift = 0; // horizontal shift of the indicator in bars
//---+
//---- indicator buffers
double UpperBuffer[];
double MiddleBuffer[];
double LowerBuffer[];
//+X================================================================X+
// Description of the classes of averaging and indicators            |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh>
#include <IndicatorsAlgorithms.mqh> 
//+X================================================================X+    
//| BBands indicator initialization function                         | 
//+X================================================================X+  
void OnInit()
 {
//----+  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(0, UpperBuffer, INDICATOR_DATA);
  //---- shifting the indicator 1 horizontally by AroonShift
  PlotIndexSetInteger(0, PLOT_SHIFT, Shift);
  //---- shifting the start of drawing of the indicator 1
  PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(0, PLOT_LABEL, "Upper Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(1, MiddleBuffer, INDICATOR_DATA);
  //---- shifting the indicator 2 horizontally
  PlotIndexSetInteger(1, PLOT_SHIFT, Shift);
  //---- shifting the beginning of drawing of the indicator 2
  PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(1, PLOT_LABEL, "Middle Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(2, LowerBuffer, INDICATOR_DATA);
  //---- shifting the indicator 3 horizontally
  PlotIndexSetInteger(2, PLOT_SHIFT, Shift);
  //---- shifting the beginning of drawing of the indicator 3
  PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, BandsPeriod - 1);
  //--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(2, PLOT_LABEL, "Lower Bollinger");
  //---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);
  
  //---- initialization of a variable for a short name of the indicator
  string shortname;
  StringConcatenate(shortname, "BBands( BandsPeriod = ", BandsPeriod,
                               ", BandsDeviation = ", BandsDeviation, ")");  
  //--- creation of the name to be displayed in a separate sub-window and in a pop up help
  IndicatorSetString(INDICATOR_SHORTNAME, shortname);
  //--- determination of accuracy of displaying of the indicator values
  IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
//----+ end of initialization
 }
//+X================================================================X+  
//| BBands iteration function                                        | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime& time[],
                const double& open[],    
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[]
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < BandsPeriod) return(0);
    
   //---- declaration of variables with a floating point  
   double price_;
   //----+ declaration of integer variables and getting calculated bars
   int first, bar;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
        first = 0; // start number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- declaration of the classes Moving_Average and StdDeviation
   static CBBands BBands;
   
   //---- Main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //----+ Calling the function PriceSeries to get the input price 'Series'
     price_ = PriceSeries(IPC, bar, open, low, high, close);
     BBands.BBandsSeries(0, prev_calculated, rates_total,
                BandsPeriod, BandsDeviation, MA_Method, price_, bar, false,
                           LowerBuffer[bar], MiddleBuffer[bar], UpperBuffer[bar]);
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
