/*
 * For the indicator to work, place the file
 * SmoothAlgorithms.mqh
 * in the directory: MetaTrader\\MQL5\Include
 */
//+X================================================================X+ 
//|                                                 3c_JMomentum.mq5 | 
//|                             Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window 
//---- number of indicator buffers
#property indicator_buffers 4 
//---- only four plots are used
#property indicator_plots   4
//+-----------------------------------+
//|  parameters of indicator drawing  |
//+-----------------------------------+
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- use gray color for the indicator line
#property indicator_color1 Gray
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- the width of indicator line is 3
#property indicator_width1  1
//---- displaying labels of the indicator
#property indicator_label1  "JMomentum"

//+----------------------------------------------+
//| Parameters of drawing a bullish indicator    |
//+----------------------------------------------+
//---- drawing indicator as a symbol
#property indicator_type2   DRAW_ARROW
//---- color of the bullish indicator is light green
#property indicator_color2 SpringGreen
//---- the width of indicator line is 3
#property indicator_width2 3
//---- displaying of the bullish label of the indicator
#property indicator_label2 "Up_Signal"
//+----------------------------------------------+
//| Parameters of drawing a bearish indicator    |
//+----------------------------------------------+
//---- drawing indicator as a symbol
#property indicator_type3   DRAW_ARROW
//---- dark pink is used as the color of the bearish indicator
#property indicator_color3  DeepPink
//---- the width of indicator line is 3
#property indicator_width3 3
//---- displaying of the bearish label of the indicator
#property indicator_label3 "Dn_Signal"
//+----------------------------------------------+
//| Parameters of drawing a non-trend indicator  |
//+----------------------------------------------+
//---- drawing indicator as a symbol
#property indicator_type4   DRAW_ARROW
//---- gray color is used for the non-trend indicator
#property indicator_color4  Gray
//---- the width of indicator line is 3
#property indicator_width4 3
//---- displaying of the non-trend label of the indicator
#property indicator_label4 "No_Signal"
//+-----------------------------------+
//|  Input parameters of the indicator|
//+-----------------------------------+
enum Applied_price_ //Type of constant
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
input int Length=8; // depth of smoothing 
input int JLength = 8; // depth of the JMA smoothing of the indicator Momentum                  
input int JPhase  = 100; // parameter of the JMA smoothing
                                 //that changes within the range -100 ... +100
                                           //depends of the quality of the transitional prices;
input Applied_price_ IPC=PRICE_CLOSE_;//price constant
/* , used for calculation of the indicator ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; // horizontal shift of the indicator in bars
//---+
//---- indicator buffers
double JMomentum[];
double UpBuffer[];
double DnBuffer[];
double FlBuffer[];

int start;
//+X================================================================X+
// Description of the function iPriceSeries                          |
// Description of the function iPriceSeriesAlert                     |
// Description of the class CMomentum                                |
//+X================================================================X+ 
#include <SmoothAlgorithms.mqh>  
//+X================================================================X+    
//| JMomentum indicator initialization function                      | 
//+X================================================================X+  
void OnInit()
  {
//----+ 
   start = Length+31; 
//---- turning a dynamic array into an indicator buffer
   SetIndexBuffer(0,JMomentum,INDICATOR_DATA);
//---- shifting the indicator horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,Length);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0,PLOT_LABEL,"JMomentum");
//---- setting values of the indicator that won't be visible on the chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(1, UpBuffer, INDICATOR_DATA);
//---- moving the indicator 1 horizontally
  PlotIndexSetInteger(1, PLOT_SHIFT, Shift);
//---- performing the shift of beginning of indicator drawing
  PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, start);
//--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(1, PLOT_LABEL, "Up Signal");
//---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
//--- selecting symbol for drawing
  PlotIndexSetInteger(1, PLOT_ARROW, 159);
  
//---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(2, DnBuffer, INDICATOR_DATA);
//---- moving the indicator 1 horizontally
  PlotIndexSetInteger(2, PLOT_SHIFT, Shift);
//---- shifting the start of drawing of the indicator 1
  PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, start);
//--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(2, PLOT_LABEL, "Dn Signal");
//---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);
//--- selecting symbol for drawing
  PlotIndexSetInteger(2, PLOT_ARROW, 159);

//---- turning a dynamic array into an indicator buffer
  SetIndexBuffer(3, FlBuffer, INDICATOR_DATA);
//---- moving the indicator 1 horizontally
  PlotIndexSetInteger(3, PLOT_SHIFT, Shift);
//---- shifting the start of drawing of the indicator 1
  PlotIndexSetInteger(3, PLOT_DRAW_BEGIN, start);
//--- creation of a label to be displayed in the Data Window
  PlotIndexSetString(3, PLOT_LABEL, "No Signal");
//---- setting values of the indicator that won't be visible on the chart
  PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, EMPTY_VALUE);
//--- selecting symbol for drawing
  PlotIndexSetInteger(3, PLOT_ARROW, 159);  
   
//---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname,"JMomentum( Length = ",Length,")");
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---- declaration of the variable of the class CMomentum from the file SmoothAlgorithms.mqh
   CMomentum Mom;
//---- declaration of the variable of the class CJJMA from the file SmoothAlgorithms.mqh
   CJJMA JMA;
//---- setting up alerts for unacceptable values of external variables
   Mom.MALengthCheck("Length", Length);
//---- setting up alerts for unacceptable values of external variables
   JMA.JJMALengthCheck("JLength", JLength);
//---- setting up alerts for unacceptable values of external variables
   JMA.JJMAPhaseCheck("JPhase", JPhase);
//----+ end of initialization
  }
//+X================================================================X+  
//| JMomentum iteration function                                     | 
//+X================================================================X+  
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----+   
//---- checking the number of bars to be enough for the calculation
   if(rates_total < start) return(0);

//---- declaration of variables with a floating point  
   double price, momentum, jmomentum, dmomentum;
//----+ declaration of integer variables and getting calculated bars
   int first, bar;

//---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if(prev_calculated == 0) // checking if it's the first start of calculation of the indicator
      first = 0; // start number for calculation of all bars
   else first = prev_calculated - 1; // starting number for calculation of new bars

//---- declaration of variables of the classes CMomentum and CJJMA from the file SmoothAlgorithms.mqh
   static CMomentum Mom;
   static CJJMA JMA;

//---- Main cycle of calculation of the indicator
   for(bar=first; bar<rates_total; bar++)
     {
      //----+ Call of the function PriceSeries to get incrementation of the input price dprice_
      price = PriceSeries(IPC, bar, open, low, high, close);

      //----+ Two calls of the function MomentumSeries.  
      momentum = Mom.MomentumSeries(0, prev_calculated, rates_total, Length, price, bar, false);
      
      //----+ One call of the function JJMASeries. 
      //The parameters Phase and Length don't change at every bar (Din = 0) 
      jmomentum = JMA.JJMASeries(Length+1, prev_calculated, rates_total, 0, JPhase, JLength, momentum, bar, false);

      //---- Loading the obtained value in the indicator buffer
      JMomentum[bar] = jmomentum / _Point;
       
      //---- initialization of cells of indicator buffers with zeros
      UpBuffer[bar] = EMPTY_VALUE;
      DnBuffer[bar] = EMPTY_VALUE;
      FlBuffer[bar] = EMPTY_VALUE;
      
      if (bar < start) continue;
      //---- initialization of cells of the indicator buffers with obtained values 
      dmomentum = NormalizeDouble(JMomentum[bar] - JMomentum[bar-1],0);
      if (dmomentum>0) UpBuffer[bar] = JMomentum[bar]; //there is an ascending trend
      if (dmomentum<0) DnBuffer[bar] = JMomentum[bar]; //there is a descending trend
      if (dmomentum==0) FlBuffer[bar] = JMomentum[bar]; //not trend
     }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
