//+------------------------------------------------------------------+
//|                                                      h_TS_BW.mqh |
//|                                                         olyakish |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "olyakish"
#property link      "http://www.mql5.com"

#include <Trade\Trade.mqh>
#include <Trade\SymbolInfo.mqh>
#include <Trade\PositionInfo.mqh>
#include<Trade\HistoryOrderInfo.mqh>
// enumeration, used for trailing stop methods
enum type_support_position
  {
   Not_used=-1,               // trailing stop is not used
   Trailing_On_Lips=0,        // trailing stop using the Lips line
   Trailing_On_Teeth=1,       // trailing stop using the Teeth line
   Trailing_On_Jaws=2,        // trailing stop using the Jaws line
   Close_On_Lips=3,           // close position if close price outside the Lips line
   Close_On_Teeth=4,          // close position if close price outside the Teeth line
   Close_On_Jaw=5,            // close position if close price outside the Jaw line
   Close_Out_Alligator=6      // lose position if close price outside the Alligator
  };
//+------------------------------------------------------------------+
//| C_TS_BW class description                                        |
//+------------------------------------------------------------------+

class C_TS_BW
  {
private:
   datetime          time[1];                                  // time
   datetime          last_time[1];                             // last call time (used to detemine if a new bar has appeared)
   int               h_alligator,h_fractals,h_ao,h_ac;         // handles
   string            m_Symbol;                                 // symbol
   ENUM_TIMEFRAMES   m_Period;                                 // period
   CTrade            exp_trade;                                // CTrade class instance
   CSymbolInfo       s_info;                                   // CSymbolInfo class instance
   CPositionInfo     pos_info;                                 // CPositionInfo class instance
   CHistoryOrderInfo h_info;                                   // CHistoryOrderInfo class instance
   bool              FindSignal_1_dimension(int type,double&price_out[],datetime &time_out[]);               // search signals of the 1st dimension
   bool              FindSignal_2_dimension(int type,int sub_type,double&price_out[],datetime &time_out[]);  // search signals of the 2nd dimension
   bool              FindSignal_3_dimension(int type,int sub_type,double&price_out[],datetime &time_out[]);  // search signals of the 3rd dimension
   bool              FindSignal_4_dimension(int type,int sub_type,double&price_out[],datetime &time_out[]);  // search signals of the 4th dimension
   bool              FindSignal_5_dimension(int type,int sub_type,double&price_out[],datetime &time_out[]);  // search signals of the 5th dimension
   bool              CheckForTradeSignal(int dimension,int type,int sub_type,double&price_out[],datetime &time_out[]);  // check trade signals
   bool              SendOrder(ENUM_ORDER_TYPE type,double&price_out[],datetime &time_out[],string comment); // send order
   bool              CopyIndValue(int type,int countValue);
   ulong             CalcMagic(ulong  &magic);                   // calc magic for new order
   double            High[],Low[],Close[],AO_color[],AO_value[],AC_color[],AC_value[];    // arrays
   double            lips[],teeth[],jaw[];                       // arrays, used for Alligator lines
   double            Lot;                                        // Trade volume
   double            StopLoss;                                   // Stop Loss price
   ulong             Magic;                                      // Magic

   struct l_signals     // structure, used for trade signals
     {
      double            fractal_up[1];    // price of the last actual "Fractal Up" signal (Fractals indicator)
      double            fractal_dn[1];    // price of the last actual "Fractal Down" signal (Fractals indicator)
      double            bludce_up[1];     // price of the last actual "Saucer" buy signal ( indicator)
      double            bludce_dn[1];     // price of the last actual "Saucer" sell signal ( indicator)
      double            cross_zero_up[1]; // price of the last actual "Zero line crossover" buy signal ( indicator)
      double            cross_zero_dn[1]; // price of the last actual "Zero line crossover" sell signal ( indicator)
      double            ac_2_bars_up[1];  // price of the last actual "AC 2 bars up" buy signal ( indicator)
      double            ac_2_bars_dn[1];  // price of the last actual "AC 2 bars down" sell signal ( indicator)
      double            ac_3_bars_up[1];  // price of the last actual "AC 3 bars up" buy signal ( indicator)
      double            ac_3_bars_dn[1];  // price of the last actual "AC 3 bars down" sell signal ( indicator)
      double            zone_up[1];       // price of the last actual "Green Zone" buy signal (Close price, /AO indicators)
      double            zone_dn[1];       // price of the last actual "Red Zone" sell signal (Close price, /AO indicators)
      double            zone_5_trall_green[1]; // price of the last actual "trail position 5 bars in green zone" signal for long position (AO and AC)
      double            zone_5_trall_red[1];   // price of the last actual "trail position 5 bars in red zone" signal for long position (AO and AC)
      double            five_dimension_2_bars_up[1]; // price of the last actual "2 bars up" buy signal (Alligator, High price)
      double            five_dimension_3_bars_up[1]; // price of the last actual "3 bars up" buy signal (Alligator, High price)
      double            five_dimension_2_bars_dn[1]; // price of the last actual "2 bars down" sell signal (Alligator, Low price)
      double            five_dimension_3_bars_dn[1]; // price of the last actual "3 bars down" sell signal (Alligator, Low price)
      bool              alligator_trend[2];          // trend, determined using the values of the Alligator indicator (at the 0th bar)

      datetime          fractal_up_time[1];    // time of the last actual "Fractal Up" buy signal (Fractals indicator)
      datetime          fractal_dn_time[1];    // time of the last actual "Fractal Down" sell signal (Fractals indicator)
      datetime          bludce_up_time[1];     // time of the last actual "Saucer" buy signal (AO indicator)
      datetime          bludce_dn_time[1];     // time of the last actual "Saucer" sell signal (AO indicator)
      datetime          cross_zero_up_time[1]; // time of the last actual "Zero line crossover" buy signal (AO indicator)
      datetime          cross_zero_dn_time[1]; // time of the last actual "Zero line crossover" sell signal (AO indicator)
      datetime          ac_2_bars_up_time[1];  // time of the last actual "AC 2 bars up" buy signal (AC indicator)
      datetime          ac_2_bars_dn_time[1];  // time of the last actual "AC 2 bars down" sell signal (AC indicator)
      datetime          ac_3_bars_up_time[1];  // time of the last actual "AC 3 bars up" buy signal (AC indicator)
      datetime          ac_3_bars_dn_time[1];  // time of the last actual "AC 3 bars down" sell signal (AC indicator)
      datetime          zone_up_time[1];       // time of the last actual "Green Zone" buy signal (AO, AC indicators, Close price)
      datetime          zone_dn_time[1];       // time of the last actual "Red Zone" sell signal (AO, AC indicators, Close price)
      datetime          five_dimension_2_bars_up_time[1]; // time of the last actual "2 bars up" buy signal (AO, AC indicators)
      datetime          five_dimension_3_bars_up_time[1]; // time of the last actual "3 bars up" buy signal (AO, AC indicators)
      datetime          five_dimension_2_bars_dn_time[1]; // time of the last actual "2 bars down" sell signal (AO, AC indicators)
      datetime          five_dimension_3_bars_dn_time[1]; // time of the last actual "3 bars down" sell signal (AO, AC indicators)
      
      void              l_signals_clear(ENUM_POSITION_TYPE type) // clear signals depending on position type
        {
         alligator_trend[0]=false;
         alligator_trend[1]=false;
         if(type==POSITION_TYPE_BUY)
           {
            fractal_up[0]=-1;
            bludce_up[0]=-1;
            cross_zero_up[0]=-1;
            ac_2_bars_up[0]=-1;
            ac_3_bars_up[0]=-1;
            zone_up[0]=-1;
            zone_5_trall_green[0]=-1;
            five_dimension_2_bars_up[0]=-1;
            five_dimension_3_bars_up[0]=-1;

            fractal_up_time[0]=-1;
            bludce_up_time[0]=-1;
            cross_zero_up_time[0]=-1;
            ac_2_bars_up_time[0]=-1;
            ac_3_bars_up_time[0]=-1;
            zone_up_time[0]=-1;
            five_dimension_2_bars_up_time[0]=-1;
            five_dimension_3_bars_up_time[0]=-1;
           }
         if(type==POSITION_TYPE_SELL)
           {
            fractal_dn[0]=-1;
            bludce_dn[0]=-1;
            cross_zero_dn[0]=-1;
            ac_2_bars_dn[0]=-1;
            ac_3_bars_dn[0]=-1;
            zone_dn[0]=-1;
            zone_5_trall_red[0]=-1;
            five_dimension_2_bars_dn[0]=-1;
            five_dimension_3_bars_dn[0]=-1;

            fractal_dn_time[0]=-1;
            bludce_dn_time[0]=-1;
            cross_zero_dn_time[0]=-1;
            ac_2_bars_dn_time[0]=-1;
            ac_3_bars_dn_time[0]=-1;
            zone_dn_time[0]=-1;
            five_dimension_2_bars_dn_time[0]=-1;
            five_dimension_3_bars_dn_time[0]=-1;
           }
        }
     };
   l_signals         last_signals;
   // structure, used to serve the times of the last triggered signals
   struct l_trade
     {
      datetime          fractal_up;
      datetime          fractal_dn;
      datetime          ao_blydce;
      datetime          ao_cross_zero;
      datetime          ac_2_bars;
      datetime          ac_3_bars;
      datetime          zone;
      datetime          five_dimension;
     };
   l_trade           last_trade;

   struct            s_input_parametrs               // structure, used for input parameters
     {
      double            lot;                         // trade volume
      type_support_position support_position;        // trailing stop type
      int               alligator_jaw_period;        // period of Jaw line of the Alligator
      int               alligator_jaw_shift;         // shift of Jaw line of the Alligator
      int               alligator_teeth_period;      // period of Teeth line of the Alligator
      int               alligator_teeth_shift;       // shift of Teeth line of the Alligator
      int               alligator_lips_period;       // period of Lips line of the Alligator
      int               alligator_lips_shift;        // shift of Lips line of the Alligator
      int               max_4_dimension_zone;        // max bars in zone
      bool              add_1_dimension;             // add to position when Fractal signals (1st dimension)
      bool              add_2_dimension_bludce;      // add to position when "Saucer" signals (AO)
      bool              add_2_dimension_cross_zero;  // add to position when "Zero line crossover" signals (AO)
      bool              add_3_dimension_use_2_bars;  // add to position when "AC 2 bars up/down" signals (AC)
      bool              add_3_dimension_use_3_bars;  // add to position when "AC 3 bars up/down" signals (AC)
      bool              add_4_dimension_zone;        // add to postition when "Green/Red zone" signals
      bool              add_5_dimension;             // add to postion when Balance line signals
      bool              trall_4_dimension;           // trailing stop when 5 bars with the same color
      bool              agress_trade_mm;             // agressive method of addition to the opened position
     };
   s_input_parametrs inp_param;                      // input parameters

public:
   void              C_TS_BW();        // class constuctor

   s_input_parametrs inp_param_tmp;    // structure for input parameters

   struct s_actual_action
     {
      bool              fractal_open_buy;
      bool              fractal_add_buy;
      bool              fractal_revers_buy_to_sell;
      bool              fractal_open_sell;
      bool              fractal_add_sell;
      bool              fractal_revers_sell_to_buy;
      bool              ao_bludce_buy;
      bool              ao_bludce_sell;
      bool              ao_cross_zero_buy;
      bool              ao_cross_zero_sell;
      bool              ac_2_bar_buy;
      bool              ac_2_bar_sell;
      bool              ac_3_bar_buy;
      bool              ac_3_bar_sell;
      bool              zone_buy;
      bool              zone_sell;
      bool              line_balance_2_bar_buy;
      bool              line_balance_2_bar_sell;
      bool              line_balance_3_bar_buy;
      bool              line_balance_3_bar_sell;
      bool              position_close;
      void              init()
        {
         fractal_open_buy=false;
         fractal_add_buy=false;
         fractal_revers_buy_to_sell=false;
         fractal_open_sell=false;
         fractal_add_sell=false;
         fractal_revers_sell_to_buy=false;
         ao_bludce_buy=false;
         ao_bludce_sell=false;
         ao_cross_zero_buy=false;
         ao_cross_zero_sell=false;
         ac_2_bar_buy=false;
         ac_2_bar_sell=false;
         ac_2_bar_buy=false;
         ac_3_bar_sell=false;
         zone_buy=false;
         zone_sell=false;
         line_balance_2_bar_buy=false;
         line_balance_2_bar_sell=false;
         line_balance_3_bar_buy=false;
         line_balance_3_bar_sell=false;
         position_close=false;
        }
     };
   s_actual_action   actual_action;
   bool              Init(string Symbol_for_trade,ENUM_TIMEFRAMES Period_for_trade,s_input_parametrs  &inp_param_tmp); // class initialization
   bool              NewBar();              // checking of a new bar on the current symbol/timeframe
   void              CheckSignal();         // check signal
   void              CheckActionOnTick();   // check actions on the current tick
   void              TrailingStop();        // trailing stop
   void              TradeActualSignals();  // trade according actual trade signals
   void              SetStopLoss(double  &stoploss);  // external set of stop loss                                                 
   void              CalcLot(bool external,double ext_lot,int type); // Lot calculation 
                                                                     // (if !external, the ext_lot trade volume will be used)

  };
//+------------------------------------------------------------------+ 

C_TS_BW::C_TS_BW(void)
  {
  }
//+------------------------------------------------------------------+
//| Class initialization method                                      |
//|       Symbol_for_trade - symbol                                  |
//|       Period_for_trade - timeframe                               |
//| Returns false if error (reinitialization is required)            |
//+------------------------------------------------------------------+
bool C_TS_BW::Init(string Symbol_for_trade,ENUM_TIMEFRAMES Period_for_trade,s_input_parametrs  &inp_param_tmp)
  {
   inp_param=inp_param_tmp;
   time[0]=-1;                  // time
   last_time[0]=-2;
   m_Symbol=Symbol_for_trade;
   m_Period=Period_for_trade;
   Lot=inp_param.lot;
   StopLoss=-1;
   Magic=-1;
// handles
   h_alligator=iAlligator(m_Symbol,m_Period,inp_param.alligator_jaw_period,0,inp_param.alligator_teeth_period,0,inp_param.alligator_lips_period,0,MODE_SMMA,PRICE_MEDIAN);
   if(h_alligator==INVALID_HANDLE){return(false);}
   h_fractals=iFractals(m_Symbol,m_Period);
   if(h_fractals==INVALID_HANDLE){return(false);}
   h_ao=iAO(m_Symbol,m_Period);
   if(h_ao==INVALID_HANDLE){return(false);}
   h_ac=iAC(m_Symbol,m_Period);
   if(h_ac==INVALID_HANDLE){return(false);}
// set indexing as timeseries
   ArraySetAsSeries(AO_color,true);
   ArraySetAsSeries(AO_value,true);
   ArraySetAsSeries(AC_color,true);
   ArraySetAsSeries(AC_value,true);
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
   ArraySetAsSeries(Close,true);
   ArraySetAsSeries(lips,true);
   ArraySetAsSeries(teeth,true);
   ArraySetAsSeries(jaw,true);
// initialize classes
   s_info.Name(m_Symbol);       // set symbol
   s_info.Refresh();            // refresh
   return(true);
  }
//+------------------------------------------------------------------+
//|  New bar                                                         |
//+------------------------------------------------------------------+
bool C_TS_BW::NewBar(void)
  {
   int copy=-1;
   copy=CopyTime(m_Symbol,m_Period,0,1,time);
   if(copy>0 && time[0]>last_time[0])
     {
      last_time[0]=time[0];
      return(true);
     }
   else
     {return(false);}
  }
//+------------------------------------------------------------------+
//|  Check trade signals from 5 dimensions                           |
//+------------------------------------------------------------------+
void C_TS_BW::CheckSignal(void)
  {
   CopyClose(m_Symbol,m_Period,0,3,Close);
   datetime tmp_timer[1];
   last_signals.alligator_trend[0]=false;
   last_signals.alligator_trend[1]=false;
   CopyIndValue(0,2);   // get the values of the Alligator (the 0th bar)
   CopyIndValue(2,10);  // get the values of 
   CopyIndValue(3,10);  // get the values of 

   bool select_pos=pos_info.Select(m_Symbol);
   if(select_pos)
     {
      switch(inp_param.support_position)
        {
         case 3:        //Close_On_Lips=3,       // Close position if close price outside the Lips line of the Alligator
           {
            if(((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && Close[1]<lips[1]) ||
               ((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && Close[1]>lips[1]))
              {actual_action.position_close=true;}
            break;
           }
         case 4:        //Close_On_Teeth=4,       // Close position if close price outside the Teeth line of the Alligator
           {
            if(((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && Close[1]<teeth[1]) ||
               ((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && Close[1]>teeth[1]))
              {actual_action.position_close=true;}
            break;
           }
         case 5:        //Close_On_Jaw=5          // Close position if close price outside the Jaws line of the Alligator
           {
            if(((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && Close[1]<jaw[1]) ||
               ((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && Close[1]>jaw[1]))
              {actual_action.position_close=true;}
            break;
           }
         case 6:        //Close_Out_Alligator=6            
           {
            if(((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && Close[1]<MathMin(jaw[1],MathMin(lips[1],teeth[1]))) ||
               ((ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && Close[1]>MathMax(jaw[1],MathMax(lips[1],teeth[1]))))
              {actual_action.position_close=true;}
            break;
           }           
        }
     }

   last_signals.l_signals_clear(POSITION_TYPE_BUY);
   last_signals.l_signals_clear(POSITION_TYPE_SELL);
//--- determine trend
   if(lips[0]>teeth[0] && teeth[0]>jaw[0]){last_signals.alligator_trend[0]=true;}
   if(lips[0]<teeth[0] && teeth[0]<jaw[0]){last_signals.alligator_trend[1]=true;}   
   FindSignal_1_dimension(0,last_signals.fractal_up,last_signals.fractal_up_time);  // find Fractal Up
   FindSignal_1_dimension(1,last_signals.fractal_dn,last_signals.fractal_dn_time);  // find Fractal Down
   if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && last_signals.alligator_trend[0])
     {
      FindSignal_2_dimension(0,0,last_signals.cross_zero_up,last_signals.cross_zero_up_time);  // check "Zero line crossover" buy signal
      FindSignal_2_dimension(0,1,last_signals.bludce_up,last_signals.bludce_up_time);          // check "Saucer" buy signal (AO)
      FindSignal_3_dimension(0,0,last_signals.ac_2_bars_up,last_signals.ac_2_bars_up_time);    // check "AC 2 bars up" buy signal
      FindSignal_3_dimension(0,1,last_signals.ac_3_bars_up,last_signals.ac_3_bars_up_time);    // check "AC 3 bars up" buy signal
      FindSignal_4_dimension(0,0,last_signals.zone_up,last_signals.zone_up_time);              // check "Green zone" buy signal
      FindSignal_4_dimension(0,1,last_signals.zone_5_trall_green,tmp_timer);                   // find "5 bars trailing stop" price
      FindSignal_4_dimension(0,2,last_signals.zone_up,last_signals.zone_up_time);              // check zones
      FindSignal_5_dimension(0,0,last_signals.five_dimension_2_bars_up,last_signals.five_dimension_2_bars_up_time);  // check "2 bars up" buy signal
      FindSignal_5_dimension(0,1,last_signals.five_dimension_3_bars_up,last_signals.five_dimension_3_bars_up_time);  // check "3 bars up" buy signal
     }
   if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && last_signals.alligator_trend[1])
     {
      FindSignal_2_dimension(1,0,last_signals.cross_zero_dn,last_signals.cross_zero_dn_time);  // check "Zero line crossover" sell signal
      FindSignal_2_dimension(1,1,last_signals.bludce_dn,last_signals.bludce_dn_time);          // check "Saucer" sell signal
      FindSignal_3_dimension(1,0,last_signals.ac_2_bars_dn,last_signals.ac_2_bars_dn_time);    // check "AC 2 bars down" sell signal
      FindSignal_3_dimension(1,1,last_signals.ac_3_bars_dn,last_signals.ac_3_bars_dn_time);    // check "AC 3 bars down" sell signal
      FindSignal_4_dimension(1,0,last_signals.zone_dn,last_signals.zone_dn_time);              // check "Red zone" sell signal
      FindSignal_4_dimension(1,1,last_signals.zone_5_trall_red,tmp_timer);                     // find "5 bars" trailing stop" price
      FindSignal_4_dimension(1,2,last_signals.zone_dn,last_signals.zone_dn_time);              // check zones
      FindSignal_5_dimension(1,0,last_signals.five_dimension_2_bars_dn,last_signals.five_dimension_2_bars_dn_time);  // check "2 bars down" sell signal
      FindSignal_5_dimension(1,1,last_signals.five_dimension_3_bars_dn,last_signals.five_dimension_3_bars_dn_time);  // check "3 bars down" sell signal
     }
  }
//+------------------------------------------------------------------+
//| Trailing Stop                                                    |
//+------------------------------------------------------------------+
void C_TS_BW::TrailingStop(void)
  {
   bool select=pos_info.Select(m_Symbol);
   if(select && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY
      && last_signals.zone_5_trall_green[0]>0 && inp_param.trall_4_dimension)
     {StopLoss=last_signals.zone_5_trall_green[0];}
   if(select && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL
      && last_signals.zone_5_trall_red[0]>0 && inp_param.trall_4_dimension)
     {StopLoss=last_signals.zone_5_trall_red[0];}
   if(select && StopLoss<0)
     {
      switch(inp_param.support_position)
        {
         case -1:       // Not_used=-1,              // Trailing not used
           {break;}
         case 0:        // Trailing_On_Lips=0,       // Trailing on Lips
           {StopLoss=lips[0];break;}
         case 1:        // Trailing_On_Teeth=1,      // Trailing on Teeth
           {StopLoss=teeth[0];break;}
         case 2:        // Trailing_On_Jaws=2,       // Trailing on Jaws
           {StopLoss=jaw[0];break;}
        }
     }

//---
   if(StopLoss>0 && 
      ((pos_info.StopLoss()+s_info.Point()<StopLoss && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && StopLoss<Close[0]-(s_info.StopsLevel()+s_info.Spread()*2)*s_info.Point()) || // check the possibility of the minimum stop change
      (((pos_info.StopLoss()-s_info.Point()>StopLoss && pos_info.StopLoss()>0) || (pos_info.StopLoss()<s_info.Point()*5)) && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && StopLoss>Close[0]+(s_info.StopsLevel()+s_info.Spread()*2)*s_info.Point()))) // check the possibility of the minimum stop change
     {
      //MathSrand((int)TimeCurrent());
      //string nameojb="stop"+(string) MathRand();
      //ResetLastError();
      //datetime t1[1];
      //CopyTime(m_Symbol,m_Period,0,1,t1);
      //bool draw=ObjectCreate(0,nameojb,OBJ_ARROW_STOP,0,t1[0],StopLoss);
      //Print(nameojb," ",(string)draw,GetLastError());

      if(exp_trade.PositionModify(m_Symbol,NormalizeDouble(StopLoss,s_info.Digits()),pos_info.TakeProfit()))
        {StopLoss=-1.0;}
     }

   StopLoss=-1.0;

  }
//+------------------------------------------------------------------+
//| Trade actuals signal                                             |
//+------------------------------------------------------------------+
void C_TS_BW::TradeActualSignals(void)
  {
   s_info.Refresh();            // refresh
   if(actual_action.position_close)
     {
      if(exp_trade.PositionClose(m_Symbol,-1))
        {actual_action.position_close=false;}
     }
   if(actual_action.fractal_open_buy ||
      actual_action.fractal_add_buy || 
      actual_action.fractal_revers_sell_to_buy) // Fractal Up - buy
     {
      if(Lot<0 && actual_action.fractal_open_buy){last_signals.zone_5_trall_green[0]=-1;} // no position - use initial lot
                                                                                          // if(Lot<0 && actual_action.fractal_add_buy){} 
      if(Lot<0 && actual_action.fractal_revers_sell_to_buy){last_signals.zone_5_trall_green[0]=-1;} // position opened: reverse
                                                                                                    // if(Lot>0)
        {
         last_trade.fractal_up=last_signals.fractal_up_time[0];
         if(SendOrder(ORDER_TYPE_BUY,last_signals.fractal_up,last_signals.fractal_up_time,"TC_BW_fr_"+TimeToString(last_signals.fractal_up_time[0])))
           {
            actual_action.fractal_open_buy=false;
            actual_action.fractal_add_buy=false;
            actual_action.fractal_revers_sell_to_buy=false;
            return;
           }
        }
     }
   if(actual_action.fractal_open_sell ||
      actual_action.fractal_add_sell ||
      actual_action.fractal_revers_buy_to_sell) // Fractal Down - sell
     {
      if(Lot<0 && actual_action.fractal_open_sell){last_signals.zone_5_trall_red[0]=-1;} // no position - use initial lot
                                                                                         //if(Lot<0 && actual_action.fractal_add_sell){} // sell opened - add to position
      if(Lot<0 && actual_action.fractal_revers_buy_to_sell){last_signals.zone_5_trall_red[0]=-1;} // position opened - reverse
                                                                                                  //if(Lot>0)
        {
         last_trade.fractal_dn=last_signals.fractal_dn_time[0];
         if(SendOrder(ORDER_TYPE_SELL,last_signals.fractal_dn,last_signals.fractal_dn_time,"TC_BW_fr"+TimeToString(last_signals.fractal_dn_time[0])))
           {
            actual_action.fractal_open_sell=false;
            actual_action.fractal_add_sell=false;
            actual_action.fractal_revers_buy_to_sell=false;
            return;
           }
        }
     }

//---add to position
//--- saucer buy signal
   if(actual_action.ao_bludce_buy) // send buy order
     {
      last_trade.ao_blydce=last_signals.bludce_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.bludce_up,last_signals.bludce_up_time,"TC_BW_bl_"+TimeToString(last_signals.bludce_up_time[0])))
        {actual_action.ao_bludce_buy=false;return;}
     }
//--- Zero line crossover
   if(actual_action.ao_cross_zero_buy) // send buy order
     {
      last_trade.ao_cross_zero=last_signals.cross_zero_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.cross_zero_up,last_signals.cross_zero_up_time,"TC_BW_cz_"+TimeToString(last_signals.cross_zero_up_time[0])))
        {actual_action.ao_cross_zero_buy=false;return;}
     }
//--- "AC 2 bars" buy signal
   if(actual_action.ac_2_bar_buy) // send buy order (2 green bars of AC)
     {
      last_trade.ac_2_bars=last_signals.ac_2_bars_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.ac_2_bars_up,last_signals.ac_2_bars_up_time,"TC_BW_2g_"+TimeToString(last_signals.ac_2_bars_up_time[0])))
        {actual_action.ac_2_bar_buy=false;return;}
     }
//--- "AC 3 bars" buy signal
   if(actual_action.ac_3_bar_buy) // send buy order (3 green bars of AC)
     {
      last_trade.ac_3_bars=last_signals.ac_3_bars_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.ac_3_bars_up,last_signals.ac_3_bars_up_time,"TC_BW_3g_"+TimeToString(last_signals.ac_3_bars_up_time[0])))
        {actual_action.ac_3_bar_buy=false;return;}
     }
//--- Green zone
   if(actual_action.zone_buy) // send buy order (Green zone)
     {
      last_trade.zone=last_signals.zone_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.zone_up,last_signals.zone_up_time,"TC_BW_z_"+TimeToString(last_signals.zone_up_time[0])))
        {actual_action.zone_buy=false;return;}
     }
//--- 2 bars up
   if(actual_action.line_balance_2_bar_buy) // send buy order
     {
      last_trade.five_dimension=last_signals.five_dimension_2_bars_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.five_dimension_2_bars_up,last_signals.five_dimension_2_bars_up_time,"BW_lb2_"+TimeToString(last_signals.five_dimension_2_bars_up_time[0])+DoubleToString(last_signals.five_dimension_2_bars_up[0],5)))
        { actual_action.line_balance_2_bar_buy=false;return;}
     }
//--- 3 bars up
   if(actual_action.line_balance_3_bar_buy) // send buy order
     {
      last_trade.five_dimension=last_signals.five_dimension_3_bars_up_time[0];
      if(SendOrder(ORDER_TYPE_BUY,last_signals.five_dimension_3_bars_up,last_signals.five_dimension_3_bars_up_time,"BW_lb3_"+TimeToString(last_signals.five_dimension_3_bars_up_time[0])+DoubleToString(last_signals.five_dimension_3_bars_up[0],5)))
        {actual_action.line_balance_3_bar_buy=false;return;}
     }

//---
//---
   if(actual_action.ao_bludce_sell) // AO Saucer sell signal
     {
      last_trade.ao_blydce=last_signals.bludce_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.bludce_dn,last_signals.bludce_dn_time,"TC_BW_bl_"+TimeToString(last_signals.bludce_dn_time[0])))
        {actual_action.ao_bludce_sell=false;return;}
     }
   if(actual_action.ao_cross_zero_sell) // AO zero line crossover
     {
      last_trade.ao_cross_zero=last_signals.cross_zero_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.cross_zero_dn,last_signals.cross_zero_dn_time,"TC_BW_cz_"+TimeToString(last_signals.cross_zero_dn_time[0])))
        {actual_action.ao_cross_zero_sell=false;return;}
     }
//--- AC 2 bars down (red)
   if(actual_action.ac_2_bar_sell) // send sell order
     {
      last_trade.ac_2_bars=last_signals.ac_2_bars_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.ac_2_bars_dn,last_signals.ac_2_bars_dn_time,"TC_BW_2g_"+TimeToString(last_signals.ac_2_bars_dn_time[0])))
        {actual_action.ac_2_bar_sell=false;return;}
     }
//--- AC 3 bars down (red)
   if(actual_action.ac_3_bar_sell) // send sell order
     {
      last_trade.ac_3_bars=last_signals.ac_3_bars_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.ac_3_bars_dn,last_signals.ac_3_bars_dn_time,"TC_BW_3g_"+TimeToString(last_signals.ac_3_bars_dn_time[0])))
        {actual_action.ac_3_bar_sell=false;return;}
     }
//--- Red zone
   if(actual_action.zone_sell)    // send sell order
     {
      last_trade.zone=last_signals.zone_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.zone_dn,last_signals.zone_dn_time,"TC_BW_z_"+TimeToString(last_signals.zone_dn_time[0])))
        {actual_action.zone_sell=false;return;}
     }
//--- 2 bars down
   if(actual_action.line_balance_2_bar_sell) // send sell order
     {
      last_trade.five_dimension=last_signals.five_dimension_2_bars_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.five_dimension_2_bars_dn,last_signals.five_dimension_2_bars_dn_time,"BW_lb2_"+TimeToString(last_signals.five_dimension_2_bars_dn_time[0])+DoubleToString(last_signals.five_dimension_2_bars_dn[0],5)))
        {actual_action.line_balance_2_bar_sell=false;return;}
     }
//--- 3 bars down
   if(actual_action.line_balance_3_bar_sell) // send sell order
     {
      last_trade.five_dimension=last_signals.five_dimension_3_bars_dn_time[0];
      if(SendOrder(ORDER_TYPE_SELL,last_signals.five_dimension_3_bars_dn,last_signals.five_dimension_3_bars_dn_time,"BW_lb3_"+TimeToString(last_signals.five_dimension_3_bars_dn_time[0])+DoubleToString(last_signals.five_dimension_3_bars_dn[0],5)))
        {actual_action.line_balance_3_bar_sell=false;return;}
     }
  }

//+------------------------------------------------------------------+
//| Copies the indicator values to the arrays,                       |
//| used for search of the trade signals                             |
//| type - what we need (0 - alligator, 2 - , 3 -   )            |
//| countValue - number of data to copy                              |
//+------------------------------------------------------------------+
bool C_TS_BW::CopyIndValue(int type,int countValue)
  {
   int copyCount=-1;
   switch(type)
     {
      case 0: // alligator
         copyCount=CopyBuffer(h_alligator,0,inp_param.alligator_jaw_shift,countValue,jaw); // Jaw
         //copyCount=CopyBuffer(h_alligator,0,0,countValue,jaw); // jaw
         if(copyCount<1){break;}
         copyCount=CopyBuffer(h_alligator,1,inp_param.alligator_teeth_shift,countValue,teeth); // Teeth
         if(copyCount<1){break;}
         copyCount=CopyBuffer(h_alligator,2,inp_param.alligator_lips_shift,countValue,lips); // Lips
         if(copyCount<1){break;}
         break;
      case 2:     // AO
         copyCount=CopyBuffer(h_ao,0,0,countValue,AO_value);
         if(copyCount<1){break;}
         copyCount=CopyBuffer(h_ao,1,0,countValue,AO_color);
         if(copyCount<1){break;}
         break;
      case 3:     // AC
         copyCount=CopyBuffer(h_ac,0,0,countValue,AC_value);
         if(copyCount<1){break;}
         copyCount=CopyBuffer(h_ac,1,0,countValue,AC_color);
         if(copyCount<1){break;}
         break;
     }
   if(copyCount<1){return(false);}
   else{return(true);}

  }


//+------------------------------------------------------------------+
//|  Search for the signals from the 1st dimension                   |
//+------------------------------------------------------------------+
bool C_TS_BW::FindSignal_1_dimension(int type,double &price_out[],datetime &time_out[])
  {
   int i,copyCount=-1;
   double tmp_buf[1];
   price_out[0]=-1;
   for(i=3;i<50;i++)
     {
      copyCount=CopyBuffer(h_fractals,type,i,1,tmp_buf);
      if(copyCount<1){return(false);}
      if(tmp_buf[0]!=EMPTY_VALUE && price_out[0]==-1)
        {
         price_out[0]=tmp_buf[0];
         CopyTime(m_Symbol,m_Period,i,1,time_out); // copy time of the fractal found
        }
     }
   return(true);
  }

//+------------------------------------------------------------------+
//| Search for the signals from the 2nd direction                    |
//+------------------------------------------------------------------+
bool C_TS_BW::FindSignal_2_dimension(int type,int sub_type,double &price_out[],datetime &time_out[])
  {
   int copyCount=-1;
// AO
   if((AO_value[1]>0 && AO_value[2]<0 && type==0 && sub_type==0) || // upward crossover of zero line
      (AO_color[1]==0 && AO_color[2]==1 && AO_value[2]>0 && type==0 && sub_type==1)) // saucer above the zero line
     {
      CopyHigh(m_Symbol,m_Period,1,1,price_out);
      CopyTime(m_Symbol,m_Period,1,1,time_out);
     }
   if((AO_value[1]<0 && AO_value[2]>0 && type==1 && sub_type==0) || // downward crossover of zero line
      (AO_color[1]==1 && AO_color[2]==0 && AO_value[2]<0 && type==1 && sub_type==1)) // saucer below the zero line
     {
      CopyLow(m_Symbol,m_Period,1,1,price_out);
      CopyTime(m_Symbol,m_Period,1,1,time_out);
     }
   return(true);
  }

//+------------------------------------------------------------------+
//| Search for the signals from the 3rd dimension                    |
//+------------------------------------------------------------------+
bool C_TS_BW::FindSignal_3_dimension(int type,int sub_type,double &price_out[],datetime &time_out[])
  {
   int copyCount=-1;
   if((AC_color[1]==0 && AC_value[1]>0  && 
       AC_color[2]==0 && AC_color[3]==1 && type==0  &&  sub_type==0) || //(buy)  2 bars up
      (AC_color[1]==0 && AC_value[1]<0 && AC_color[2]==0 && AC_color[3]==0 && AC_color[4]==1 && type==0 && sub_type==1)) //(buy)  3 bars up (3rd below the zero line)
     {
      copyCount=CopyHigh(m_Symbol,m_Period,1,1,price_out);
      if(copyCount<1){return(false);}
      CopyTime(m_Symbol,m_Period,1,1,time_out);
     }
   if((AC_color[1]==1  &&  AC_value[1]<0  && 
       AC_color[2]==1  &&  AC_color[3]==0  &&  type==1  &&  sub_type==0) || //(sell)  2 bars down
      (AC_color[1]==1 && AC_value[1]>0 && AC_color[2]==1 && AC_color[3]==1 && AC_color[4]==0 && type==1 && sub_type==1)) //(sell)  3 bars down (3rd above the zero line)
     {
      copyCount=CopyLow(m_Symbol,m_Period,1,1,price_out);
      if(copyCount<1){return(false);}
      CopyTime(m_Symbol,m_Period,1,1,time_out);
     }
   return(true);
  }

//+------------------------------------------------------------------+
//| Search for the signals from the 4rd dimension                    |
//+------------------------------------------------------------------+
bool C_TS_BW::FindSignal_4_dimension(int type,int sub_type,double &price_out[],datetime &time_out[])
  {
   int copyCount=-1;
   bool find_green_zone=true,find_red_zone=true;
   bool limit_green_zone=true,limit_red_zone=true;
   double tmp_h[1],tmp_l[1]; // temporary arrays for Highs and Lows
   if(sub_type==0) // check zones
     {
      copyCount=CopyClose(m_Symbol,m_Period,0,3,Close);
      if(copyCount<1){return(false);}
      if(AO_color[1]==0 && AO_color[2]==0 && AC_color[1]==0 &&
         AC_color[2]==0 && Close[1]>Close[2] && type==0) // 2 green bars
        {
         CopyHigh(m_Symbol,m_Period,1,1,price_out);
         CopyTime(m_Symbol,m_Period,1,1,time_out);
        }
      if(AO_color[1]==1 && AO_color[2]==1 && AC_color[1]==1 && 
         AC_color[2]==1 && Close[1]<Close[2] && type==1) // 2 red bars
        {
         CopyLow(m_Symbol,m_Period,1,1,price_out);
         CopyTime(m_Symbol,m_Period,1,1,time_out);
        }
     }
   if(sub_type==1) // 5 bars trailing stop
     {
      for(int y=1;y<=5;y++)
        {
         if(AO_color[y]==1 || AC_color[y]==1){find_green_zone=false;}
         if(AO_color[y]==0 || AC_color[y]==0){find_red_zone=false;}
        }
      if(find_green_zone && price_out[0]<0 && type==0)
        {
         CopyLow(m_Symbol,m_Period,1,1,price_out);  // set trailing stop price below the Low of the 1st bar (5th green bar)
        }
      if(find_red_zone && price_out[0]<0 && type==1)
        {
         CopyHigh(m_Symbol,m_Period,1,1,price_out); // set trailing stop price above the High of the 1st bar (5th red bar)
        }
      // if necessary, modify stop loss 
      CopyHigh(m_Symbol,m_Period,1,1,tmp_h);
      CopyLow(m_Symbol,m_Period,1,1,tmp_l);
      if(price_out[0]>0 && type==0)
        {
         if(price_out[0]>tmp_l[0]){price_out[0]=-1;}          // stop loss should be executed
         if(price_out[0]<tmp_l[0]){price_out[0]=tmp_l[0];}    // set stop higher
        }
      if(price_out[0]>0 && type==1)
        {
         if(price_out[0]<tmp_h[0]){price_out[0]=-1;}          // stop loss should be executed
         if(price_out[0]>tmp_h[0]){price_out[0]=tmp_h[0];}    // set stop lower
        }
     }//if(sub_type==1)
   if(sub_type==2) // check number of zones
     {
      for(int t=1;t<=inp_param.max_4_dimension_zone;t++)
        {
         if((AO_color[t]==1 || AC_color[t]==1) && type==0){limit_green_zone=false;}
         if((AO_color[t]==0 || AC_color[t]==0) && type==1){limit_red_zone=false;}
        }
      if((limit_green_zone && type==0) || (limit_red_zone && type==1)){price_out[0]=-1;time_out[0]=-1;}
     }
   return(true);
  }

//+------------------------------------------------------------------+
//| Search for the signals from the 5th dimension                    |
//+------------------------------------------------------------------+
bool C_TS_BW::FindSignal_5_dimension(int type,int sub_type,double &price_out[],datetime &time_out[])
  {
   int copyCount=-1;
   int count_2_bars=0,count_3_bars=0,n;
   double high_tmp,low_tmp;
   price_out[0]=-1;
   time_out[0]=-1;
   if(type==0)
     {
      copyCount=CopyHigh(m_Symbol,m_Period,0,10,High);
      if(copyCount<1){return(false);}
      high_tmp=High[0];
      if(High[0]>jaw[0])
        {
         for(n=1;n<10;n++)
           {
            if(high_tmp<High[n]){high_tmp=High[n];count_2_bars++;count_3_bars++;}
            if((count_2_bars==1 && sub_type==0) || (count_3_bars==2 && sub_type==1))
              {
               price_out[0]=high_tmp;
               CopyTime(m_Symbol,m_Period,n,1,time_out);
               break;
              }
           }
        }
     }
   if(type==1)
     {
      copyCount=CopyLow(m_Symbol,m_Period,0,10,Low);
      if(copyCount<1){return(false);}
      low_tmp=Low[0];
      if(Low[0]<jaw[0])
        {
         for(n=1;n<10;n++)
           {
            if(low_tmp>Low[n]){low_tmp=Low[n];count_2_bars++;count_3_bars++;}
            if((count_2_bars==1 && sub_type==0) || (count_3_bars==2 && sub_type==1))
              {
               price_out[0]=low_tmp;
               CopyTime(m_Symbol,m_Period,n,1,time_out);
               break;
              }
           }
        }
     }

   return(false);
  }

//+------------------------------------------------------------------+
//|  Check Trade Signals                                             |
//+------------------------------------------------------------------+
bool C_TS_BW::CheckForTradeSignal(int dimension,int type,int sub_type,double &price_out[],datetime &time_out[])
  {
   int copyCount=-1;
   copyCount=CopyHigh(m_Symbol,m_Period,0,1,High);
   if(copyCount<1){return(false);}
   copyCount=CopyLow(m_Symbol,m_Period,0,1,Low);
   if(copyCount<1){return(false);}
   switch(dimension)
     {
      case 1:   // check Fractals
        {
         if((type==0 && High[0]>price_out[0] && High[0]<teeth[0] && price_out[0]>0) || // cancel Fractal Up signal - price lower than Teeth line of the Alligator
            (type==1 && Low[0]<price_out[0] && Low[0]>teeth[0] && price_out[0]>0))     // cancel Fractal Down signal - price higher than Teeth line of the Alligator
           {
            if(type==0){last_trade.fractal_up=time_out[0];}
            if(type==1){last_trade.fractal_dn=time_out[0];}
            time_out[0]=-1;
            price_out[0]=-1;
            return(false);
            break;
           }
         //--- buy
         if(type==0                                   // buy
            && High[0]>price_out[0]                   // current High>price of the actual Fractal Up
            && time_out[0]!=last_trade.fractal_up     // signal is not used
            && High[0]>teeth[0]                       // current High>Teeth line (0th bar) of the Alligator
            && price_out[0]>0)                        // price of Fractal Up>0 (price<>-1)
           {return(true);}                            // return true
         //--- sell
         if(type==1                                   // sell
            && Low[0]<price_out[0]                    // current Low<price of the actual Fractal Down
            && time_out[0]!=last_trade.fractal_dn     // signal is not used
            && Low[0]<teeth[0]                        // current Low<Teeth line (0th bar) of the Alligator
            && price_out[0]>0)                        // price of Fractal Down<0 (price<>-1)
           {return(true);}                            // return true
         break;
        }
      case 2:   // check AO signals
        {
         if(High[0]>price_out[0] &&  High[0]>teeth[0] &&  price_out[0]>0  &&  type==0  &&  // buy
            ((time_out[0]!=last_trade.ao_blydce && sub_type==1) ||                         // saucer
            (time_out[0]!=last_trade.ao_cross_zero && sub_type==0)))                       // zero line crossover
           {return(true);}
         if(Low[0]<price_out[0] && Low[0]<teeth[0] && price_out[0]>0 && type==1 &&         // sell
            ((time_out[0]!=last_trade.ao_blydce && sub_type==1) ||                         // saucer
            (time_out[0]!=last_trade.ao_cross_zero && sub_type==0)))                       // zero line crossover
           {return(true);}
         break;
        }
      case 3:   // check AC signals
        {
         if(High[0]>price_out[0] &&  High[0]>teeth[0] &&  price_out[0]>0  &&  type==0  &&  // buy
            ((time_out[0]!=last_trade.ac_2_bars && sub_type==0) ||                         // 2 green bars (up)
            (time_out[0]!=last_trade.ac_3_bars && sub_type==1)))                           // 3 green bars (down)
           {
            if(AC_color[0]==1){price_out[0]=-1;time_out[0]=-1;return(false);}              // check AO (cancel signal if the current bar is red)
            else{return(true);}
           }
         if(Low[0]<price_out[0] && Low[0]<teeth[0] && price_out[0]>0 && type==1 &&         // sell
            ((time_out[0]!=last_trade.ac_2_bars && sub_type==0) ||                         // 2 red bars
            (time_out[0]!=last_trade.ac_3_bars && sub_type==1)))                           // 3 red bars
           {
            if(AC_color[0]==0){price_out[0]=-1;time_out[0]=-1;return(false);}              // check AO (cancel signal if the current bar is green)
            else{return(true);}
           }
         break;
        }
      case 4:
        {
         if(High[0]>teeth[0]&& price_out[0]>0 && type==0 && time_out[0]!=last_trade.zone){return(true);}
         if(Low[0]<teeth[0] && price_out[0]>0 && type==1 && time_out[0]!=last_trade.zone){return(true);}
         break;
        }
      case 5:
        {
         if(High[0]>price_out[0] && High[0]>teeth[0] && price_out[0]>0 && type==0 && // buy
            time_out[0]!=last_trade.five_dimension && 
            ((AO_color[0]==0 && AC_color[0]==0 && sub_type==0) ||   // green zone and 2-bar-signal
            ((AO_color[0]==1 || AC_color[0]==1) && sub_type==1)))   // red or grey zone and 3-bar-signal
           {return(true);}
         if(Low[0]<price_out[0] && Low[0]<teeth[0] && price_out[0]>0 && type==1 && // sell
            time_out[0]!=last_trade.five_dimension && 
            ((AO_color[0]==1 && AC_color[0]==1 && sub_type==0) ||   // red zone and 2-bar-signal
            ((AO_color[0]==0 || AC_color[0]==0) && sub_type==1)))   // green or grey zone and 3-bar-signal

           {return(true);}
         break;
        }
      break;
     }
   return(false);// return false by default
  }

//+------------------------------------------------------------------+
//| Send order to trade server and check result                      |
//+------------------------------------------------------------------+
bool C_TS_BW::SendOrder(ENUM_ORDER_TYPE type,double &price_out[],datetime &time_out[],string comment)
  {
// Calculate magic
   bool needCalcMagic=true;
   //Print("mag=",(string) Magic," lot=",Lot);
   if(actual_action.fractal_open_buy || actual_action.fractal_open_sell){needCalcMagic=false;Magic=1000;actual_action.init();}
   if(actual_action.fractal_revers_buy_to_sell || actual_action.fractal_revers_sell_to_buy){needCalcMagic=false;Magic=999;actual_action.init();}
   if(needCalcMagic){CalcMagic(Magic);}

   exp_trade.SetExpertMagicNumber(Magic); // set magic
                                          //exp_trade.PrintRequest();
   double price,sl,tp=0.0;
   bool ret=false;
   s_info.RefreshRates();
// calc lot

   if(Lot<0) // external lot is not defined
     {
      if(inp_param.agress_trade_mm)
        {
         if(Magic==1000){CalcLot(false,0.0,0);}   // initial
         if(Magic==999){CalcLot(false,0.0,-1);}   // reverse
         if(Magic==1005){CalcLot(false,0.0,5);}   // additional 5
         if(Magic==1004){CalcLot(false,0.0,4);}   // additional 4
         if(Magic==1003){CalcLot(false,0.0,3);}   // additional 3
         if(Magic==1002){CalcLot(false,0.0,2);}   // additional 2
         if(Magic==1001){CalcLot(false,0.0,1);}   // additional 1
        }
      else
        {
         if(Magic>=1000 && Magic<=1005){CalcLot(false,0.0,1);}  // initial 
         if(Magic==999){CalcLot(false,0.0,-1);}   // reverse
        }
     }
   //Print("m=",(string) Magic," lot=",Lot);
   if(type==ORDER_TYPE_BUY)
     {
      price=s_info.Ask();
      //sl=NormalizeDouble(jaw[0],s_info.Digits());
      sl=0.0;
      if(exp_trade.PositionOpen(m_Symbol,ORDER_TYPE_BUY,Lot,price,sl,0.0,comment))
        {ret=true;}
     }
   if(type==ORDER_TYPE_SELL)
     {
      price=s_info.Bid();
      //sl=NormalizeDouble(jaw[0],s_info.Digits());
      sl=0.0;
      if(exp_trade.PositionOpen(m_Symbol,ORDER_TYPE_SELL,Lot,price,sl,0.0,comment))
        {ret=true;}
     }
   price_out[0]=-1; time_out[0]=-1;Lot=-1.0;

   if(ret)
     {
      if(actual_action.fractal_open_buy || actual_action.fractal_open_sell){actual_action.init();}
      if(actual_action.fractal_revers_buy_to_sell || actual_action.fractal_revers_sell_to_buy){actual_action.init();}
     }

   return(ret);
  }
//+------------------------------------------------------------------+
//|  Calc lot                                                        |
//+------------------------------------------------------------------+
void C_TS_BW::CalcLot(bool external,double ext_lot,int type)
  {
   if(external){Lot=ext_lot;return;}
   if(!external)
     {
      if(type==0) // initial
        {if(inp_param.lot>0){Lot=inp_param.lot;}}
      if(type==-1) // reverse
        {if(inp_param.lot>0){Lot=inp_param.lot+pos_info.Volume();}}
      if(type==5) // additional 5
        {if(inp_param.lot>0){Lot=inp_param.lot*5;}}
      if(type==4) // additional 4
        {if(inp_param.lot>0){Lot=inp_param.lot*4;}}
      if(type==3) // additional 3
        {if(inp_param.lot>0){Lot=inp_param.lot*3;}}
      if(type==2) // additional 2
        {if(inp_param.lot>0){Lot=inp_param.lot*2;}}
      if(type==1) // additional 1
        {if(inp_param.lot>0){Lot=inp_param.lot*1;}}
     }

  }

//+------------------------------------------------------------------+
//|  Check Actions                                                   |
//+------------------------------------------------------------------+
void C_TS_BW::CheckActionOnTick(void)
  {
   bool select_pos=pos_info.Select(m_Symbol);
/// no position - check entry conditions (Fractals) outside the Alligator's Jaws

   if(CheckForTradeSignal(1,0,0,last_signals.fractal_up,last_signals.fractal_up_time)) // buy
     {
      if(!select_pos){actual_action.fractal_open_buy=true;} // no positions - use initial lot
      if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY && inp_param.add_1_dimension && last_signals.alligator_trend[0]){actual_action.fractal_add_buy=true;} // long position opened - use additional lot
      if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL){actual_action.fractal_revers_sell_to_buy=true;} // Short position opened - use reversal lot
     }
   if(CheckForTradeSignal(1,1,0,last_signals.fractal_dn,last_signals.fractal_dn_time)) // sell
     {
      if(!select_pos){actual_action.fractal_open_sell=true;} // no positions - use initial lot
      if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL && inp_param.add_1_dimension  && last_signals.alligator_trend[1]){actual_action.fractal_add_sell=true;} // Short position opened - use additional lot
      if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY){actual_action.fractal_revers_buy_to_sell=true;} // Long position opened - use reversal lot
     }
//---additions to long position (from 2-5 dimensions)
   if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_BUY) // additions to long position
     {
      //---AO saucer
      if(inp_param.add_2_dimension_bludce && CheckForTradeSignal(2,0,1,last_signals.bludce_up,last_signals.bludce_up_time))
        {actual_action.ao_bludce_buy=true;}
      //--- AO zero line crossover
      if(inp_param.add_2_dimension_cross_zero && CheckForTradeSignal(2,0,0,last_signals.cross_zero_up,last_signals.cross_zero_up_time))
        {actual_action.ao_cross_zero_buy=true;}
      //--- AC 2 bars up
      if(inp_param.add_3_dimension_use_2_bars && CheckForTradeSignal(3,0,0,last_signals.ac_2_bars_up,last_signals.ac_2_bars_up_time)) 
        {actual_action.ac_2_bar_buy=true;}
      //--- AC 3 bars up
      if(inp_param.add_3_dimension_use_3_bars && CheckForTradeSignal(3,0,1,last_signals.ac_3_bars_up,last_signals.ac_3_bars_up_time))
        {actual_action.ac_3_bar_buy=true;}
      //--- green zone (AO+AC)
      if(inp_param.add_4_dimension_zone && CheckForTradeSignal(4,0,0,last_signals.zone_up,last_signals.zone_up_time))
        {actual_action.zone_buy=true;}
      //--- 5th dimension: 2 bars buy signal
      if(inp_param.add_5_dimension && CheckForTradeSignal(5,0,0,last_signals.five_dimension_2_bars_up,last_signals.five_dimension_2_bars_up_time))
        {actual_action.line_balance_2_bar_buy=true;}
      //--- 5th dimension: 3 bars buy signal
      if(inp_param.add_5_dimension && CheckForTradeSignal(5,0,1,last_signals.five_dimension_3_bars_up,last_signals.five_dimension_3_bars_up_time))
        {actual_action.line_balance_3_bar_buy=true;}

     }
//--- additions to short position (from 2-5 dimensions)
   if(select_pos && (ENUM_POSITION_TYPE)pos_info.PositionType()==POSITION_TYPE_SELL) /// additions to short positions
     {
      //--- saucer
      if(inp_param.add_2_dimension_bludce && CheckForTradeSignal(2,1,1,last_signals.bludce_dn,last_signals.bludce_dn_time))
        {actual_action.ao_bludce_sell=true;}
      //--- AO zero line crossover
      if(inp_param.add_2_dimension_cross_zero && CheckForTradeSignal(2,1,0,last_signals.cross_zero_dn,last_signals.cross_zero_dn_time))
        {actual_action.ao_cross_zero_sell=true;}
      //--- AC 2 bars down
      if(inp_param.add_3_dimension_use_2_bars && CheckForTradeSignal(3,1,0,last_signals.ac_2_bars_dn,last_signals.ac_2_bars_dn_time))
        {actual_action.ac_2_bar_sell=true;}
      //--- AC 3 bars down
      if(inp_param.add_3_dimension_use_3_bars && CheckForTradeSignal(3,1,1,last_signals.ac_3_bars_dn,last_signals.ac_3_bars_dn_time))
        {actual_action.ac_3_bar_sell=true;}
      //--- red zone (AO+AC)
      if(inp_param.add_4_dimension_zone && CheckForTradeSignal(4,1,0,last_signals.zone_dn,last_signals.zone_dn_time))
        {actual_action.zone_sell=true;}
      //--- 5th dimension: 2 bars sell signal
      if(inp_param.add_5_dimension && CheckForTradeSignal(5,1,0,last_signals.five_dimension_2_bars_dn,last_signals.five_dimension_2_bars_dn_time))
        {actual_action.line_balance_2_bar_sell=true;}
      //--- 5th dimension: 3 bars sell signal
      if(inp_param.add_5_dimension && CheckForTradeSignal(5,1,1,last_signals.five_dimension_3_bars_dn,last_signals.five_dimension_3_bars_dn_time))
        {actual_action.line_balance_3_bar_sell=true;}
     }
   return;
  }
//+------------------------------------------------------------------+
//|  Calculate magic                                                 |
//+------------------------------------------------------------------+
ulong C_TS_BW::CalcMagic(ulong  &magic)
  {
   if(magic==-1) // after start
     {
      HistorySelect(TimeCurrent()-PeriodSeconds(PERIOD_MN1)*3,TimeCurrent());
      int countHistoryOrders=HistoryOrdersTotal();
      for(int n=countHistoryOrders-1;n>=0;n++)
        {
         h_info.SelectByIndex(n);
         magic=h_info.Magic();
         if(magic>0 && h_info.Symbol()==m_Symbol && magic>1000 && magic<=1005)
           {
            break;
           }
        }
     }
// set new magic
   switch(magic)
     {
      case 999: // the last order used - reverse
        {magic=1005;break;}
      case 1000: // the last order used - initial
        {magic=1005;break;}
      case 1005: // the last order used - 2nd order of the position (if inp_param.agress_trade_mm then 5)
        {magic=1004;break;}
      case 1004: // the last order used - 3rd order of the position (if inp_param.agress_trade_mm then 4)
        {magic=1003;break;}
      case 1003: // the last order used - 4th order of the position (if inp_param.agress_trade_mm then 3)
        {magic=1002;break;}
      case 1002: // the last order used - 5th order of the position (if inp_param.agress_trade_m then 2)
        {magic=1001;break;}
      case 1001: // the last order used - 6th order of the position (if inp_param.agress_trade_mm then 1)
        {magic=1001;break;}
     }
   return(magic);
  }
//+------------------------------------------------------------------+
//|  Set Stop Loss                                                   |
//+------------------------------------------------------------------+
void C_TS_BW::SetStopLoss(double &stoploss)
  {StopLoss=stoploss;return;}

//+------------------------------------------------------------------+
//| The End                                                          |
//+------------------------------------------------------------------+
