//+------------------------------------------------------------------+
//|                                                      MegaChu.mq4 |
//|                      Copyright  2010, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window

extern int    BeginFractal = 3;
extern int    EndFractal   = 1000;
extern color  UpColor      = Lime;
extern color  DnColor      = Red;
extern int    UpWidth      = 20;
extern int    DnWidth      = 20;

double fr_up[6];
double fr_dn[6];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----

if(BeginFractal<3) BeginFractal=3;
if(EndFractal<=BeginFractal || EndFractal>Bars-1) EndFractal=Bars-1;

DeleteUpLines();
DeleteDnLines();

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----

DeleteUpLines();
DeleteDnLines();
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
static int prewbar;
  
  if(prewbar==iTime(Symbol(),0,0)) return;
  prewbar= iTime(Symbol(),0,0);
//----

int j=0;
ArrayInitialize(fr_up, 0);
for(int i=BeginFractal; i<=EndFractal; i++)
  { fr_up[j]=iFractals(Symbol(), 0, MODE_UPPER, i);
    if(fr_up[j]>0) 
      { fr_up[j+1]=i;
        j=j+2;
       }
    if(j>4) 
      { if(CheckUpLines()<0)
          { j=0; i=fr_up[3]-1;
            ArrayInitialize(fr_up, 0);
           }
        else
          { CreateUpLines();
            break;
           }
       }
   }

j=0;
ArrayInitialize(fr_dn, 0);
for(i=BeginFractal; i<=EndFractal; i++)
  { fr_dn[j]=iFractals(Symbol(), 0, MODE_LOWER, i);
    if(fr_dn[j]>0) 
      { fr_dn[j+1]=i;
        j=j+2;
       }
    if(j>4) 
      { if(CheckDnLines()<0)
          { j=0; i=fr_dn[3]-1;
            ArrayInitialize(fr_dn, 0);
           }
        else
          { CreateDnLines();
            break;
           }
       }
   }
      
//----
return(0);
}
//+------------------------------------------------------------------+
int CheckUpLines()
{

double tan1=MathTan((fr_up[0]-fr_up[2])/(fr_up[1]-fr_up[3]));
double tan2=MathTan((fr_up[2]-fr_up[4])/(fr_up[3]-fr_up[5]));

if(tan1>0 && tan2>0 && tan1<tan2) return(1);

return(-1);
}
//+------------------------------------------------------------------+
int CheckDnLines()
{

double tan1=MathTan((fr_dn[0]-fr_dn[2])/(fr_dn[1]-fr_dn[3]));
double tan2=MathTan((fr_dn[2]-fr_dn[4])/(fr_dn[3]-fr_dn[5]));

if(tan1<0 && tan2<0 && tan1>tan2) return(1);

return(-1);
}
//--------------------------------------------------------------------------------
void CreateUpLines()
{

  if(ObjectFind("UPCHUV2")>=0)
    if(ObjectGet("UPCHUV2", OBJPROP_PRICE1)!=fr_up[4] || ObjectGet("UPCHUV2", OBJPROP_PRICE2)!=fr_up[2])
      DeleteUpLines();
    else
      return;
  if(ObjectFind("UPCHUV1")>=0)
    if(ObjectGet("UPCHUV1", OBJPROP_PRICE1)!=fr_up[2] || ObjectGet("UPCHUV1", OBJPROP_PRICE2)!=fr_up[0])
      DeleteUpLines();
    else
      return;
      
   ObjectCreate("UPCHUV2", OBJ_TREND, 0, iTime(Symbol(), 0, fr_up[5]), fr_up[4], iTime(Symbol(), 0, fr_up[3]), fr_up[2]);
   ObjectSet("UPCHUV2", OBJPROP_COLOR, UpColor); 
   ObjectSet("UPCHUV2", OBJPROP_WIDTH, UpWidth);
   ObjectCreate("UPCHUV1", OBJ_TREND, 0, iTime(Symbol(), 0, fr_up[3]), fr_up[2], iTime(Symbol(), 0, fr_up[1]), fr_up[0]);
   ObjectSet("UPCHUV1", OBJPROP_COLOR, UpColor); 
   ObjectSet("UPCHUV1", OBJPROP_WIDTH, UpWidth);

return;
}

//-------------------------------------------------------------------
void CreateDnLines()
{

  if(ObjectFind("DNCHUV2")>=0)
    if(ObjectGet("DNCHUV2", OBJPROP_PRICE1)!=fr_dn[4] || ObjectGet("DNCHUV2", OBJPROP_PRICE2)!=fr_dn[2])
      DeleteDnLines();
    else
      return;
  if(ObjectFind("DNCHUV1")>=0)
    if(ObjectGet("DNCHUV1", OBJPROP_PRICE1)!=fr_dn[2] || ObjectGet("DNCHUV1", OBJPROP_PRICE2)!=fr_dn[0])
      DeleteDnLines();
    else
      return;
  ObjectCreate("DNCHUV2", OBJ_TREND, 0, iTime(Symbol(), 0, fr_dn[5]), fr_dn[4], iTime(Symbol(), 0, fr_dn[3]), fr_dn[2]);
  ObjectSet("DNCHUV2", OBJPROP_COLOR, DnColor); 
  ObjectSet("DNCHUV2", OBJPROP_WIDTH, DnWidth);
  ObjectCreate("DNCHUV1", OBJ_TREND, 0, iTime(Symbol(), 0, fr_dn[3]), fr_dn[2], iTime(Symbol(), 0, fr_dn[1]), fr_dn[0]);
  ObjectSet("DNCHUV1", OBJPROP_COLOR, DnColor); 
  ObjectSet("DNCHUV1", OBJPROP_WIDTH, DnWidth);

return;
}

//---------------------------------------------------------------------------------

void DeleteUpLines()
{

if(ObjectFind("UPCHUV1")>=0) ObjectDelete("UPCHUV1");
if(ObjectFind("UPCHUV2")>=0) ObjectDelete("UPCHUV2");

}
//---------------------------------------------------------------------------------

void DeleteDnLines()
{

if(ObjectFind("DNCHUV1")>=0) ObjectDelete("DNCHUV1");
if(ObjectFind("DNCHUV2")>=0) ObjectDelete("DNCHUV2");

}