//+------------------------------------------------------------------+
//|                                                    Camarilla.mq4 |
//|                                                 George Tischenko |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "George Tischenko"

#property indicator_chart_window
extern color CENTER=White,
             ZONE1=PowderBlue,
             ZONE2=DeepSkyBlue,
             BUFFER=Silver,
             EXTERNAL=Wheat,
             LastClose=Magenta;

int day;
bool A=false;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  if(Period()>240)
    {
    A=true;
    Alert("      H4");
    return(0);
    }
//---- indicators
  ObjectCreate("LC",OBJ_TREND,0,0,0,0,0);       //   
  ObjectSet("LC",OBJPROP_COLOR,LastClose);
  ObjectSet("LC",OBJPROP_STYLE,STYLE_SOLID);
  ObjectSet("LC",OBJPROP_WIDTH,3);

  ObjectCreate("L1H1",OBJ_RECTANGLE,0,0,0,0,0); // , 
  ObjectSet("L1H1",OBJPROP_COLOR,CENTER);
  
  ObjectCreate("H1H2",OBJ_RECTANGLE,0,0,0,0,0); // ,    
  ObjectSet("H1H2",OBJPROP_COLOR,ZONE1);
  
  ObjectCreate("L1L2",OBJ_RECTANGLE,0,0,0,0,0); // ,    
  ObjectSet("L1L2",OBJPROP_COLOR,ZONE1);
  
  ObjectCreate("H2H3",OBJ_RECTANGLE,0,0,0,0,0); // ,    
  ObjectSet("H2H3",OBJPROP_COLOR,ZONE2);
  
  ObjectCreate("L2L3",OBJ_RECTANGLE,0,0,0,0,0); // ,    
  ObjectSet("L2L3",OBJPROP_COLOR,ZONE2);
  
  ObjectCreate("H3H4",OBJ_RECTANGLE,0,0,0,0,0); //  
  ObjectSet("H3H4",OBJPROP_COLOR,BUFFER);
  
  ObjectCreate("L3L4",OBJ_RECTANGLE,0,0,0,0,0); //  
  ObjectSet("L3L4",OBJPROP_COLOR,BUFFER);
  
  ObjectCreate("H4H5",OBJ_RECTANGLE,0,0,0,0,0); //  
  ObjectSet("H4H5",OBJPROP_COLOR,EXTERNAL);
  
  ObjectCreate("L4L5",OBJ_RECTANGLE,0,0,0,0,0); //  
  ObjectSet("L4L5",OBJPROP_COLOR,EXTERNAL);
  
//----
  return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  ObjectDelete("LC");
  ObjectDelete("H4H5");
  ObjectDelete("H3H4");
  ObjectDelete("H2H3");
  ObjectDelete("H1H2");
  ObjectDelete("L1H1");
  ObjectDelete("L1L2");
  ObjectDelete("L2L3");
  ObjectDelete("L3L4");
  ObjectDelete("L4L5");
//----
  return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  if(A==true) return(0);
  if(day!=TimeDay(Time[0])) { //     ...
  int i=0,k,D=Time[0];
//----   
  day=TimeDay(Time[0]);
  while(TimeDay(D)==day) D+=60*Period();                  //    ...
  while(TimeDay(Time[i])==day) i++;                       //    
  k=i;
  day=TimeDay(Time[i]);
  while(TimeDay(Time[i])==day) i++;                       //    
  i--;                                                    //    
//----  Close, High, Low   
  double LastClose=Close[k];                              
  double LastHigh=High[iHighest(NULL,0,MODE_HIGH,i-k,k)]; 
  double LastLow=Low[iLowest(NULL,0,MODE_LOW,i-k,k)];
  k--;                                                    //    
//----   
  double H5=(LastHigh/LastLow)*LastClose;
  double H4=LastClose+((LastHigh-LastLow)*0.55);
  double H3=LastClose+((LastHigh-LastLow)*0.275);
  double H2=LastClose+((LastHigh-LastLow)*0.1833);
  double H1=LastClose+((LastHigh-LastLow)*0.0917);
  
  double L1=LastClose-((LastHigh-LastLow)*0.0917);
  double L2=LastClose-((LastHigh-LastLow)*0.1833); 
  double L3=LastClose-((LastHigh-LastLow)*0.275);
  double L4=LastClose-((LastHigh-LastLow)*0.55);
  double L5=(2*LastClose)-H5;
  
//----   
  ObjectSet("LC",OBJPROP_TIME1,Time[k]);
  ObjectSet("LC",OBJPROP_PRICE1,LastClose);
  ObjectSet("LC",OBJPROP_TIME2,D);
  ObjectSet("LC",OBJPROP_PRICE2,LastClose);

//----    
  ObjectSet("H4H5",OBJPROP_TIME1,Time[k]);
  ObjectSet("H4H5",OBJPROP_PRICE1,H4);
  ObjectSet("H4H5",OBJPROP_TIME2,D);
  ObjectSet("H4H5",OBJPROP_PRICE2,H5);

  ObjectSet("H3H4",OBJPROP_TIME1,Time[k]);
  ObjectSet("H3H4",OBJPROP_PRICE1,H3);
  ObjectSet("H3H4",OBJPROP_TIME2,D);
  ObjectSet("H3H4",OBJPROP_PRICE2,H4);
  
  ObjectSet("H2H3",OBJPROP_TIME1,Time[k]);
  ObjectSet("H2H3",OBJPROP_PRICE1,H2);
  ObjectSet("H2H3",OBJPROP_TIME2,D);
  ObjectSet("H2H3",OBJPROP_PRICE2,H3);
  
  ObjectSet("H1H2",OBJPROP_TIME1,Time[k]);
  ObjectSet("H1H2",OBJPROP_PRICE1,H1);
  ObjectSet("H1H2",OBJPROP_TIME2,D);
  ObjectSet("H1H2",OBJPROP_PRICE2,H2);
  
  ObjectSet("L1H1",OBJPROP_TIME1,Time[k]);
  ObjectSet("L1H1",OBJPROP_PRICE1,L1);
  ObjectSet("L1H1",OBJPROP_TIME2,D);
  ObjectSet("L1H1",OBJPROP_PRICE2,H1);
  
  ObjectSet("L1L2",OBJPROP_TIME1,Time[k]);
  ObjectSet("L1L2",OBJPROP_PRICE1,L1);
  ObjectSet("L1L2",OBJPROP_TIME2,D);
  ObjectSet("L1L2",OBJPROP_PRICE2,L2);
  
  ObjectSet("L2L3",OBJPROP_TIME1,Time[k]);
  ObjectSet("L2L3",OBJPROP_PRICE1,L2);
  ObjectSet("L2L3",OBJPROP_TIME2,D);
  ObjectSet("L2L3",OBJPROP_PRICE2,L3);
 
  ObjectSet("L3L4",OBJPROP_TIME1,Time[k]);
  ObjectSet("L3L4",OBJPROP_PRICE1,L3);
  ObjectSet("L3L4",OBJPROP_TIME2,D);
  ObjectSet("L3L4",OBJPROP_PRICE2,L4);
  
  ObjectSet("L4L5",OBJPROP_TIME1,Time[k]);
  ObjectSet("L4L5",OBJPROP_PRICE1,L4);
  ObjectSet("L4L5",OBJPROP_TIME2,D);
  ObjectSet("L4L5",OBJPROP_PRICE2,L5);
  
  } //   
//----
  return(0);
  }
//+------------------------------------------------------------------+