//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#property copyright "IgorM"
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_width1 2
#property indicator_color2 Yellow
#property indicator_width2 1
#property indicator_style2 1
#property indicator_color3 Lime
#property indicator_width3 1
#property indicator_style3 2

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

extern int short_term_SMA_period=20;
extern int long_term_EMA_period =40;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexLabel(0,"EURX");
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexLabel(1,short_term_SMA_period+"SMA");
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexLabel(2,long_term_EMA_period+"EMA");
   IndicatorShortName("EUR_Index_SMA_EMA: EURX / "+short_term_SMA_period+"SMA / "+long_term_EMA_period+"EMA");
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
//   int limit;
//   int counted_bars=IndicatorCounted();
//   if(counted_bars<0) return(-1);
//   if(counted_bars>0) counted_bars--;
//   limit=Bars-counted_bars;
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=1+short_term_SMA_period;

   for(int i=limit; i>=0; i--) //   
      ExtMapBuffer1[i]=34.38805726*MathPow(iClose("EURUSD",0,i),0.3155) *
                       MathPow(iClose("EURGBP",0,i),0.3056)* MathPow(iClose("EURJPY",0,i),0.1891) *
                       MathPow(iClose("EURCHF",0,i),0.1113)* MathPow(iClose("EURSEK",0,i),0.0785);

   for(i=limit; i>=0; i--)
     {
      ExtMapBuffer2[i]=0;
      ExtMapBuffer3[i]=0;

      for(int z=0; z<short_term_SMA_period; z++)ExtMapBuffer2[i]=ExtMapBuffer2[i]+ExtMapBuffer1[i+z];    // 
      ExtMapBuffer2[i] = ExtMapBuffer2[i]/short_term_SMA_period;                                         //   -  SMA

      if(ExtMapBuffer1[i]>0)ExtMapBuffer3[i]=ExtMapBuffer1[i]*(2.0/(long_term_EMA_period+1))+ExtMapBuffer3[i+1]*(1-(2.0/(long_term_EMA_period+1)));   // EMA   
     }
  }
//+------------------------------------------------------------------+
