//+------------------------------------------------------------------+
//| CoreWinTT     ! :)                           
//+------------------------------------------------------------------+

#property link      "CoreWinTT"

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 Aqua
#property indicator_color2 Aqua
#property indicator_color3 Magenta
#property indicator_color4 Magenta
#property indicator_color5 MediumPurple
#property indicator_color6 MediumPurple

extern bool UseGlobal=true;

extern double ColdSintez=1;
extern int ElderEMA=13;
extern int FastEMA=12;
extern int SlowEMA=26;
extern int SignalEMA=9;
extern int OsmaX=2;

extern bool TwoColor=false;

extern int PozzX = 10;
extern int PozzY = 30;
extern int Font_Size = 9;
extern bool ShowInfo =false;
string Label="ImpulseMACD_Xopen_Shadow";
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexStyle(4,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexStyle(5,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexBuffer(5,ExtMapBuffer6);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   bool UseOneColor=false;
   if(UseGlobal)
     {
      int dt;
      if((Time[0]-Time[1])>(Time[1]-Time[2])) dt=(Time[1]-Time[2])/60;
      else dt=(Time[0]-Time[1])/60;
      ElderEMA=  GlobalVariableGet("BMACD4_"+dt+Symbol()+"ElderEMA");
      FastEMA =   GlobalVariableGet("BMACD4_"+dt+Symbol()+"FastEMA");
      SlowEMA =   GlobalVariableGet("BMACD4_"+dt+Symbol()+"SlowEMA");
      SignalEMA=GlobalVariableGet("BMACD4_"+dt+Symbol()+"SignalEMA");
      if(GlobalVariableGet("BMACD4_"+dt+Symbol()+"TwoColor")==0) TwoColor=false;
      else TwoColor=true;
     }

   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int i = Bars - counted_bars;
   if(counted_bars==0) i--;
   
   while(i>=0)
     {
      double L_1 = iCustom(NULL,0,"Bestmacd_v5",ColdSintez,ElderEMA,FastEMA,SlowEMA,SignalEMA,OsmaX,TwoColor,true,true,2,i); //buy 
      double L_2 = iCustom(NULL,0,"Bestmacd_v5",ColdSintez,ElderEMA,FastEMA,SlowEMA,SignalEMA,OsmaX,TwoColor,true,true,1,i); //sell

      if(L_1!=0.0)
        {
         ExtMapBuffer1[i]=High[i];ExtMapBuffer2[i]=Low[i];
         ExtMapBuffer3[i]=Open[i];ExtMapBuffer4[i]=Open[i];
         ExtMapBuffer5[i]=Open[i];ExtMapBuffer6[i]=Open[i];

        }
      else{if(L_2!=0.0)
           {
            ExtMapBuffer3[i]=High[i];ExtMapBuffer4[i]=Low[i];
            ExtMapBuffer1[i]=Open[i];ExtMapBuffer2[i]=Open[i];
            ExtMapBuffer5[i]=Open[i];ExtMapBuffer6[i]=Open[i];


           }
         else
           {
            ExtMapBuffer5[i]=High[i];ExtMapBuffer6[i]=Low[i];
            ExtMapBuffer1[i]=Open[i];ExtMapBuffer2[i]=Open[i];
            ExtMapBuffer3[i]=Open[i];ExtMapBuffer4[i]=Open[i];

           }
        }

      i--;

     }
//----
   if(ShowInfo==True)
     {
      double  Lk_1 = iCustom(NULL,0,"Bestmacd_v5",ColdSintez,ElderEMA,FastEMA,SlowEMA,SignalEMA,OsmaX,TwoColor,true,true,2,0); //buy 
      double  Lk_2 = iCustom(NULL,0,"Bestmacd_v5",ColdSintez,ElderEMA,FastEMA,SlowEMA,SignalEMA,OsmaX,TwoColor,true,true,1,0); //sell


      if(Lk_1!=0.0)
        {

         ObjectCreate(Label, OBJ_LABEL, 0, 0, 0);//  .   
         ObjectSet(Label, OBJPROP_CORNER, 1);    //     
         ObjectSet(Label, OBJPROP_XDISTANCE, PozzX);//     
         ObjectSet(Label, OBJPROP_YDISTANCE, PozzY);//  y
         ObjectSetText(Label,"MA("+ElderEMA+")MACD("+FastEMA+","+SlowEMA+","+SignalEMA+")",Font_Size,"Arial Black",Aqua);   // ("MACD("+FastEMA+","+SlowEMA+","+SignalEMA+")");
         WindowRedraw();
        }

      else{if(Lk_2!=0)
           {
            ObjectCreate(Label, OBJ_LABEL, 0, 0, 0);//  .   
            ObjectSet(Label, OBJPROP_CORNER, 1);    //     
            ObjectSet(Label, OBJPROP_XDISTANCE, PozzX);//     
            ObjectSet(Label, OBJPROP_YDISTANCE, PozzY);//  y
            ObjectSetText(Label,"MA("+ElderEMA+")MACD("+FastEMA+","+SlowEMA+","+SignalEMA+")",Font_Size,"Arial Black",Magenta);
            WindowRedraw();

           }
         else
           {
            ObjectCreate(Label, OBJ_LABEL, 0, 0, 0);//  .   
            ObjectSet(Label, OBJPROP_CORNER, 1);    //     
            ObjectSet(Label, OBJPROP_XDISTANCE, PozzX);//     
            ObjectSet(Label, OBJPROP_YDISTANCE, PozzY);//  y
            ObjectSetText(Label,"MA("+ElderEMA+")MACD("+FastEMA+","+SlowEMA+","+SignalEMA+")",Font_Size,"Arial Black",Purple);
            WindowRedraw();

           }
        }

     }
   return(0);
  }
//+------------------------------------------------------------------+
